/*   SCE CONFIDENTIAL                                       */
/*   PLAYSTATION(R)3 Programmer Tool Runtime Library 154.001 */
/*   Copyright (C) 2006 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */

CELL_GCM_DECL void CELL_GCM_FUNC(SetReferenceCommand)(CELL_GCM_ARGS(const uint32_t ref))
{
	return CELL_GCM_CALLEE(SetReferenceCommand)(CELL_GCM_THIS, ref);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetJumpCommand)(CELL_GCM_ARGS(const uint32_t offset))
{
	return CELL_GCM_CALLEE(SetJumpCommand)(CELL_GCM_THIS, offset);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetCallCommand)(CELL_GCM_ARGS(const uint32_t offset))
{
	return CELL_GCM_CALLEE(SetCallCommand)(CELL_GCM_THIS, offset);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetReturnCommand)(CELL_GCM_NO_ARGS())
{
	return CELL_GCM_CALLEE(SetReturnCommand)(CELL_GCM_THIS);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetNopCommand)(CELL_GCM_ARGS(const uint32_t count))
{
	return CELL_GCM_CALLEE(SetNopCommand)(CELL_GCM_THIS, count);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetSurface)(CELL_GCM_ARGS(const CellGcmSurface *surface))
{
	return CELL_GCM_CALLEE(SetSurface)(CELL_GCM_THIS, surface);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetAntiAliasingControl)(CELL_GCM_ARGS(const uint32_t enable, const uint32_t alphaToCoverage, const uint32_t alphaToOne, const uint32_t sampleMask))
{
	return CELL_GCM_CALLEE(SetAntiAliasingControl)(CELL_GCM_THIS, enable, alphaToCoverage, alphaToOne, sampleMask);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetWaitLabel)(CELL_GCM_ARGS(const uint8_t index, const uint32_t value))
{
	return CELL_GCM_CALLEE(SetWaitLabel)(CELL_GCM_THIS, index,value);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetWriteCommandLabel)(CELL_GCM_ARGS(const uint8_t index, const uint32_t value))
{
	return CELL_GCM_CALLEE(SetWriteCommandLabel)(CELL_GCM_THIS, index, value);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetWriteBackEndLabel)(CELL_GCM_ARGS(const uint8_t index, const uint32_t value))
{
	return CELL_GCM_CALLEE(SetWriteBackEndLabel)(CELL_GCM_THIS, index, value);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetWriteTextureLabel)(CELL_GCM_ARGS(const uint8_t index, const uint32_t value))
{
	return CELL_GCM_CALLEE(SetWriteTextureLabel)(CELL_GCM_THIS, index, value);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetTimeStamp)(CELL_GCM_ARGS(const uint32_t index))
{
	return CELL_GCM_CALLEE(SetTimeStamp)(CELL_GCM_THIS, index);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetInvalidateZcull)(CELL_GCM_NO_ARGS())
{
	return CELL_GCM_CALLEE(SetInvalidateZcull)(CELL_GCM_THIS);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetAlphaFunc)(CELL_GCM_ARGS(const uint32_t af, const uint32_t ref))
{
	return CELL_GCM_CALLEE(SetAlphaFunc)(CELL_GCM_THIS, af, ref);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetBlendColor)(CELL_GCM_ARGS(const uint32_t color, const uint32_t color2))
{
	return CELL_GCM_CALLEE(SetBlendColor)(CELL_GCM_THIS, color,color2);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetBlendEquation)(CELL_GCM_ARGS(const uint16_t color, const uint16_t alpha))
{
	return CELL_GCM_CALLEE(SetBlendEquation)(CELL_GCM_THIS, color,alpha);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetBlendFunc)(CELL_GCM_ARGS(const uint16_t sfcolor, const uint16_t dfcolor, const uint16_t sfalpha, const uint16_t dfalpha))
{
	return CELL_GCM_CALLEE(SetBlendFunc)(CELL_GCM_THIS, sfcolor,dfcolor,sfalpha,dfalpha);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetClearSurface)(CELL_GCM_ARGS(const uint32_t mask))
{
	return CELL_GCM_CALLEE(SetClearSurface)(CELL_GCM_THIS, mask);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetClearColor)(CELL_GCM_ARGS(const uint32_t color))
{
	return CELL_GCM_CALLEE(SetClearColor)(CELL_GCM_THIS, color);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetClearDepthStencil)(CELL_GCM_ARGS(const uint32_t value))
{
	return CELL_GCM_CALLEE(SetClearDepthStencil)(CELL_GCM_THIS, value);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetColorMask)(CELL_GCM_ARGS(const uint32_t mask))
{
	return CELL_GCM_CALLEE(SetColorMask)(CELL_GCM_THIS, mask);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetColorMaskMrt)(CELL_GCM_ARGS(const uint32_t mask))
{
	return CELL_GCM_CALLEE(SetColorMaskMrt)(CELL_GCM_THIS, mask);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetCullFace)(CELL_GCM_ARGS(const uint32_t cfm))
{
	return CELL_GCM_CALLEE(SetCullFace)(CELL_GCM_THIS, cfm);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetDepthBounds)(CELL_GCM_ARGS(const float zmin, const float zmax))
{
	return CELL_GCM_CALLEE(SetDepthBounds)(CELL_GCM_THIS, zmin,zmax);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetDepthFunc)(CELL_GCM_ARGS(const uint32_t zf))
{
	return CELL_GCM_CALLEE(SetDepthFunc)(CELL_GCM_THIS, zf);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetDepthMask)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetDepthMask)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetFrontFace)(CELL_GCM_ARGS(const uint32_t dir))
{
	return CELL_GCM_CALLEE(SetFrontFace)(CELL_GCM_THIS, dir);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetLineWidth)(CELL_GCM_ARGS(const uint32_t width))
{
	return CELL_GCM_CALLEE(SetLineWidth)(CELL_GCM_THIS, width);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetLineSmoothEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetLineSmoothEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetLineStippleEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetLineStippleEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetLineStipplePattern)(CELL_GCM_ARGS(const uint16_t* pattern, const uint8_t factor))
{
	return CELL_GCM_CALLEE(SetLineStipplePattern)(CELL_GCM_THIS, pattern,factor);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetLogicOp)(CELL_GCM_ARGS(const uint32_t op))
{
	return CELL_GCM_CALLEE(SetLogicOp)(CELL_GCM_THIS, op);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetPointSize)(CELL_GCM_ARGS(const float size))
{
	return CELL_GCM_CALLEE(SetPointSize)(CELL_GCM_THIS, size);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetPolygonOffset)(CELL_GCM_ARGS(const float factor, const float units))
{
	return CELL_GCM_CALLEE(SetPolygonOffset)(CELL_GCM_THIS, factor,units);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetPolySmoothEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetPolySmoothEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetPolygonStippleEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetPolygonStippleEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetPolygonStipplePattern)(CELL_GCM_ARGS(const uint32_t* pattern))
{
	return CELL_GCM_CALLEE(SetPolygonStipplePattern)(CELL_GCM_THIS, pattern);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetFrontPolygonMode)(CELL_GCM_ARGS(const uint32_t mode))
{
	return CELL_GCM_CALLEE(SetFrontPolygonMode)(CELL_GCM_THIS, mode);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetBackPolygonMode)(CELL_GCM_ARGS(const uint32_t mode))
{
	return CELL_GCM_CALLEE(SetBackPolygonMode)(CELL_GCM_THIS, mode);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetScissor)(CELL_GCM_ARGS(const uint16_t x, const uint16_t y, const uint16_t w, const uint16_t h))
{
	return CELL_GCM_CALLEE(SetScissor)(CELL_GCM_THIS, x,y,w,h);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetShadeMode)(CELL_GCM_ARGS(const uint32_t sm))
{
	return CELL_GCM_CALLEE(SetShadeMode)(CELL_GCM_THIS, sm);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetTwoSideLightEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetTwoSideLightEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetStencilFunc)(CELL_GCM_ARGS(const uint32_t func, const int32_t ref, const uint32_t mask))
{
	return CELL_GCM_CALLEE(SetStencilFunc)(CELL_GCM_THIS, func,ref,mask);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetBackStencilFunc)(CELL_GCM_ARGS(const uint32_t func, const int32_t ref, const uint32_t mask))
{
	return CELL_GCM_CALLEE(SetBackStencilFunc)(CELL_GCM_THIS, func,ref,mask);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetStencilMask)(CELL_GCM_ARGS(const uint32_t sm))
{
	return CELL_GCM_CALLEE(SetStencilMask)(CELL_GCM_THIS, sm);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetBackStencilMask)(CELL_GCM_ARGS(const uint32_t sm))
{
	return CELL_GCM_CALLEE(SetBackStencilMask)(CELL_GCM_THIS, sm);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetStencilOp)(CELL_GCM_ARGS(const uint32_t fail, const uint32_t depthFail, const uint32_t depthPass))
{
	return CELL_GCM_CALLEE(SetStencilOp)(CELL_GCM_THIS, fail,depthFail,depthPass);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetBackStencilOp)(CELL_GCM_ARGS(const uint32_t fail, const uint32_t depthFail, const uint32_t depthPass))
{
	return CELL_GCM_CALLEE(SetBackStencilOp)(CELL_GCM_THIS, fail,depthFail,depthPass);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetZMinMaxControl)(CELL_GCM_ARGS(const uint32_t cullNearFarEnable, const uint32_t zclampEnable, const uint32_t cullIgnoreW))
{
	return CELL_GCM_CALLEE(SetZMinMaxControl)(CELL_GCM_THIS, cullNearFarEnable, zclampEnable, cullIgnoreW);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetViewport)(CELL_GCM_ARGS(const uint16_t x, const uint16_t y, const uint16_t w, const uint16_t h, const float min, const float max, const float scale[4], const float offset[4]))
{
	return CELL_GCM_CALLEE(SetViewport)(CELL_GCM_THIS, x,y,w,h,min,max,scale,offset);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetAlphaTestEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetAlphaTestEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetBlendEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetBlendEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetBlendEnableMrt)(CELL_GCM_ARGS(const uint32_t mrt1, const uint32_t mrt2, const uint32_t mrt3))
{
	return CELL_GCM_CALLEE(SetBlendEnableMrt)(CELL_GCM_THIS, mrt1,mrt2,mrt3);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetLogicOpEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetLogicOpEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetCullFaceEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetCullFaceEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetDepthBoundsTestEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetDepthBoundsTestEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetDepthTestEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetDepthTestEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetDitherEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetDitherEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetStencilTestEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetStencilTestEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetTwoSidedStencilTestEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetTwoSidedStencilTestEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetPolygonOffsetFillEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetPolygonOffsetFillEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetRestartIndexEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetRestartIndexEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetPointSpriteControl)(CELL_GCM_ARGS(const uint32_t enable, const uint32_t rmode, const uint32_t texcoord))
{
	return CELL_GCM_CALLEE(SetPointSpriteControl)(CELL_GCM_THIS, enable, rmode, texcoord);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetInvalidateTextureCache)(CELL_GCM_ARGS(const uint32_t value))
{
	return CELL_GCM_CALLEE(SetInvalidateTextureCache)(CELL_GCM_THIS, value);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetTextureBorderColor)(CELL_GCM_ARGS(const uint8_t index, const uint32_t color))
{
	return CELL_GCM_CALLEE(SetTextureBorderColor)(CELL_GCM_THIS, index, color);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetTextureFilter)(CELL_GCM_ARGS(const uint8_t index, const uint16_t bias, const uint8_t min, const uint8_t mag, const uint8_t conv))
{
	return CELL_GCM_CALLEE(SetTextureFilter)(CELL_GCM_THIS, index, bias, min, mag, conv);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetTextureAddress)(CELL_GCM_ARGS(const uint8_t index, const uint8_t wraps, const uint8_t wrapt, const uint8_t wrapr, const uint8_t unsignedRemap, const uint8_t zfunc, const uint8_t gamma))
{
	return CELL_GCM_CALLEE(SetTextureAddress)(CELL_GCM_THIS, index, wraps, wrapt, wrapr, unsignedRemap, zfunc, gamma);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetTextureControl)(CELL_GCM_ARGS(const uint8_t index, const uint32_t enable, const uint16_t minlod, const uint16_t maxlod, const uint8_t maxaniso))
{
	return CELL_GCM_CALLEE(SetTextureControl)(CELL_GCM_THIS, index, enable, minlod, maxlod, maxaniso);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetTextureOptimization)(CELL_GCM_ARGS(const uint8_t index, const uint8_t slope, const uint8_t iso, const uint8_t aniso))
{
	return CELL_GCM_CALLEE(SetTextureOptimization)(CELL_GCM_THIS, index, slope, iso, aniso);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetCylindricalWrap)(CELL_GCM_ARGS(const uint32_t enable, const uint32_t reserved))
{
	return CELL_GCM_CALLEE(SetCylindricalWrap)(CELL_GCM_THIS, enable, reserved);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetTexture)(CELL_GCM_ARGS(const uint8_t index, const CellGcmTexture *texture))
{
	return CELL_GCM_CALLEE(SetTexture)(CELL_GCM_THIS, index, texture);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetDrawArrays)(CELL_GCM_ARGS(const uint8_t mode, uint32_t first, uint32_t count))
{
	return CELL_GCM_CALLEE(SetDrawArrays)(CELL_GCM_THIS, mode, first, count);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetDrawIndexArray)(CELL_GCM_ARGS(const uint8_t mode, uint32_t count, const uint8_t type, const uint8_t location, const uint32_t indicies))
{
	return CELL_GCM_CALLEE(SetDrawIndexArray)(CELL_GCM_THIS, mode, count, type, location, indicies);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetInvalidateVertexCache)(CELL_GCM_NO_ARGS())
{
	return CELL_GCM_CALLEE(SetInvalidateVertexCache)(CELL_GCM_THIS);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetRestartIndex)(CELL_GCM_ARGS(const uint32_t index))
{
	return CELL_GCM_CALLEE(SetRestartIndex)(CELL_GCM_THIS, index);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetVertexData4f)(CELL_GCM_ARGS(const uint8_t index, const float v[4]))
{
	return CELL_GCM_CALLEE(SetVertexData4f)(CELL_GCM_THIS, index, v);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetVertexDataArray)(CELL_GCM_ARGS(const uint8_t index, const uint16_t frequency, const uint8_t stride, const uint8_t size, const uint8_t type, const uint8_t location, const uint32_t offset))
{
	return CELL_GCM_CALLEE(SetVertexDataArray)(CELL_GCM_THIS, index, frequency, stride, size, type, location, offset);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetFrequencyDividerOperation)(CELL_GCM_ARGS(const uint16_t operation))
{
	return CELL_GCM_CALLEE(SetFrequencyDividerOperation)(CELL_GCM_THIS, operation);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetTransformBranchBits)(CELL_GCM_ARGS(const uint32_t branchBits))
{
	return CELL_GCM_CALLEE(SetTransformBranchBits)(CELL_GCM_THIS, branchBits);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetVertexAttribInputMask)(CELL_GCM_ARGS(const uint16_t mask))
{
	return CELL_GCM_CALLEE(SetVertexAttribInputMask)(CELL_GCM_THIS, mask);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetVertexProgramParameterBlock)(CELL_GCM_ARGS(const uint32_t baseConst, uint32_t constCount, const float * __restrict value))
{
	return CELL_GCM_CALLEE(SetVertexProgramParameterBlock)(CELL_GCM_THIS, baseConst, constCount, value);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetUpdateFragmentProgramParameter)(CELL_GCM_ARGS(const uint32_t offset))
{
	return CELL_GCM_CALLEE(SetUpdateFragmentProgramParameter)(CELL_GCM_THIS, offset);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetFragmentProgramGammaEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetFragmentProgramGammaEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetUserClipPlaneControl)(CELL_GCM_ARGS(const uint32_t plane0, const uint32_t plane1, const uint32_t plane2, const uint32_t plane3, const uint32_t plane4, const uint32_t plane5))
{
	return CELL_GCM_CALLEE(SetUserClipPlaneControl)(CELL_GCM_THIS, plane0, plane1, plane2, plane3, plane4, plane5);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetVertexProgramConstants)(CELL_GCM_ARGS(const uint32_t start, const uint32_t count, const float *data))
{
	return CELL_GCM_CALLEE(SetVertexProgramConstants)(CELL_GCM_THIS, start, count, data);
}

CELL_GCM_DECL void CELL_GCM_FUNC(InlineTransfer)(CELL_GCM_ARGS(const uint32_t dstOffset, const void *srcAdr, const uint32_t sizeInWords, const uint8_t location = CELL_GCM_LOCATION_LOCAL))
{
	return CELL_GCM_CALLEE(InlineTransfer)(CELL_GCM_THIS, dstOffset, srcAdr, sizeInWords, location);
}

CELL_GCM_DECL uint32_t CELL_GCM_FUNC(SetTransferImage)(CELL_GCM_ARGS(const uint8_t mode, const uint32_t dstOffset, const uint32_t dstPitch, const uint32_t dstX, const uint32_t dstY, const uint32_t srcOffset, const uint32_t srcPitch, const uint32_t srcX, const uint32_t srcY, const uint32_t width, const uint32_t height, const uint32_t bytesPerPixel))
{
	return CELL_GCM_CALLEE(SetTransferImage)(CELL_GCM_THIS, mode, dstOffset, dstPitch, dstX, dstY, srcOffset, srcPitch, srcX, srcY, width, height, bytesPerPixel);
}

CELL_GCM_DECL void CELL_GCM_FUNC(TransferData)(CELL_GCM_ARGS(uint32_t dstOffset, int32_t dstPitch, uint32_t srcOffset, int32_t srcPitch, int32_t bytesPerRow, int32_t rowCount))
{
	return CELL_GCM_CALLEE(TransferData)(CELL_GCM_THIS, dstOffset, dstPitch, srcOffset, srcPitch, bytesPerRow, rowCount);
}

CELL_GCM_DECL uint32_t CELL_GCM_FUNC(SetTransferData)(CELL_GCM_ARGS(const uint8_t mode, const uint32_t dstOffset, const uint32_t dstPitch, const uint32_t srcOffset, const uint32_t srcPitch, const uint32_t bytesPerRow, const uint32_t rowCount))
{
	return CELL_GCM_CALLEE(SetTransferData)(CELL_GCM_THIS, mode, dstOffset, dstPitch, srcOffset, srcPitch, bytesPerRow, rowCount);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetRenderEnable)(CELL_GCM_ARGS(const uint8_t mode, const uint32_t index))
{
	return CELL_GCM_CALLEE(SetRenderEnable)(CELL_GCM_THIS, mode, index);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetZpassPixelCountEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetZpassPixelCountEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetClearReport)(CELL_GCM_ARGS(const uint32_t type))
{
	return CELL_GCM_CALLEE(SetClearReport)(CELL_GCM_THIS, type);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetReport)(CELL_GCM_ARGS(const uint32_t type, const uint32_t index))
{
	return CELL_GCM_CALLEE(SetReport)(CELL_GCM_THIS, type, index);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetZcullStatsEnable)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetZcullStatsEnable)(CELL_GCM_THIS, enable);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetZcullControl)(CELL_GCM_ARGS(const uint8_t zCullDir, const uint8_t zCullFormat))
{
	return CELL_GCM_CALLEE(SetZcullControl)(CELL_GCM_THIS, zCullDir, zCullFormat);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetZcullLimit)(CELL_GCM_ARGS(const uint16_t moveForwardLimit, const uint16_t pushBackLimit))
{
	return CELL_GCM_CALLEE(SetZcullLimit)(CELL_GCM_THIS, moveForwardLimit, pushBackLimit);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetScullControl)(CELL_GCM_ARGS(const uint8_t sFunc, const uint8_t sRef, const uint8_t sMask))
{
	return CELL_GCM_CALLEE(SetScullControl)(CELL_GCM_THIS, sFunc, sRef, sMask);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetConvertSwizzleFormat)(CELL_GCM_ARGS(uint32_t dstOffset, uint32_t dstWidth, uint32_t dstHeight, uint32_t dstX, uint32_t dstY, uint32_t srcOffset, uint32_t srcPitch, uint32_t srcX, uint32_t srcY, uint32_t width, uint32_t height, uint32_t bytesPerPixel, uint8_t mode = CELL_GCM_TRANSFER_MAIN_TO_LOCAL))
{
	return CELL_GCM_CALLEE(SetConvertSwizzleFormat)(CELL_GCM_THIS, dstOffset, dstWidth, dstHeight, dstX, dstY, srcOffset, srcPitch, srcX, srcY, width, height, bytesPerPixel, mode);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetVertexTexture)(CELL_GCM_ARGS(const uint8_t index, const CellGcmTexture *texture))
{
	return CELL_GCM_CALLEE(SetVertexTexture)(CELL_GCM_THIS, index, texture);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetVertexTextureAddress)(CELL_GCM_ARGS(const uint8_t index, const uint8_t wraps, const uint8_t wrapt))
{
	return CELL_GCM_CALLEE(SetVertexTextureAddress)(CELL_GCM_THIS, index, wraps, wrapt);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetVertexTextureFilter)(CELL_GCM_ARGS(const uint8_t index, const uint16_t bias))
{
	return CELL_GCM_CALLEE(SetVertexTextureFilter)(CELL_GCM_THIS, index, bias);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetVertexTextureControl)(CELL_GCM_ARGS(const uint8_t index, const uint32_t enable, const uint16_t minLod, const uint16_t maxLod))
{
	return CELL_GCM_CALLEE(SetVertexTextureControl)(CELL_GCM_THIS, index, enable, minLod, maxLod);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetVertexTextureBorderColor)(CELL_GCM_ARGS(const uint8_t index, const uint32_t color))
{
	return CELL_GCM_CALLEE(SetVertexTextureBorderColor)(CELL_GCM_THIS, index, color);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetPerfMonTrigger)(CELL_GCM_NO_ARGS())
{
	return CELL_GCM_CALLEE(SetPerfMonTrigger)(CELL_GCM_THIS);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetDrawInlineArray)(CELL_GCM_ARGS(const uint8_t mode, const uint32_t count, const void *data))
{
	return CELL_GCM_CALLEE(SetDrawInlineArray)(CELL_GCM_THIS, mode, count, data);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetDrawInlineIndexArray32)(CELL_GCM_ARGS(const uint8_t mode, const uint32_t start, const uint32_t count, const uint32_t *data))
{
	return CELL_GCM_CALLEE(SetDrawInlineIndexArray32)(CELL_GCM_THIS, mode, start, count, data);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetDrawInlineIndexArray16)(CELL_GCM_ARGS(const uint8_t mode, const uint32_t start, const uint32_t count, const uint16_t *data))
{
	return CELL_GCM_CALLEE(SetDrawInlineIndexArray16)(CELL_GCM_THIS, mode, start, count, data);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetFogMode)(CELL_GCM_ARGS(const uint32_t mode))
{
	return CELL_GCM_CALLEE(SetFogMode)(CELL_GCM_THIS, mode);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetFogParams)(CELL_GCM_ARGS(const float p0, const float p1))
{
	return CELL_GCM_CALLEE(SetFogParams)(CELL_GCM_THIS, p0, p1);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetTransferLocation)(CELL_GCM_ARGS(const uint32_t location))
{
	return CELL_GCM_CALLEE(SetTransferLocation)(CELL_GCM_THIS, location);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetDepthFormat)(CELL_GCM_ARGS(const uint32_t format))
{
	return CELL_GCM_CALLEE(SetDepthFormat)(CELL_GCM_THIS, format);
}

CELL_GCM_DECL void CELL_GCM_FUNC(SetBlendOptimization)(CELL_GCM_ARGS(const uint32_t enable))
{
	return CELL_GCM_CALLEE(SetBlendOptimization)(CELL_GCM_THIS, enable);
}
