/* SCE CONFIDENTIAL
   PLAYSTATION(R)3 Programmer Tool Runtime Library 154.001
   * Copyright (C) 2006 Sony Computer Entertainment Inc.
   * All Rights Reserved.
   */

#ifndef __CELL_SPURS_JOB_CHAIN_H__
#define __CELL_SPURS_JOB_CHAIN_H__


#include <cell/spurs/job_context.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

	void cellSpursJobMain(CellSpursJobContext* jobContext,
						  CellSpursJob256* job) __attribute__((section(".text._cellSpursJobMain")));
	void cellSpursJobInitialize(void);

/*
 *  SPURS Job Chain
 */
	int cellSpursKickJobChain(uint64_t eaJobChain, uint8_t numReadyCount);

	int cellSpursShutdownJobChain(uint64_t eaJobChain);

/*
 *  SPURS Job Guard
 */
	int cellSpursJobGuardInitialize(uint64_t eaJobChain,
									uint64_t eaJobGuard,
									uint32_t notifyCount,
									uint8_t numReadyCount,
									uint8_t autoReset,
									unsigned int tag);
	int cellSpursJobGuardReset(uint64_t eaJobGuard);
	int cellSpursJobGuardNotify(uint64_t eaJobGuard);

/*
 *  SPURS Urgent Job
 */
	int cellSpursAddUrgentCommand(uint64_t eaJobChain, uint64_t command);
	int cellSpursAddUrgentCall(uint64_t eaJobChain, uint64_t commandList);

#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */


#endif /* __CELL_SPURS_JOB_CHAIN_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
