/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 154.001
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */
#ifndef __CELL_SPURS_POLICY_MODULE_H__
#define __CELL_SPURS_POLICY_MODULE_H__

/* The C Standard Library */
#include <stdint.h>
#include <stdbool.h>

/* SPURS */
#include <cell/spurs/types.h>			/* CellSpursWorkloadId */
#include <cell/spurs/error.h>

#ifdef __cplusplus
extern "C" {
#endif

void cellSpursModuleEntry(uintptr_t context, uint64_t ea) __attribute__((naked,noreturn));
void cellSpursModuleMain(uintptr_t context, uint64_t ea);

void _cellSpursModuleExit(void) __attribute__((__noreturn__));
void _cellSpursModuleTrace(unsigned tag, uint64_t data);
void _cellSpursRequestIdleSpu(CellSpursWorkloadId, unsigned count);

#ifdef __cplusplus
} /* extern "C" */
#endif

/*
 * for compatibility
 */
#define cellSpursModuleExit(context)\
		_cellSpursModuleExit()

#define cellSpursModuleTrace(context,tag,data)\
		_cellSpursModuleTrace(tag,data)

/*
 * alias of SPURS common interfaces
 */
#include <cell/spurs/common.h>

#define cellSpursModuleGetSpuId(context)\
		cellSpursGetCurrentSpuId()

#define cellSpursModuleGetWorkloadId(context)\
		cellSpursGetWorkloadId()

#define cellSpursModulePoll(context)\
		cellSpursPoll()

/*
 * ready count interfaces for policy module
 */
#include <cell/spurs/ready_count.h>

#define cellSpursModuleReadyCountSwap(context, value)\
		_cellSpursReadyCountSwap(cellSpursGetWorkloadId(), value)

#define cellSpursModuleReadyCountCompareAndSwap(context, compare, swap)\
		_cellSpursReadyCountCompareAndSwap(cellSpursGetWorkloadId(), compare, swap)

#define cellSpursModuleReadyCountAdd(context, value)\
		_cellSpursReadyCountAdd(cellSpursGetWorkloadId(), value)

/*
 * idle SPU request operation for policy module
 */
#define cellSpursModuleRequestIdleSpu(context, count)\
		_cellSpursRequestIdleSpu(cellSpursGetWorkloadId(), count)

static inline
int cellSpursRequestIdleSpu(unsigned char *ls, uint64_t eaSpurs, CellSpursWorkloadId id, unsigned count)
{
	(void)ls;
	(void)eaSpurs;
	if (id >= CELL_SPURS_MAX_WORKLOAD || count >= CELL_SPURS_MAX_SPU) {
		return CELL_SPURS_POLICY_MODULE_ERROR_INVAL;
	}
	_cellSpursRequestIdleSpu(id, count);
	return CELL_OK;
}

#endif /* __CELL_SPURS_POLICY_MODULE_H__ */
/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
