/* SCE CONFIDENTIAL
PLAYSTATION(R)3 Programmer Tool Runtime Library 154.001
 * Copyright (C) 2006 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef __CELL_SPURS_QUEUE_H__
#define __CELL_SPURS_QUEUE_H__ 1

/* The C Standard Library */
#include <stdint.h>

/* SPURS */
#include <cell/spurs/queue_types.h>
#include <cell/spurs/error.h>

#ifdef __cplusplus
extern "C" {
#endif

int _cellSpursQueueInitialize(uint64_t ea, uint64_t buffer, unsigned int size, unsigned int depth, CellSpursQueueDirection, int);
int cellSpursQueueTryPushBegin(uint64_t ea, const void* buffer, unsigned int tag);
int cellSpursQueuePushBegin(uint64_t ea, const void* buffer, unsigned int tag);
int cellSpursQueuePushEnd(uint64_t ea, unsigned int tag);
int cellSpursQueueTryPopBegin(uint64_t ea, void* buffer, unsigned int tag);
int cellSpursQueuePopBegin(uint64_t ea, void* buffer, unsigned int tag);
int cellSpursQueuePopEndBody(uint64_t ea, unsigned int tag, unsigned int isPeek);
int cellSpursQueueSize(uint64_t ea, unsigned int *size);
int cellSpursQueueDepth(uint64_t ea, unsigned int *size);
int cellSpursQueueClear(uint64_t ea);
int cellSpursQueueGetDirection(uint64_t ea, CellSpursQueueDirection* direction);
int cellSpursQueueGetEntrySize(uint64_t ea, unsigned int *entry_size);
int cellSpursQueueGetTasksetAddress(uint64_t ea, uint64_t* pEaTaskset);

#ifdef __cplusplus
} /* extern "C" */
#endif

static inline
int cellSpursQueuePopEnd(uint64_t ea, unsigned int tag)
{
	return cellSpursQueuePopEndBody(ea, tag, 0);
}

static inline
int cellSpursQueuePeekBegin(uint64_t ea, void* buffer, unsigned int tag)
{
	return cellSpursQueuePopBegin(ea, buffer, tag);
}

static inline
int cellSpursQueueTryPeekBegin(uint64_t ea, void* buffer, unsigned int tag)
{
	return cellSpursQueueTryPopBegin(ea, buffer, tag);
}

static inline
int cellSpursQueuePeekEnd(uint64_t ea, unsigned int tag)
{
	return cellSpursQueuePopEndBody(ea, tag, 1);
}

static inline
int cellSpursQueueInitialize(uint64_t ea, uint64_t buffer, unsigned int size, unsigned int depth, CellSpursQueueDirection direction)
{
	return _cellSpursQueueInitialize (ea, buffer, size, depth, direction, 0);
}

static inline
int cellSpursQueueInitializeIWL(uint64_t ea, uint64_t buffer, unsigned int size, unsigned int depth, CellSpursQueueDirection direction)
{
	return _cellSpursQueueInitialize (ea, buffer, size, depth, direction, 1);
}

#endif /* __CELL_SPURS_QUEUE_H__ */

/*
 * Local Variables:
 * mode: C
 * c-file-style: "stroustrup"
 * tab-width: 4
 * End:
 * vim:sw=4:sts=4:ts=4
 */
