/*   SCE CONFIDENTIAL                                       */
/*   PLAYSTATION(R)3 Programmer Tool Runtime Library 154.001 */
/*   Copyright (C) 2006 Sony Computer Entertainment Inc.    */
/*   All Rights Reserved.                                   */

#if !defined(__SYS_NET_NETEX_ERRNO_H__)
#define __SYS_NET_NETEX_ERRNO_H__

#include <cell/error.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*
	CELL_ERROR_FACILITY_SYSTEM_SERVICE 0x001
	libnet : 0x8001_0201 - 0x8001_02ff
*/

#define SYS_NET_MAKE_ERROR(status) \
	CELL_ERROR_MAKE_ERROR(CELL_ERROR_FACILITY_SYSTEM_SERVICE, 0x0200 | status)

/* CELL error */
/* ERR: SYS_NET_MAKE_ERROR(0x0201) */
#define SYS_NET_ERROR_EPERM           CELL_ERROR_CAST(0x80010201)
/* ERR: SYS_NET_MAKE_ERROR(0x0202) */
#define	SYS_NET_ERROR_ENOENT          CELL_ERROR_CAST(0x80010202)
/* ERR: SYS_NET_MAKE_ERROR(0x0203) */
#define	SYS_NET_ERROR_ESRCH           CELL_ERROR_CAST(0x80010203)
/* ERR: SYS_NET_MAKE_ERROR(0x0204) */
#define	SYS_NET_ERROR_EINTR           CELL_ERROR_CAST(0x80010204)
/* ERR: SYS_NET_MAKE_ERROR(0x0205) */
#define	SYS_NET_ERROR_EIO             CELL_ERROR_CAST(0x80010205)
/* ERR: SYS_NET_MAKE_ERROR(0x0206) */
#define	SYS_NET_ERROR_ENXIO           CELL_ERROR_CAST(0x80010206)
/* ERR: SYS_NET_MAKE_ERROR(0x0207) */
#define	SYS_NET_ERROR_E2BIG           CELL_ERROR_CAST(0x80010207)
/* ERR: SYS_NET_MAKE_ERROR(0x0208) */
#define	SYS_NET_ERROR_ENOEXEC         CELL_ERROR_CAST(0x80010208)
/* ERR: SYS_NET_MAKE_ERROR(0x0209) */
#define	SYS_NET_ERROR_EBADF           CELL_ERROR_CAST(0x80010209)
/* ERR: SYS_NET_MAKE_ERROR(0x020a) */
#define	SYS_NET_ERROR_ECHILD          CELL_ERROR_CAST(0x8001020a)
/* ERR: SYS_NET_MAKE_ERROR(0x020b) */
#define	SYS_NET_ERROR_EDEADLK         CELL_ERROR_CAST(0x8001020b)
/* ERR: SYS_NET_MAKE_ERROR(0x020c) */
#define	SYS_NET_ERROR_ENOMEM          CELL_ERROR_CAST(0x8001020c)
/* ERR: SYS_NET_MAKE_ERROR(0x020d) */
#define	SYS_NET_ERROR_EACCES          CELL_ERROR_CAST(0x8001020d)
/* ERR: SYS_NET_MAKE_ERROR(0x020e) */
#define	SYS_NET_ERROR_EFAULT          CELL_ERROR_CAST(0x8001020e)
/* ERR: SYS_NET_MAKE_ERROR(0x020f) */
#define	SYS_NET_ERROR_ENOTBLK         CELL_ERROR_CAST(0x8001020f)
/* ERR: SYS_NET_MAKE_ERROR(0x0210) */
#define	SYS_NET_ERROR_EBUSY           CELL_ERROR_CAST(0x80010210)
/* ERR: SYS_NET_MAKE_ERROR(0x0211) */
#define	SYS_NET_ERROR_EEXIST          CELL_ERROR_CAST(0x80010211)
/* ERR: SYS_NET_MAKE_ERROR(0x0212) */
#define	SYS_NET_ERROR_EXDEV           CELL_ERROR_CAST(0x80010212)
/* ERR: SYS_NET_MAKE_ERROR(0x0213) */
#define	SYS_NET_ERROR_ENODEV          CELL_ERROR_CAST(0x80010213)
/* ERR: SYS_NET_MAKE_ERROR(0x0214) */
#define	SYS_NET_ERROR_ENOTDIR         CELL_ERROR_CAST(0x80010214)
/* ERR: SYS_NET_MAKE_ERROR(0x0215) */
#define	SYS_NET_ERROR_EISDIR          CELL_ERROR_CAST(0x80010215)
/* ERR: SYS_NET_MAKE_ERROR(0x0216) */
#define	SYS_NET_ERROR_EINVAL          CELL_ERROR_CAST(0x80010216)
/* ERR: SYS_NET_MAKE_ERROR(0x0217) */
#define	SYS_NET_ERROR_ENFILE          CELL_ERROR_CAST(0x80010217)
/* ERR: SYS_NET_MAKE_ERROR(0x0218) */
#define	SYS_NET_ERROR_EMFILE          CELL_ERROR_CAST(0x80010218)
/* ERR: SYS_NET_MAKE_ERROR(0x0219) */
#define	SYS_NET_ERROR_ENOTTY          CELL_ERROR_CAST(0x80010219)
/* ERR: SYS_NET_MAKE_ERROR(0x021a) */
#define	SYS_NET_ERROR_ETXTBSY         CELL_ERROR_CAST(0x8001021a)
/* ERR: SYS_NET_MAKE_ERROR(0x021b) */
#define	SYS_NET_ERROR_EFBIG           CELL_ERROR_CAST(0x8001021b)
/* ERR: SYS_NET_MAKE_ERROR(0x021c) */
#define	SYS_NET_ERROR_ENOSPC          CELL_ERROR_CAST(0x8001021c)
/* ERR: SYS_NET_MAKE_ERROR(0x021d) */
#define	SYS_NET_ERROR_ESPIPE          CELL_ERROR_CAST(0x8001021d)
/* ERR: SYS_NET_MAKE_ERROR(0x021e) */
#define	SYS_NET_ERROR_EROFS           CELL_ERROR_CAST(0x8001021e)
/* ERR: SYS_NET_MAKE_ERROR(0x021f) */
#define	SYS_NET_ERROR_EMLINK          CELL_ERROR_CAST(0x8001021f)
/* ERR: SYS_NET_MAKE_ERROR(0x0220) */
#define	SYS_NET_ERROR_EPIPE           CELL_ERROR_CAST(0x80010220)
/* ERR: SYS_NET_MAKE_ERROR(0x0221) */
#define	SYS_NET_ERROR_EDOM            CELL_ERROR_CAST(0x80010221)
/* ERR: SYS_NET_MAKE_ERROR(0x0222) */
#define	SYS_NET_ERROR_ERANGE          CELL_ERROR_CAST(0x80010222)
/* ERR: SYS_NET_MAKE_ERROR(0x0223) */
#define	SYS_NET_ERROR_EAGAIN          CELL_ERROR_CAST(0x80010223)
#define	SYS_NET_ERROR_EWOULDBLOCK     SYS_NET_ERROR_EAGAIN
/* ERR: SYS_NET_MAKE_ERROR(0x0224) */
#define	SYS_NET_ERROR_EINPROGRESS     CELL_ERROR_CAST(0x80010224)
/* ERR: SYS_NET_MAKE_ERROR(0x0225) */
#define	SYS_NET_ERROR_EALREADY        CELL_ERROR_CAST(0x80010225)
/* ERR: SYS_NET_MAKE_ERROR(0x0226) */
#define	SYS_NET_ERROR_ENOTSOCK        CELL_ERROR_CAST(0x80010226)
/* ERR: SYS_NET_MAKE_ERROR(0x0227) */
#define	SYS_NET_ERROR_EDESTADDRREQ    CELL_ERROR_CAST(0x80010227)
/* ERR: SYS_NET_MAKE_ERROR(0x0228) */
#define	SYS_NET_ERROR_EMSGSIZE        CELL_ERROR_CAST(0x80010228)
/* ERR: SYS_NET_MAKE_ERROR(0x0229) */
#define	SYS_NET_ERROR_EPROTOTYPE      CELL_ERROR_CAST(0x80010229)
/* ERR: SYS_NET_MAKE_ERROR(0x022a) */
#define	SYS_NET_ERROR_ENOPROTOOPT     CELL_ERROR_CAST(0x8001022a)
/* ERR: SYS_NET_MAKE_ERROR(0x022b) */
#define	SYS_NET_ERROR_EPROTONOSUPPORT CELL_ERROR_CAST(0x8001022b)
/* ERR: SYS_NET_MAKE_ERROR(0x022c) */
#define	SYS_NET_ERROR_ESOCKTNOSUPPORT CELL_ERROR_CAST(0x8001022c)
/* ERR: SYS_NET_MAKE_ERROR(0x022d) */
#define	SYS_NET_ERROR_EOPNOTSUPP      CELL_ERROR_CAST(0x8001022d)
/* ERR: SYS_NET_MAKE_ERROR(0x022e) */
#define	SYS_NET_ERROR_EPFNOSUPPORT    CELL_ERROR_CAST(0x8001022e)
/* ERR: SYS_NET_MAKE_ERROR(0x022f) */
#define	SYS_NET_ERROR_EAFNOSUPPORT    CELL_ERROR_CAST(0x8001022f)
/* ERR: SYS_NET_MAKE_ERROR(0x0230) */
#define	SYS_NET_ERROR_EADDRINUSE      CELL_ERROR_CAST(0x80010230)
/* ERR: SYS_NET_MAKE_ERROR(0x0231) */
#define	SYS_NET_ERROR_EADDRNOTAVAIL   CELL_ERROR_CAST(0x80010231)
/* ERR: SYS_NET_MAKE_ERROR(0x0232) */
#define	SYS_NET_ERROR_ENETDOWN        CELL_ERROR_CAST(0x80010232)
/* ERR: SYS_NET_MAKE_ERROR(0x0233) */
#define	SYS_NET_ERROR_ENETUNREACH     CELL_ERROR_CAST(0x80010233)
/* ERR: SYS_NET_MAKE_ERROR(0x0234) */
#define	SYS_NET_ERROR_ENETRESET       CELL_ERROR_CAST(0x80010234)
/* ERR: SYS_NET_MAKE_ERROR(0x0235) */
#define	SYS_NET_ERROR_ECONNABORTED    CELL_ERROR_CAST(0x80010235)
/* ERR: SYS_NET_MAKE_ERROR(0x0236) */
#define	SYS_NET_ERROR_ECONNRESET      CELL_ERROR_CAST(0x80010236)
/* ERR: SYS_NET_MAKE_ERROR(0x0237) */
#define	SYS_NET_ERROR_ENOBUFS         CELL_ERROR_CAST(0x80010237)
/* ERR: SYS_NET_MAKE_ERROR(0x0238) */
#define	SYS_NET_ERROR_EISCONN         CELL_ERROR_CAST(0x80010238)
/* ERR: SYS_NET_MAKE_ERROR(0x0239) */
#define	SYS_NET_ERROR_ENOTCONN        CELL_ERROR_CAST(0x80010239)
/* ERR: SYS_NET_MAKE_ERROR(0x023a) */
#define	SYS_NET_ERROR_ESHUTDOWN       CELL_ERROR_CAST(0x8001023a)
/* ERR: SYS_NET_MAKE_ERROR(0x023b) */
#define	SYS_NET_ERROR_ETOOMANYREFS    CELL_ERROR_CAST(0x8001023b)
/* ERR: SYS_NET_MAKE_ERROR(0x023c) */
#define	SYS_NET_ERROR_ETIMEDOUT       CELL_ERROR_CAST(0x8001023c)
/* ERR: SYS_NET_MAKE_ERROR(0x023d) */
#define	SYS_NET_ERROR_ECONNREFUSED    CELL_ERROR_CAST(0x8001023d)
/* ERR: SYS_NET_MAKE_ERROR(0x023e) */
#define	SYS_NET_ERROR_ELOOP           CELL_ERROR_CAST(0x8001023e)
/* ERR: SYS_NET_MAKE_ERROR(0x023f) */
#define	SYS_NET_ERROR_ENAMETOOLONG    CELL_ERROR_CAST(0x8001023f)
/* ERR: SYS_NET_MAKE_ERROR(0x0240) */
#define	SYS_NET_ERROR_EHOSTDOWN       CELL_ERROR_CAST(0x80010240)
/* ERR: SYS_NET_MAKE_ERROR(0x0241) */
#define	SYS_NET_ERROR_EHOSTUNREACH    CELL_ERROR_CAST(0x80010241)
/* ERR: SYS_NET_MAKE_ERROR(0x0242) */
#define	SYS_NET_ERROR_ENOTEMPTY       CELL_ERROR_CAST(0x80010242)
/* ERR: SYS_NET_MAKE_ERROR(0x0243) */
#define	SYS_NET_ERROR_EPROCLIM        CELL_ERROR_CAST(0x80010243)
/* ERR: SYS_NET_MAKE_ERROR(0x0244) */
#define	SYS_NET_ERROR_EUSERS          CELL_ERROR_CAST(0x80010244)
/* ERR: SYS_NET_MAKE_ERROR(0x0245) */
#define	SYS_NET_ERROR_EDQUOT          CELL_ERROR_CAST(0x80010245)
/* ERR: SYS_NET_MAKE_ERROR(0x0246) */
#define	SYS_NET_ERROR_ESTALE          CELL_ERROR_CAST(0x80010246)
/* ERR: SYS_NET_MAKE_ERROR(0x0247) */
#define	SYS_NET_ERROR_EREMOTE         CELL_ERROR_CAST(0x80010247)
/* ERR: SYS_NET_MAKE_ERROR(0x0248) */
#define	SYS_NET_ERROR_EBADRPC         CELL_ERROR_CAST(0x80010248)
/* ERR: SYS_NET_MAKE_ERROR(0x0249) */
#define	SYS_NET_ERROR_ERPCMISMATCH    CELL_ERROR_CAST(0x80010249)
/* ERR: SYS_NET_MAKE_ERROR(0x024a) */
#define	SYS_NET_ERROR_EPROGUNAVAIL    CELL_ERROR_CAST(0x8001024a)
/* ERR: SYS_NET_MAKE_ERROR(0x024b) */
#define	SYS_NET_ERROR_EPROGMISMATCH   CELL_ERROR_CAST(0x8001024b)
/* ERR: SYS_NET_MAKE_ERROR(0x024c) */
#define	SYS_NET_ERROR_EPROCUNAVAIL    CELL_ERROR_CAST(0x8001024c)
/* ERR: SYS_NET_MAKE_ERROR(0x024d) */
#define	SYS_NET_ERROR_ENOLCK          CELL_ERROR_CAST(0x8001024d)
/* ERR: SYS_NET_MAKE_ERROR(0x024e) */
#define	SYS_NET_ERROR_ENOSYS          CELL_ERROR_CAST(0x8001024e)
/* ERR: SYS_NET_MAKE_ERROR(0x024f) */
#define	SYS_NET_ERROR_EFTYPE          CELL_ERROR_CAST(0x8001024f)
/* ERR: SYS_NET_MAKE_ERROR(0x0250) */
#define	SYS_NET_ERROR_EAUTH           CELL_ERROR_CAST(0x80010250)
/* ERR: SYS_NET_MAKE_ERROR(0x0251) */
#define	SYS_NET_ERROR_ENEEDAUTH       CELL_ERROR_CAST(0x80010251)
/* ERR: SYS_NET_MAKE_ERROR(0x0252) */
#define	SYS_NET_ERROR_EIDRM           CELL_ERROR_CAST(0x80010252)
/* ERR: SYS_NET_MAKE_ERROR(0x0253) */
#define	SYS_NET_ERROR_ENOMSG          CELL_ERROR_CAST(0x80010253)
/* ERR: SYS_NET_MAKE_ERROR(0x0254) */
#define	SYS_NET_ERROR_EOVERFLOW       CELL_ERROR_CAST(0x80010254)
/* ERR: SYS_NET_MAKE_ERROR(0x0255) */
#define	SYS_NET_ERROR_EILSEQ          CELL_ERROR_CAST(0x80010255)
/* ERR: SYS_NET_MAKE_ERROR(0x0256) */
#define	SYS_NET_ERROR_ENOTSUP         CELL_ERROR_CAST(0x80010256)
/* ERR: SYS_NET_MAKE_ERROR(0x0257) */
#define	SYS_NET_ERROR_ECANCELED       CELL_ERROR_CAST(0x80010257)
/* ERR: SYS_NET_MAKE_ERROR(0x0258) */
#define	SYS_NET_ERROR_EBADMSG         CELL_ERROR_CAST(0x80010258)
/* ERR: SYS_NET_MAKE_ERROR(0x0259) */
#define	SYS_NET_ERROR_ENODATA         CELL_ERROR_CAST(0x80010259)
/* ERR: SYS_NET_MAKE_ERROR(0x025a) */
#define	SYS_NET_ERROR_ENOSR           CELL_ERROR_CAST(0x8001025a)
/* ERR: SYS_NET_MAKE_ERROR(0x025b) */
#define	SYS_NET_ERROR_ENOSTR          CELL_ERROR_CAST(0x8001025b)
/* ERR: SYS_NET_MAKE_ERROR(0x025c) */
#define	SYS_NET_ERROR_ETIME           CELL_ERROR_CAST(0x8001025c)

/* sys_net_errno */
#define	SYS_NET_EPERM		1
#define	SYS_NET_ENOENT		2
#define	SYS_NET_ESRCH		3
#define	SYS_NET_EINTR		4
#define	SYS_NET_EIO		5
#define	SYS_NET_ENXIO		6
#define	SYS_NET_E2BIG		7
#define	SYS_NET_ENOEXEC		8
#define	SYS_NET_EBADF		9
#define	SYS_NET_ECHILD		10
#define	SYS_NET_EDEADLK		11
#define	SYS_NET_ENOMEM		12
#define	SYS_NET_EACCES		13
#define	SYS_NET_EFAULT		14
#define	SYS_NET_ENOTBLK		15
#define	SYS_NET_EBUSY		16
#define	SYS_NET_EEXIST		17
#define	SYS_NET_EXDEV		18
#define	SYS_NET_ENODEV		19
#define	SYS_NET_ENOTDIR		20
#define	SYS_NET_EISDIR		21
#define	SYS_NET_EINVAL		22
#define	SYS_NET_ENFILE		23
#define	SYS_NET_EMFILE		24
#define	SYS_NET_ENOTTY		25
#define	SYS_NET_ETXTBSY		26
#define	SYS_NET_EFBIG		27
#define	SYS_NET_ENOSPC		28
#define	SYS_NET_ESPIPE		29
#define	SYS_NET_EROFS		30
#define	SYS_NET_EMLINK		31
#define	SYS_NET_EPIPE		32
#define	SYS_NET_EDOM		33
#define	SYS_NET_ERANGE		34
#define	SYS_NET_EAGAIN		35
#define	SYS_NET_EWOULDBLOCK	SYS_NET_EAGAIN
#define	SYS_NET_EINPROGRESS	36
#define	SYS_NET_EALREADY	37
#define	SYS_NET_ENOTSOCK	38
#define	SYS_NET_EDESTADDRREQ	39
#define	SYS_NET_EMSGSIZE	40
#define	SYS_NET_EPROTOTYPE	41
#define	SYS_NET_ENOPROTOOPT	42
#define	SYS_NET_EPROTONOSUPPORT	43
#define	SYS_NET_ESOCKTNOSUPPORT	44
#define	SYS_NET_EOPNOTSUPP	45
#define	SYS_NET_EPFNOSUPPORT	46
#define	SYS_NET_EAFNOSUPPORT	47
#define	SYS_NET_EADDRINUSE	48
#define	SYS_NET_EADDRNOTAVAIL	49
#define	SYS_NET_ENETDOWN	50
#define	SYS_NET_ENETUNREACH	51
#define	SYS_NET_ENETRESET	52
#define	SYS_NET_ECONNABORTED	53
#define	SYS_NET_ECONNRESET	54
#define	SYS_NET_ENOBUFS		55
#define	SYS_NET_EISCONN		56
#define	SYS_NET_ENOTCONN	57
#define	SYS_NET_ESHUTDOWN	58
#define	SYS_NET_ETOOMANYREFS	59
#define	SYS_NET_ETIMEDOUT	60
#define	SYS_NET_ECONNREFUSED	61
#define	SYS_NET_ELOOP		62
#define	SYS_NET_ENAMETOOLONG	63
#define	SYS_NET_EHOSTDOWN	64
#define	SYS_NET_EHOSTUNREACH	65
#define	SYS_NET_ENOTEMPTY	66
#define	SYS_NET_EPROCLIM	67
#define	SYS_NET_EUSERS		68
#define	SYS_NET_EDQUOT		69
#define	SYS_NET_ESTALE		70
#define	SYS_NET_EREMOTE		71
#define	SYS_NET_EBADRPC		72
#define	SYS_NET_ERPCMISMATCH	73
#define	SYS_NET_EPROGUNAVAIL	74
#define	SYS_NET_EPROGMISMATCH	75
#define	SYS_NET_EPROCUNAVAIL	76
#define	SYS_NET_ENOLCK		77
#define	SYS_NET_ENOSYS		78
#define	SYS_NET_EFTYPE		79
#define	SYS_NET_EAUTH		80
#define	SYS_NET_ENEEDAUTH	81
#define	SYS_NET_EIDRM		82
#define	SYS_NET_ENOMSG		83
#define	SYS_NET_EOVERFLOW	84
#define	SYS_NET_EILSEQ		85
#define	SYS_NET_ENOTSUP		86
#define	SYS_NET_ECANCELED	87
#define	SYS_NET_EBADMSG		88
#define	SYS_NET_ENODATA		89
#define	SYS_NET_ENOSR		90
#define	SYS_NET_ENOSTR		91
#define	SYS_NET_ETIME		92
#define	SYS_NET_ELAST		92

int *_sys_net_errno_loc(void);

#define	sys_net_errno	(*_sys_net_errno_loc())

#if defined(__cplusplus)
}
#endif

#endif	/* !__SYS_NET_NETEX_ERRNO_H__ */

