#!/usr/bin/perl
#############################################################################
## Crytek Source File
## Copyright (C) 2006, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Jul 31, 2006
## Description: GNU-make based build system
#############################################################################

# Echo the command arguments, applying a path normalization.
# The build target may be specified through the -t option.  If a build target
# is specified and a '..' is removed from the path, then the target name is
# appended to the line (in angle brackets).

use warnings;
use strict;

use Getopt::Std;
getopts('t:p:b:clh');
our($opt_t, $opt_p, $opt_b, $opt_c, $opt_l, $opt_h);

if ($opt_h)
{
	print <<EOF;
echo.pl: Echo with path normalization.
Synopsis:
  \$PERL echo.pl (Options) -- (Arguments)
Options:
-c
  Cygwin mode.  Convert file names of the form '/cygdrive/(DRIVE)/...' to
	'(DRIVE):/...'.  The pattern is recognized for stand alone options _and_ for
	paths follwing a -I option.
-b BASEDIR
  Used in Cygwin mode only.  The base directory in Windows notation
	(drive:path).  If this option is specified, then the path prefix '/base' is
	converted to the specified base directory.
-p PREFIX
  Prefix to be stripped from all specified arguments.  The prefix is matched
	in case-insensitive mode.
-t TARGET
  The target name.  If a "/../" sequence is removed from an argument and a
	target is specified using the -t option, then the specified target name is
	appended to the output in brackets.  This option is ignored in line mode.
-l
  Line mode.  Output every argument in a separate line.  This option is useful
	for generating file lists.
-h
  Display this help screen and exit.
EOF
  exit 0;
}

my $space = '';
my $stripped = 0;

foreach (@ARGV)
{
	while (s/\/\.\//\//) { }
	while (s/[^\/]+\/\.\.\///) { $stripped = 1; }
	if ($opt_p) { s/^${opt_p}//i; }
	if ($opt_c)
	{
		if ($opt_b)
		{
			if (/^(-[IL]|)\/base\/(.*$)/i)
			{
				$_ = "$1$opt_b/$2";
				s/\\/\//g;
				s/\/\/*/\//g;
			}
		}
		if (/^(-[IL]|)\/cygdrive\/([a-z])\/(.*$)/i)
		{
			$_ = "$1$2:/$3";
		}
	}
	if ($opt_l)
	{
		print "$_\n";
	}
	else
	{
		print "$space$_";
		$space = ' ';
	}
}
if (not $opt_l)
{
	if ($opt_t and $stripped) { print " [$opt_t]"; }
	print "\n";
}
exit 0;

# vim:ts=2:sw=2

