@ECHO OFF



REM #########################################################################

REM ## Crytek Source File

REM ## Copyright (C) 2007, Crytek Studios

REM ##

REM ## Creator: Sascha Demetrio

REM ## Date: Apr 11, 2007

REM ## Description: GNU-make based build system

REM #########################################################################



REM # Common batch file performing the VS integration operations.



REM # Arguments:

REM # %1 The base directory.

REM # %2 The project source directory.

REM # %3 The project name.

REM # %4 The name of the build configuration.



SET BASE_DIR=%1

SET PROJECT_DIR=%2

SET PROJECT_NAME=%3

SET CONFIG=%4



SET CYGWIN_DIR=%BASE_DIR%/Code/SDKs/PS3/cygwin

SET CELL_SDK=%BASE_DIR%/Code/SDKs/PS3/cell

SET CELL_HOSTDIR=%CELL_SDK%/host-win32

PATH %CYGWIN_DIR%\bin;%CELL_HOSTDIR%\bin;%PATH%

PATH %CELL_HOSTDIR%\ppu\bin;%CELL_HOSTDIR%\spu\bin;%PATH%

if exist %BASE_DIR%/Code/SDKs/PS3/cell/*.*	goto HAS_CELL_SDK

echo %CELL_SDK% not found

echo Map via perforce: "//depot/3rdParty/PS3/... //<your client>/mastercd/Code/SDKs/PS3/..."

exit -1



:HAS_CELL_SDK



mount.exe -f %CYGWIN_DIR% /

mount.exe -f %CYGWIN_DIR%/bin /usr/bin

mount.exe -f %CYGWIN_DIR%/lib /usr/lib

mount.exe -f %BASE_DIR% /base



SET DEFAULT_MK=Code/Tools/Make/Default.mk

SET DISTCC_HOSTS=192.168.222.222/10 192.168.222.221/10



REM SET DISTCC_VERBOSE=1



REM For verbose output, add MKOPTION_VERBOSE=1 MKOPTION_COMPACT=0

SET MKOPTION_DISTCC=1 MKOPTION_MAKEFLAGS=-k



IF EXIST %BASE_DIR%/Config.bat CALL %BASE_DIR%/Config.bat

SET MAKE_OPTIONS=%MAKE_OPTIONS% CONFIG=%CONFIG% HOST_SYSTEM=Windows

SET MAKE_OPTIONS=%MAKE_OPTIONS% TARGET=%PROJECT_NAME% -r -f %DEFAULT_MK%



CD /D %BASE_DIR%



