// For automated building this script needs to be started from command line with the prefix "cscript <scriptname>"
// or you can set your standart Windows script host to cscript with typing in: "wscript //h:cscript" into command line

var WSHSHELL = WScript.CreateObject("WScript.Shell");
var FSO = WScript.CreateObject("Scripting.FileSystemObject");

// Change here the destination directory(needs to be quoted by '"' in jscript = '\"')
var destDir = "F:\\crysis_Installer_frombatch";
// Change here the game build source directory
var sourceDir = "S:\\Approved_builds\\Game02(3532)_07_21_fastBuild";
// This needs to stay since IS will take the files out of there
var ISSourceDir = "D:\\game01\\IS12 Projects\\crysis\\Game02_build";

var extensionPathToSetupExe = "\\Crysis_setup\\NoMediaLimit\\DiskImages\\";

WScript.Echo("Trying to delete the local InstallShield source folder");
DeleteDir(ISSourceDir);

WScript.Echo("Copying build to the local InstallShield source folder");
FSO.CopyFolder( sourceDir, ISSourceDir, true) ;

WScript.Echo("Trying to delete unneeded files for the Installer from the game build");
DeleteDir(ISSourceDir + "\\tools");
DeleteDir(ISSourceDir + "\\Bind32\\rc");
DeleteDir(ISSourceDir + "\\game\\levels\!AI");
DeleteDir(ISSourceDir + "\\game\\levels\!code");
FSO.DeleteFile(ISSourceDir + "\\*.txt");
FSO.DeleteFile(ISSourceDir + "\\editor\\plugins\\perforce*.*");

WScript.Echo("Launching InstallShield");
var ISExe = "\"D:\\game01\\InstallShield12\\System\\IsCmdBld.exe\"";
var releaseConfig = "-r NoMediaLimit";
var ISProject = "-p \"D:\\game01\\IS12 Projects\\crysis\\crysis.ism\"";
var projectConfig  = "-a \"Crysis_setup\"";
var destDirForCmdLine = "-b \"" + destDir + "\"";

var cmdline = ISExe + " " + releaseConfig + " " + ISProject + " " + projectConfig + " " + destDirForCmdLine;

WSHSHELL.Run( cmdline,1,true );

CellectInOneDir(destDir + extensionPathToSetupExe);

// Function will copy all files into the path of the setup, so it can find them
function CellectInOneDir(disksRootPath)
{
	WScript.Echo("Coping all files into the path of the setup, so it can find them");
	var oFolder = FSO.GetFolder(disksRootPath);
  var enumSubFolders = new Enumerator(oFolder.SubFolders);
	var regExp = /\\Disk([02-9])|([0-9][0-9]+)/i;
	
	// Fill the array with the matching builds
  for (; !enumSubFolders.atEnd(); enumSubFolders.moveNext())
  {
     var diskDir = enumSubFolders.item();
     diskDir += "";
     if(diskDir.search(regExp) != "-1")
     {
     	FSO.CopyFile(diskDir + "\\*.*", disksRootPath + "\\Disk1\\", true);
     }
  }
}

function DeleteDir(folder)
{
	if (FSO.FolderExists( folder ))
	{
		try
		{
		FSO.DeleteFolder( folder, true );
		}
		catch(e)
		{
			var msg = "Couldn't clean up the Installshield source directory! This error occured: " + e.description + " on: " + folder;
			var pushedButton = WSHSHELL.Popup(msg, 0, "Error", 5 + 16);
			if(pushedButton == 4)
				DeleteDir(folder)
				
			WScript.Quit(1);
		}
	}
}