////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   cfgfile.cpp
//  Version:     v1.00
//  Created:     4/11/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

//
// Configuration file class.
// Use format similar to windows .ini files.
//
#include "StdAfx.h"
#include "cfgfile.h"

// trim_right() family.
inline std::string trim_right( const std::string & source ,const std::string & t = " \n" )
{
	std::string str = source;
	return str.erase ( str.find_last_not_of ( t ) + 1 ) ; 
}

// trim_left() family.
inline std::string trim_left( const std::string & source , const std::string & t = " \n" )
{ 
	std::string str = source;
	return str.erase ( 0 , source.find_first_not_of ( t ) ) ; 
}

// trim() family.
inline std::string trim( const std::string & source ,const std::string & t = " \r\n\t" )
{ 
	std::string str = source;
	return trim_left ( trim_right ( str , t ) , t ) ; 
}

///////////////////////////////////////////////////////////////////////////////
//
// Class CfgFile implementation.
//
///////////////////////////////////////////////////////////////////////////////

CfgFile::CfgFile() {
	// Create empty section.
	Section section;
	section.name = "";
	m_sections.push_back( section );

	m_modified = false;
}

CfgFile::CfgFile( const std::string &fileName )
{
	// Create empty section.
	Section section;
	section.name = "";
	m_sections.push_back( section );
	m_modified = false;

	Load( fileName );
}

CfgFile::CfgFile( const char *buf,int bufSize ) {
	// Create empty section.
	Section section;
	section.name = "";
	m_sections.push_back( section );
	m_modified = false;

	LoadBuf( buf,bufSize );
}

CfgFile::~CfgFile()
{
}

// Load configuration file.
bool CfgFile::Load( const std::string &fileName )
{
	m_fileName = fileName;
	m_modified = false;

	FILE *file = fopen( fileName.c_str(),"rb" );
	if (!file)
		return false;

	fseek( file,0,SEEK_END );
	int size = ftell(file);
	fseek( file,0,SEEK_SET );
		
	// Read whole file to memory.
	char *s = (char*)malloc( size+1 );
	memset( s,0,size+1 );
	fread( s,1,size,file );
	LoadBuf( s,size );
	free(s);

	fclose(file);

	return true;
}

void CfgFile::LoadBuf( const char *buf,int bufSize )
{
	// Read entries from config std::string buffer.
	Section *curr_section = 0;

	const char *s = buf;
	int size = bufSize;

	std::string ss = s;

	char str[4096];
	int i = 0, j = 1;
	while (i < size) {
		while (j < size && s[j] != '\n') j++;
		sscanf( &s[i],"%[^\n]s",str );
		
		// Skip sequence "//" (comment)
		if (str[0] == '/' && str[1] == '/')
		{
			i = ++j;
			continue;
		}

		// Skip std::string which begins with character ';' (comment line)
		if (str[0] == ';')
		{
			i = ++j;
			continue;
		}
		// Analyze entry std::string, split on key and value and store in lists.
		std::string entrystr = trim(str);
		if (!entrystr.empty())
		{
			int splitter = entrystr.find( '=' );
			if (splitter > 0) {
				// Key found.
				Entry entry;
				entry.key = entrystr.substr( 0,splitter );	// Before spliter is key name.
				entry.value = entrystr.substr( splitter+1,-1 );	// Everything after splittes is value std::string.
				entry.key = trim(entry.key);
				entry.value = trim(entry.value);
				if (!curr_section) {
					// Empty section.
					curr_section = &m_sections.front();
				}
				// Add this entry to current section.
				curr_section->entries.push_back( entry );
			} else {
				// If not key then probably section std::string.
				entrystr = trim(entrystr);
				if (!entrystr.empty()) {
					if (entrystr[0] == '[' && entrystr[entrystr.size()-1] == ']') {
						// World in bracets is section name.
						Section section;
						section.name = entrystr.substr( 1,entrystr.size()-2 ); // Remove bracets.
						m_sections.push_back( section );
						// Set current section.
						curr_section = &m_sections.back();
					} else {
						// Just empty key value.
						Entry entry;
						entry.value = entrystr;
						if (curr_section) {
							curr_section->entries.push_back( entry );
						}
					}
				}
			}
		}
		i = ++j;
	}
}

//////////////////////////////////////////////////////////////////////////
CfgFile::Section* CfgFile::FindSection( const std::string &section )
{
	// Loop on sections.
	for (std::list<Section>::iterator si = m_sections.begin(); si != m_sections.end(); si++)
	{
		if (stricmp(si->name.c_str(),section.c_str()) == 0)
			return &(*si);
	}
	// If section not found, fallback to empty section
	return &m_sections.front();
}

//////////////////////////////////////////////////////////////////////////
bool CfgFile::GetSection( const char *section,std::vector<Entry> &entries )
{
	Section *sec = FindSection( section );
	if (!sec)
		return false;

	for (std::list<Entry>::iterator it = sec->entries.begin(); it != sec->entries.end(); ++it)
	{
		entries.push_back( *it );
	}

	return true;
}