#ifndef __STDAFX_H__
#define __STDAFX_H__

// Turn off debug stl stuff.
#define _HAS_ITERATOR_DEBUGGING 0
#define _SECURE_SCL 0

// Turn of _DEBUG around stl headers - this is to stop the classes having a first iterator pointer,
// which breaks some binary compatibility. This is only really needed because the Max morpher modifier
// exposes a std::vector as part of the interface to the dll and for some reason expects that to work.
#if defined(_DEBUG)
#	undef _DEBUG
#endif //defined(_DEBUG)

#include <vector>
#include <algorithm>
#include <map>

#include "max.h"
#include "UtilExp.h"
#include "modstack.h"
#include "bipexp.h"
#include "phyexp.h"
#include "stdmat.h"
#include "iparamm2.h"
#include "commdlg.h"
#include "utilapi.h"
#include "macrorec.h"
#include "decomp.h" 
#include "dummy.h"
#include "assert1.h"

#define NOT_USE_CRY_MEMORY_MANAGER

// [MichaelS] Dodgy hack to allow ISystem.h to parse correctly.
struct IXmlUtils;

#define Ray CryRay

// Hack to avoid namespace collision with cryengine clamp
#define clamp clamp_cryengine

// [MichaelS] Dodgy hack to avoid name clash between Array and a Max class of that name.
#define Array CryArray
#include "CryHeaders.h"
#undef Array

#undef clamp

#undef Ray

// In v9 Max replaced NoRemap() with DefaultRemapDir()
#if (MAX_PRODUCT_VERSION_MAJOR >= 9)
#	define MAX_DEFAULT_REMAP DefaultRemapDir
#else // (MAX_PRODUCT_VERSION_MAJOR < 9)
#	define MAX_DEFAULT_REMAP NoRemap
#endif //(MAX_PRODUCT_VERSION_MAJOR < 9)

#endif