//////////////////////////////////////////////////////////////////////////
// Implementation of CryBrowseForDir command, facilitating user choise of
// the target directory for exporting multiple CGF files
#include "stdafx.h"
#include "shlwapi.h"
#include "shlobj.h"
#include "CmdBrowseForDir.h"

CCmdBrowseForDir::CCmdBrowseForDir(void)
{
}

CCmdBrowseForDir::~CCmdBrowseForDir(void)
{
}


int CCmdBrowseForDir::SaveDirDlgCallback (HWND hwnd, UINT uMsg, LPARAM lParam)
{
	switch (uMsg)
	{
	case BFFM_INITIALIZED:
		if (m_strDirectory.length() > 0)
		{
			char* szDir = strdup(m_strDirectory.asChar());
			for (char* p = szDir; *p; ++p)
				if (*p == '/')
					*p = '\\';
			SendMessage (hwnd, BFFM_SETSELECTION, (WPARAM)szDir, (LPARAM)szDir);
			free (szDir);
		}
		break;
	}
	return 0;
}



MStatus	CCmdBrowseForDir::doIt ( const MArgList& args)
{
	MStatus status = parseArgs(args);
	if (!status)
		return status;

	char szDir [0x200];
	BROWSEINFO bi;
	memset (&bi, 0, sizeof(bi));
	bi.hwndOwner      = M3dView::applicationShell();
	bi.pszDisplayName = szDir;
	bi.lpszTitle      = m_strTitle.asChar();
	bi.ulFlags        = BIF_RETURNONLYFSDIRS|BIF_NEWDIALOGSTYLE;

	bi.lpfn   = SaveDirDlg_BrowseCallbackProc;
	bi.lParam = (LPARAM)this;

	LPITEMIDLIST pIIL = SHBrowseForFolder(&bi);
	if (!pIIL)
	{
		setResult (MString(""));
		return status;
	}

	if (!SHGetPathFromIDList (pIIL, szDir))
		szDir[0] = '\0';

	LPMALLOC pMalloc;
	if (SUCCEEDED(SHGetMalloc (&pMalloc)))
	{
		pMalloc->Free(pIIL);
		pMalloc->Release();
	}

	for (char* p = szDir; *p; ++p)
		if (*p == '\\')
			*p = '/';
	setResult (MString(szDir) + "/");
	return status;
}

MSyntax CCmdBrowseForDir::newSyntax()
{
	MSyntax syntax;
	syntax.addFlag ("-d", "-directory", MSyntax::kString);
	syntax.addFlag ("-t", "-title", MSyntax::kString);
	return syntax;
}

MStatus CCmdBrowseForDir::parseArgs (const MArgList& args)
{
	MStatus status = MS::kSuccess;
	
	MArgDatabase argDB (syntax(), args, &status);
	if (!status)
		return status;

	if (MStatus::kSuccess != argDB.getFlagArgument ("-d", 0, m_strDirectory))
		m_strDirectory = "";

	if (MStatus::kSuccess != argDB.getFlagArgument ("-t", 0, m_strTitle))
		m_strTitle = "";

	return status;
}