#pragma once

class CMayaCryShaderUtil
{
public:
	CMayaCryShaderUtil(const MObject& objShader);
	~CMayaCryShaderUtil(void);

	CryIRGB	m_rgbDiffuse;  //diffuse color
	CryIRGB	m_rgbSpecular; //specular color
	CryIRGB	m_rgbAmbient;  //ambient color
	float   m_fSpecLevel;  // Specular level.
	float   m_fSpecShininess;
	float		m_fSelfIllum;  // self illumination.
	float		m_fOpacity;    // Opacity 0-1.

	const char* getNameStr ()const {return m_strName.c_str ();}

	// get the texture that is identified by the nMap constant (specular, diffuse, etc.)
	// into the given texture structure
	bool getTextureInfo (TextureMap3& dst, int nMap);
protected:
	// constructs the Cry-compatible shader name (s_*([#]Templ*)[/Phys])
	void initName ();

	// returns true if the given texture map is present at the corresponding shader connection
	bool isTexturePresent (int nMap);
	
	// returns the fade value of the texture: 1 if the texture if full-range applied, 0 if it's invisible.
	// this works only for some (e.g. bump - through a work node, diffuse  -a special attribute of shader)
	float getTextureAmount (int nMap);
	static const char* getTextureAttrName (int nMap);

	std::string m_strName; // the name of the shader, CryEngine compatible

	// the shader Maya object
	MObject m_objShader;
	// the Fn set to work with the Maya object shader
	MFnLambertShader m_fnLambert;
};
