// Translator plugin.
// Used to export Caf files.
// In fact, translates the translation request into a command CryExoprt* and executes that command.
#include "StdAfx.h"
#include "translatorcAf.h"
#include "MayaUtils.h"

CTranslatorCaf::CTranslatorCaf(const char* szDefaultExtension):
	m_szDefaultExtension(szDefaultExtension)
{
}

CTranslatorCaf::~CTranslatorCaf(void)
{
}

void*	CTranslatorCaf::creatorCaf()
{
	return new CTranslatorCaf("caf");
}

MStatus CTranslatorCaf::reader ( const MFileObject& file,
								const MString& optionsString,
								MPxFileTranslator::FileAccessMode mode)
{
	return MS::kNotImplemented;
}

MStatus CTranslatorCaf::writer ( const MFileObject& file,
								const MString& optionsString,
								MPxFileTranslator::FileAccessMode mode)
{
	Log ("CTranslatorCaf::writer(file:\"%s\", options: \"%s\", mode: %d)", file.fullName().asChar(), optionsString.asChar(), mode);
	return MGlobal::executeCommand(
		MString("CryExportCgf -file \"") + escapeMString(file.fullName()) + "\" " + convertOptionsToFlags(optionsString),
		true, false);
}

bool CTranslatorCaf::haveReadMethod () const
{
	return false;
}

bool CTranslatorCaf::haveWriteMethod () const
{
	return true;
}

MString CTranslatorCaf::defaultExtension () const
{
	return m_szDefaultExtension;
}

bool CTranslatorCaf::canBeOpened() const
{
	return false; // file opening is not implemented 
}
