// --------------------------JScript-------------------------------------------
// This Script will run other task scripts and update scripts if necessary
// -----------
// If you want to call external jscript's  be aware that catching of return codes
// isn't working because of a bug in WSH. External jscripts have to give the return
// code by using the sdandart output if you want to catch it.
// -----------
// Written by Denis Barth(Denis@crytek.de)
// Shortcuts in variable names: L=local | S=Server | F=file


try
{
// This will disable all important actions(update&processing of files) 
// in the build which allows to debug the script locally
var DEBUG = false;

// Create Shell objects.
var WSHSHELL = WScript.CreateObject("WScript.Shell");
var FSO = WScript.CreateObject("Scripting.FileSystemObject");
var WSHNETWORK = WScript.CreateObject("WScript.Network");

var forReading = 1, forWriting = 2, forAppending = 8;
var tristateUseDefault = -2, tristateTrue = -1, tristateFalse = 0;

NoGUIApplication();

// Specify here your mail if you want to get error mails
var adminMail = "Denis@Crytek.de";

// Folder where the buildfiles are located
var computerName = WSHNETWORK.ComputerName.toLowerCase();
var startedInPath = WSHSHELL.CurrentDirectory ;
var workingScriptPath = WScript.ScriptFullName;
var scriptName = "";
var scriptLocation = "";
var regExp = /(.+)\\(.+)\..+$/i;
if(workingScriptPath.search(regExp) != "-1")
{
	scriptLocation = RegExp.$1;
	scriptName = RegExp.$2;
}
else
{
	ErrorExit("Could not get the directory or script name of the working script.");
}

var restart = true;

// Check if the script should have the ability to restart
if (WScript.Arguments.Named.Exists("NoRestart"))
{
	restart = false;
}


// Important variables


// ----------------------------MODULES----------------------------------------------
var aStartModulesNoWaitHideWindowL = new Array();
var aStartModulesNoWaitShowWindowL = new Array();
var aStartModulesWaitShowWindowL = new Array();
var aStartModulesWaitNoWindowL = new Array();
var aFilesToUpdateL = new Array();

if(computerName == "pc106" )
{
	// Modules which will be started hidden and script will NOT wait for them
	
	
	// Modules which will be started in a window and script will wait for them
	aStartModulesWaitShowWindowL.push("cscript " + scriptLocation + "\\AutoCompile.js /Project:Game04");	
	
	// Modules which will be updated
	
}


if(computerName == "8core")
{
	// Modules which will be started hidden and script will NOT wait for them
	aStartModulesNoWaitHideWindowL.push("cscript " + scriptLocation + "\\ActiveFlag.js");	
	
	// Modules which will be started in a window and script will wait for them
	aStartModulesWaitShowWindowL.push("cscript " + scriptLocation + "\\Monkey.js");
	
	// Modules which will be updated
	aFilesToUpdateL.push(scriptLocation + "\\Monkey.js");
	aFilesToUpdateL.push(scriptLocation + "\\ActiveFlag.js");
}
// --------------------------------------------------------------------------------	
	
	

// Log file
var logF = scriptLocation + "\\" + scriptName + ".log";
var	loadedLogFile = FSO.CreateTextFile( logF ,true );

// Server where modules are stored fo update
var server = "\\\\storage";
var scriptsDirS = server + "\\builds\\Build_tools\\Scripts_for_update";

// Files for storing versions
var scriptVrsLF = scriptLocation + "\\Version.txt";
var mainScriptLF = workingScriptPath;
aFilesToUpdateL.push(mainScriptLF);
var scriptVrsSF = scriptsDirS  +"\\Version.txt";

var scriptVrsL = 0;
var scriptVrsS = 1;
var couldNotLoadVrs = false;

// Vars for mail sending
var aErrFiles = new Array(logF);
var aFailEmail = new Array("Denis@crytek.de", "Timur@crytek.de");




///////////////////////////////////////////////////////////////////////////////
// Main.
///////////////////////////////////////////////////////////////////////////////

var i = 0;

// Main loop
while(i<=1000)
{	
	// Load all data from files and update scripts
	LoadSystemFiles();
	
	Log("\r\n---All tasks will be performed now\r\n");
	
	
	// Start all modules WITHOUT a window and with NO wait 
	for(script in aStartModulesNoWaitHideWindowL)
	{
		Run(aStartModulesNoWaitHideWindowL[script], false, false);
	}
	
	// Start all modules WITH a window and with NO wait 
	for(script in aStartModulesNoWaitShowWindowL)
	{
		Run(aStartModulesNoWaitShowWindowL[script], false, true);
	}

	// Start all modules WITH a window and WITTH wait
	for(script in aStartModulesWaitShowWindowL)
	{
		Run(aStartModulesWaitShowWindowL[script], true, true);
	}
	
	// Start all modules WITHOUT a window and WITTH wait
	for(script in aStartModulesWaitNoWindowL)
	{
		Run(aStartModulesWaitNoWindowL[script], true, false);
	}
	
	i++;
	
	Log("\r\n---All task were started\r\n\r\nSleeping for 10 seconds and restarting\r\n");
	WScript.Sleep(10000);
}

//Restart if script was runngin 1000 times
Restart(true);


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////////
// Functions.
///////////////////////////////////////////////////////////////////////////////

//+++++++++++++++++++++++++Function for writing to the log+++++++++++++++++++++++++
function Log(str) 
{
	var couldNotLog = "   (Could not write this line to log file)";
	
	if(loadedLogFile != null)
	{
		try
		{
			loadedLogFile.WriteLine( str );
		}
		catch(e)
		{
			str += couldNotLog;
		}
	}
	else 
		str += couldNotLog;
		
	WScript.Echo( str );
}

function ErrorExit(errStr)
{
	Log(errStr);
	Log("<ReturnCode:1>");
	WScript.StdErr.Write("<ReturnCode:1>");
	WScript.Sleep(5000);
	WScript.Quit(1);
}



//++++++++++++++++++++++Prevents this script to be started without a dos window+++++++++++++
function NoGUIApplication()
{  
	var scriptHost = WScript.FullName;
	var regExp = /cscript.exe/i
	if(scriptHost.search(regExp) == "-1")
	{
		WSHSHELL.Popup( "Invalid script Host - This application is made for commandline use only\n"+
	                    "Please start the script with \"cscript\" before the scriptname e.g.: cscript <ScriptName>\n",
	                    0,"Error",0);
	                    
	 	ErrorExit("Script was started with the wrong host");
	}
}


//+++++++++++++++++++++++++Initial operation like loading files etc.+++++++++++++++++++++++++
function LoadSystemFiles()
{	
	Log("\r\n\r\n---Loading System Files\r\n");
	// Load the local script version 
	try
	{
		Log("Loading local script version file from: " + scriptVrsLF);
		if(FSO.FileExists(scriptVrsLF))
		{
			var loadedScriptVrsLF = FSO.OpenTextFile( scriptVrsLF, forReading );
			if(!loadedScriptVrsLF.AtEndOfStream)
			{
				scriptVrsL = parseInt(loadedScriptVrsLF.ReadLine());
				if (isNaN(scriptVrsL)) 
			  {
			  	couldNotLoadVrs = true;
			  	Log("Could not get local script version. The data from file is not a number.");
			  	scriptVrsL = 0; 
			 	}
			}
			else if (loadedScriptVrsLF.AtEndOfStream)
			{
				couldNotLoadVrs = true;
				Log("Local script version file is empty.");
			}
			loadedScriptVrsLF.Close();
		}
		else
		{
			couldNotLoadVrs = true;
			Log("Local script version file does not exists, creating it..");
			var	loadedVersionFile = FSO.CreateTextFile(scriptVrsLF,true );
			loadedVersionFile.WriteLine("0");
			loadedVersionFile.Close();
		}
	}
	catch(e)
	{
		couldNotLoadVrs = true;
		Log(e.description + " On file:" + scriptVrsLF);
	}
		
	// Load the server script version 
	try
	{
		Log("Loading server script version file from: " + scriptVrsSF);
		if(FSO.FileExists(scriptVrsSF))
		{
			var loadedScriptVrsSF = FSO.OpenTextFile( scriptVrsSF, forReading );
			if(!loadedScriptVrsSF.AtEndOfStream)
			{
				scriptVrsS = parseInt(loadedScriptVrsSF.ReadLine());
				if (isNaN(scriptVrsS)) 
			  {
			  	couldNotLoadVrs = true;
			  	Log("Could not get server script version,The data from file is not a number.");
			  	scriptVrsS = 1; 
			 	}
				loadedScriptVrsSF.Close();
			}
			else if (loadedScriptVrsSF.AtEndOfStream)
			{
				couldNotLoadVrs = true;
				Log("Server script version file is empty.");
			}
		}
		else
		{
			couldNotLoadVrs = true;
			Log("WARNING! Server script version file does not exists");
		}
	}
	catch(e)
	{
		couldNotLoadVrs = true;
		Log(e.description + " On file:" + scriptVrsSF);
	}
	
	Log("\r\n---Finished loading System Files\r\n\r\n");
	
	// Update the script if neseccary
	UpdateScripts();
}

//+++++++++++++++++++++++++Mainfunction for sending mails+++++++++++++++++++++++++
function SendMail( recipient,msg,subject,attachmentsArray,importance, scriptLogObjectForClose )
{
	Log( "Sending Mail to "+recipient+", With subject: "+subject );
	
	if(scriptLogObjectForClose != null)
	{
		Log("Closing Log file");
		try
		{
			scriptLogObjectForClose.Close();
			scriptLogObjectForClose = null;
		}
		catch(e)
		{
			Log("Could not close the log file because of: " + e.description);
		}
	}
	
	var cdoConfig = new ActiveXObject("CDO.Configuration");
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/sendusing") = 2; //cdoSendUsingPort
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = 1; //cdoBasic
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpserver") = "mail2.INTERN.CRYTEK.DE";
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = 25;
	cdoConfig.Fields.Update();

	var cdoMessage = new ActiveXObject( "CDO.Message" );
	cdoMessage.Configuration = cdoConfig;

	cdoMessage.subject = subject;
	cdoMessage.From = "Build@crytek.de";
	cdoMessage.To = recipient;
	cdoMessage.TextBody = msg;

	
	var i;	
	for (i = 0; i < attachmentsArray.length; i++)
	{
		if (FSO.FileExists( attachmentsArray[i] ))
		{
			Log("Adding file to mail: " + attachmentsArray[i].toString());
			cdoMessage.AddAttachment( attachmentsArray[i] );
		}
	}

	try
	{
		cdoMessage.Send();
	}
	catch(e)
	{
		Log("The following error occured while trying to send a mail:\r\n"+e.description);
		Log("\r\nMail properties:\r\nSubject:\r\n" + subject + "\r\nMessage:\r\n"+msg+"\r\n\Recipient:\r\n"+recipient);
	}
	cdoConfig = null;
	cdoMessage = null;
}

//+++++++++++++++++++++++++Check if Script needs update and update if it is so+++++++++++++++++++++++++
function UpdateScripts()
{
	if(scriptVrsS>scriptVrsL || couldNotLoadVrs)
	{	
		var error = false;
		
		Log("\r\n\r\n---Starting update procedure\r\n");
		
		// regExp for searching of the script name
		var regExp = /.*\\(.*)$/i;
		
		if(scriptVrsS>scriptVrsL)
			Log("Newer scripts are available at the sever. Updating scripts...\r\n");
		else
		{
			Log("WARNING! Couldn't figure out whether new scripts are available for update because a source couldn't be read.");
			Log("Updating will be started anyway because this is the default behaviour.");
		}
		
		
		// start updating all modules
		for (file in aFilesToUpdateL)
		{
			Log("\r\nUpdating script: " + aFilesToUpdateL[file].toString());
	
			// Check if path contain a valid file
			if(aFilesToUpdateL[file].search(regExp) != "-1")
			{
				try
				{
					scriptName = RegExp.$1;
					Log("With file " + scriptsDirS + "\\" + scriptName);
					// Get a handle to module file on server
			   	loadedScriptSF = FSO.GetFile(scriptsDirS + "\\" + scriptName);
			   	// Update local module
			   	loadedScriptSF.Copy(aFilesToUpdateL[file],true);
			   	loadedScriptSF = null;
			   	
			   	Log("Successfully updated.");
				}
				catch(e)
				{
					Log("WARNING! Update failed on script: " + aFilesToUpdateL[file] + " error: " + e.description);
				}
			}
			else
			{
				error = true;
				Log("WARNING! Update failed on script: " + aFilesToUpdateL[file] + " Couldn't extract the script name out of the local path.");
			}
		}
		
		
		// If update failed, cause an error so a mail can be sent
		if(error)
		{
			var errorStr = "Update of scripts failed!";
			Log(errorStr);
			throw new Error(1, errorStr);      	
		}
		
   	
   	// Save version locally
   	if(!couldNotLoadVrs)
   	{
		 	Log("\r\nWriting new version into the local version file");
		 	try
			{
		 		// Write the new Version of Script into a file
		   	var	loadedScriptVrsLF = FSO.CreateTextFile( scriptVrsLF ,true );
				loadedScriptVrsLF.WriteLine(scriptVrsS);
				loadedScriptVrsLF.Close();
			}
		 	catch(e)
		 	{
		 		Log("WARNING! Couldn't save the new version because of " + e.description + " on file:"+scriptVrsLF);
		 	}
   	}
   	
   	Log("\r\n---Finished update procedure\r\n\r\n");
   	
   	// Restart this scirp in case there was a newer version on the server of itself
   	if(restart)
   		Restart(false);
   	else 
   		restart = true;
	}
	else
		Log("\r\n---No newer automated script version is available on the sever. No Update needed.\r\n\r\n");
		
	
}


//++++++++++++++++++++++++++Restart function with a option which allows the restarted script to be restarted or not+++++++++++++++
function Restart(nextRestart)
{
	var runLine = "cscript " + mainScriptLF;
	if(!nextRestart)
		runLine += " /NoRestart";	
		
	Log("Restarting script with "+runLine);
  WSHSHELL.Run( runLine,1,false);
	WScript.Quit(0);
}


//+++++++++++++++++++++++++Run a Jscript and get the Return Code out of the standart output+++++++++++++++++++++++++
function Run(scriptPath, wait, showWindow)
{
	var msgExt = " without to wait for it";
	if(wait == true)
		msgExt = " and will wait for it";
		
	Log("Starting module" + msgExt + ": " + scriptPath);
	if(showWindow)
		result = WSHSHELL.Run( "%comspec% /c " + scriptPath,1,wait );
	else
	{
		var oExec = WSHSHELL.Exec("%comspec% /c " + scriptPath);

		while (oExec.Status == 0 && wait == true)
		{
		     WScript.Sleep(1000);
		}
	}
			
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////



}
catch(e)
{
	WScript.Echo("error: "+e);
	WScript.Echo("error number: "+e.number & 0xFFFF);
	WScript.Echo("error description: "+e.description);
	errorLogFile = FSO.CreateTextFile(  scriptLocation + "\\" + scriptName + "_ERROR.log",true );
	errorLogFile.WriteLine("error: "+e);
	errorLogFile.WriteLine("error number: "+e.number & 0xFFFF);
	errorLogFile.WriteLine("error message: "+e.message);
	errorLogFile.WriteLine("error description: "+e.description);
	errorLogFile.WriteLine("Trying to send out a mail with the log as last step");
	errorLogFile.Close();
	aErrFiles.push(scriptLocation + "\\" + scriptName + "_ERROR.log");
	SendMail( aFailEmail,"Please look at the log files and fix the problem","Error in automated start and update system on client " + WSHNETWORK.ComputerName,aErrFiles,2 ,loadedLogFile);												
	WScript.Quit(1);
}