#pragma once

#include "BezierApproximation.h"

class CBezierVec3dApproximation
{
public:
	CBezierApproximation x,y,z;
	CBezierApproximation& operator [] (int i) {assert(i>=0&&i<3);return (&x)[i];}

	CBezierVec3dApproximation();
	CBezierVec3dApproximation(Vec3d* pData, int nSamples, int nDegree);
	void init(Vec3d* pData, int nSamples, int nDegree);
	void clear();
	~CBezierVec3dApproximation(void);

	class CDataAdaptor: public CBezierApproximation::IData
	{
	public:
		CDataAdaptor (Vec3d* pData, int nSamples, int nCoord):
			m_pData(pData), m_nSamples(nSamples), m_nCoord(nCoord)
		{}

		void setCoord(int nCoord)
		{
			m_nCoord = nCoord;
		}

		double getPoint (int nSample)
		{
			return m_pData[nSample][m_nCoord];
		}
		
		int numPoints()
		{
			return m_nSamples;
		}

	protected:
		Vec3d* m_pData;
		int m_nSamples;
		int m_nCoord;
	};

	int numSamples()const {return x.numSamples();}
	Vec3d getValueAtTime(double t)const
	{
		return Vec3d ((float)(x.getValueAtTime (t)), (float)y.getValueAtTime (t), (float)z.getValueAtTime (t));
	}
	Vec3d getValueAtFrame(int nFrame)const
	{
		return Vec3d ((float)x.getValueAtFrame (nFrame), (float)y.getValueAtFrame (nFrame), (float)z.getValueAtFrame (nFrame));
	}

	// calculates the sum of squares of the errors between the approximated and real values,
	// real value array given, of the size of initial data set
	double getError (Vec3d* pData);
protected:
};
