// src\DlgApprParams.cpp : implementation file
//

#include "stdafx.h"
#include "MotionOptimizer.h"
#include "DlgApprParams.h"


// CDlgApprParams dialog

IMPLEMENT_DYNAMIC(CDlgApprParams, CDialog)
CDlgApprParams::CDlgApprParams(CWnd* pParent, CBSplineApprTest::Params params)
	: CDialog(CDlgApprParams::IDD, pParent),
	m_Params (params),
	m_strOkText ("OK"),
	m_strCancelText("Cancel")
{
}

CDlgApprParams::~CDlgApprParams()
{
}

void CDlgApprParams::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Check (pDX, IDC_ENABLENR, m_Params.bEnableNR);
	
	DDX_Text (pDX, IDC_DEGREE, m_Params.nDegree);
	DDV_MinMaxInt(pDX, m_Params.nDegree, 1, 8);
	
	DDX_Text(pDX, IDC_NRITERS, m_Params.nNRIters);
	DDV_MinMaxInt(pDX, m_Params.nNRIters, 0,10000);
	
	DDX_Text(pDX, IDC_PRECISION, m_Params.fPrecision);
	DDV_MinMaxFloat(pDX, m_Params.fPrecision, 1, 1e+5f);

	DDX_Text(pDX, IDC_CLAMP_RANGE_MIN, m_Params.fValRangeClampMin);
	DDV_MinMaxFloat(pDX, m_Params.fValRangeClampMin, 1e-5f, 1e+5f);

	DDX_Text(pDX, IDC_CLAMP_RANGE_MAX, m_Params.fValRangeClampMax);
	DDV_MinMaxFloat(pDX, m_Params.fValRangeClampMax, m_Params.fValRangeClampMin, 1e+5);

	DDX_Text (pDX, IDC_FALLBACK, m_Params.fErrorFallback);
	DDV_MinMaxFloat(pDX, m_Params.fErrorFallback, 0.5f, 10);

	DDX_Text (pDX, IDC_SMOOTHING, m_Params.fSmoothing);
	DDV_MinMaxDouble (pDX, m_Params.fSmoothing, 0, 100);

	DDX_Text (pDX, IDC_MINSPKNR, m_Params.fMinSPKForNR);
	DDV_MinMaxFloat (pDX, m_Params.fMinSPKForNR, 1, 1e+5);
}


BEGIN_MESSAGE_MAP(CDlgApprParams, CDialog)
END_MESSAGE_MAP()


// CDlgApprParams message handlers

BOOL CDlgApprParams::OnInitDialog()
{
	CDialog::OnInitDialog();

	// extra initialization here
	if (!m_sTitle.empty())
		SetWindowText (m_sTitle.c_str());

	SetDlgItemText (IDOK, m_strOkText.c_str());
	SetDlgItemText(IDCANCEL, m_strCancelText.c_str());

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
