using System;

namespace NetworkBandwidthAnalyser
{
	/// <summary>
	/// Summary description for BandwidthLog.
	/// </summary>
	public class BandwidthLog : IParserSink
	{
		private System.Collections.ArrayList packets;
		private System.Collections.Specialized.StringCollection allIPs;

		public BandwidthLog( System.IO.StreamReader input )
		{
			allIPs = new System.Collections.Specialized.StringCollection();
			packets = new System.Collections.ArrayList();
			Parser parser = new Parser(this);
			String line;
			try
			{
				while ((line = input.ReadLine()) != null)
					parser.AddLine(line.Split(' '));
			}
			catch (FailedParse f)
			{
				System.Windows.Forms.MessageBox.Show("Couldn't parse entire file");
			}
			catch (System.Exception e)
			{
				System.Windows.Forms.MessageBox.Show("Couldn't parse entire file: " + e.ToString());
			}
		}

		public int MessageCount
		{
			get
			{
				int count = 0;
				foreach (Packet p in packets)
				{
					count += p.MessageCount;
				}
				return count;
			}
		}

		public double[] PacketSizes( String filterIP )
		{
			System.Collections.ArrayList ary = new System.Collections.ArrayList();
			foreach (Packet p in packets)
			{
				if (p.ip == filterIP)
					ary.Add((double)p.TotalSize);
			}
			double[] ret = new double[ary.Count];
			ary.CopyTo(ret);
			return ret;
		}
		public double[] OverheadSizes( String filterIP )
		{
			System.Collections.ArrayList ary = new System.Collections.ArrayList();
			foreach (Packet p in packets)
			{
				if (p.ip == filterIP)
					ary.Add((double)p.TotalOverheadSize);
			}
			double[] ret = new double[ary.Count];
			ary.CopyTo(ret);
			return ret;
		}
		public double[] OverheadSizes( String filterIP, String filterMsg )
		{
			System.Collections.ArrayList ary = new System.Collections.ArrayList();
			foreach (Packet p in packets)
			{
				if (p.ip == filterIP)
					ary.Add( p.OverheadSize( filterMsg ) );
			}
			double[] ret = new double[ary.Count];
			ary.CopyTo(ret);
			return ret;
		}
		public double[] PacketTimes( String filterIP )
		{
			System.Collections.ArrayList ary = new System.Collections.ArrayList();
			foreach (Packet p in packets)
			{
				if (p.ip == filterIP)
					ary.Add((double)p.Time);
			}
			double[] ret = new double[ary.Count];
			ary.CopyTo(ret);
			return ret;
		}
		public double[] MessageSizes( String filterIP, String filterMsg )
		{
			System.Collections.ArrayList ary = new System.Collections.ArrayList();
			foreach (Packet p in packets)
			{
				if (p.ip == filterIP)
					p.AddMessageSizes( ary, filterMsg );
			}
			double[] ret = new double[ary.Count];
			ary.CopyTo(ret);
			return ret;
		}
		public double[] MessageHeaderSizes( String filterIP, String filterMsg )
		{
			System.Collections.ArrayList ary = new System.Collections.ArrayList();
			foreach (Packet p in packets)
			{
				if (p.ip == filterIP)
					p.AddMessageHeaderSizes( ary, filterMsg );
			}
			double[] ret = new double[ary.Count];
			ary.CopyTo(ret);
			return ret;
		}
		public double[] MessageTimes( String filterIP, String filterMsg )
		{
			System.Collections.ArrayList ary = new System.Collections.ArrayList();
			foreach (Packet p in packets)
			{
				if (p.ip == filterIP)
					p.AddMessageTimes( ary, filterMsg );
			}
			double[] ret = new double[ary.Count];
			ary.CopyTo(ret);
			return ret;
		}
		public String[] AllMessageNames
		{
			get
			{
				System.Collections.Specialized.StringCollection sc =
					new System.Collections.Specialized.StringCollection();
				foreach (Packet p in packets)
				{
					p.AddMessageNames(sc);
				}
				String[] temp = new String[sc.Count];
				sc.CopyTo(temp,0);
				return temp;
			}
		}
		public double[] DataSizes( String filterIP, String filterMsg )
		{
			System.Collections.ArrayList ary = new System.Collections.ArrayList();
			foreach (Packet p in packets)
			{
				if (p.ip == filterIP)
					p.AddDataSizes( ary, filterMsg );
			}
			double[] ret = new double[ary.Count];
			ary.CopyTo(ret);
			return ret;
		}
		public double[] DataTimes( String filterIP, String filterMsg )
		{
			System.Collections.ArrayList ary = new System.Collections.ArrayList();
			foreach (Packet p in packets)
			{
				if (p.ip == filterIP)
					p.AddDataTimes( ary, filterMsg );
			}
			double[] ret = new double[ary.Count];
			ary.CopyTo(ret);
			return ret;
		}
		public CategorySummation MessageTotals( String filterIP )
		{
			CategorySummation sum = new CategorySummation();
			foreach (Packet p in packets)
			{
				if (p.ip == filterIP)
					p.AddMessageSizes( sum );
			}
			return sum;
		}
		public String[] AllDataNames
		{
			get
			{
				System.Collections.Specialized.StringCollection sc =
					new System.Collections.Specialized.StringCollection();
				foreach (Packet p in packets)
				{
					p.AddDataNames(sc);
				}
				String[] temp = new String[sc.Count];
				sc.CopyTo(temp,0);
				return temp;
			}
		}
		public String[] AllOverheadNames
		{
			get
			{
				System.Collections.Specialized.StringCollection sc =
					new System.Collections.Specialized.StringCollection();
				foreach (Packet p in packets)
				{
					p.AddOverheadNames(sc);
				}
				String[] temp = new String[sc.Count];
				sc.CopyTo(temp,0);
				return temp;
			}
		}

		public double[] PacketIDs
		{
			get
			{
				double[] ret = new double[packets.Count];
				for (int i=0; i<packets.Count; i++)
					ret[i] = ((Packet)packets[i]).ID;
				return ret;
			}
		}

		public String[] AllIPs
		{
			get
			{
				String[] temp = new String[allIPs.Count];
				allIPs.CopyTo(temp,0);
				return temp;
			}
		}

		#region IParserSink Members

		public void AddLine(Parser parser, String[] tokens)
		{
			if (tokens[0] == "BeginPacket")
			{
				if (!allIPs.Contains(tokens[1]))
					allIPs.Add(tokens[1]);
				Packet packet = new Packet( tokens[1], 
					System.Convert.ToInt32(tokens[2]),
					System.Convert.ToInt32(tokens[3]));
				parser.BeginSink(packet);
				packets.Add(packet);
				return;
			}
			parser.Fail( tokens[0] );
		}

		#endregion
	}
}
