using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace NetworkBandwidthAnalyser
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem MenuFileOpen;
		private System.Windows.Forms.MenuItem MenuFileExit;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.OpenFileDialog OpenFileDlg;
		private scpl.Windows.PlotSurface2D plot;
		private System.Windows.Forms.ComboBox FilterIP;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.ComboBox SelectPlot;
		private System.Windows.Forms.CheckBox DisplayAverage;
		private System.Windows.Forms.CheckBox DisplayStdDev;
		private System.Windows.Forms.CheckBox DisplayMedian;
		private System.Windows.Forms.ComboBox FineFilter;

		private BandwidthLog bandwidthLog;
		private System.Windows.Forms.TrackBar trackBar1;
		private System.Windows.Forms.TrackBar trackBar2;

		private delegate void CreatePlotDelegate();
		private delegate void InitFineFilterDelegate();
		private struct PlotType
		{
			public PlotType( String name, 
				CreatePlotDelegate createPlot,
				InitFineFilterDelegate initFineFilter )
			{
				this.name = name;
				this.createPlot = createPlot;
				this.initFineFilter = initFineFilter;
			}

			public String name;
			public CreatePlotDelegate createPlot;
			public InitFineFilterDelegate initFineFilter;
		};
		private PlotType[] plotTypes;

		public MainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//

			plotTypes = new PlotType[] {
				new PlotType(
					"Packet Size over Time", 
					new CreatePlotDelegate(CreatePacketSizeOverTimePlot), 
					new InitFineFilterDelegate(NoFineFilter)),
				new PlotType(
					"Total Overhead Size over Time", 
					new CreatePlotDelegate(CreateTotalOverheadSizeOverTimePlot), 
					new InitFineFilterDelegate(NoFineFilter)),
				new PlotType(
					"Overhead Size over Time", 
					new CreatePlotDelegate(CreateOverheadSizeOverTimePlot), 
					new InitFineFilterDelegate(OverheadFineFilter)),
				new PlotType(
					"Total Packet Size over Time", 
					new CreatePlotDelegate(CreateTotalPacketSizeOverTimePlot), 
					new InitFineFilterDelegate(NoFineFilter)),
				new PlotType(
					"Message Size over Time", 
					new CreatePlotDelegate(CreateMessageSizeOverTimePlot), 
					new InitFineFilterDelegate(MessageFineFilter)),
				new PlotType(
					"Message Header Size over Time", 
					new CreatePlotDelegate(CreateMessageHeaderSizeOverTimePlot), 
					new InitFineFilterDelegate(MessageFineFilter)),
				new PlotType(
					"Message Total Size", 
					new CreatePlotDelegate(CreateMessageTotalSizePlot), 
					new InitFineFilterDelegate(NoFineFilter)),
				new PlotType(
					"Message Counts", 
					new CreatePlotDelegate(CreateMessageCountsPlot), 
					new InitFineFilterDelegate(NoFineFilter)),
				new PlotType(
					"Message Average Size", 
					new CreatePlotDelegate(CreateMessageAverageSizePlot), 
					new InitFineFilterDelegate(NoFineFilter)),
				new PlotType(
					"Message Maximum Size", 
					new CreatePlotDelegate(CreateMessageMaximumSizePlot), 
					new InitFineFilterDelegate(NoFineFilter)),
				new PlotType(
					"Message Minimum Size", 
					new CreatePlotDelegate(CreateMessageMinimumSizePlot), 
					new InitFineFilterDelegate(NoFineFilter)),
				new PlotType(
					"Data Size over Time", 
					new CreatePlotDelegate(CreateDataSizeOverTimePlot), 
					new InitFineFilterDelegate(DataFineFilter))
			};

			foreach (PlotType plotType in plotTypes)
			{
				SelectPlot.Items.Add(plotType.name);
			}
			SelectPlot.SelectedIndex = 0;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.MenuFileOpen = new System.Windows.Forms.MenuItem();
			this.MenuFileExit = new System.Windows.Forms.MenuItem();
			this.OpenFileDlg = new System.Windows.Forms.OpenFileDialog();
			this.plot = new scpl.Windows.PlotSurface2D();
			this.FilterIP = new System.Windows.Forms.ComboBox();
			this.label2 = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.SelectPlot = new System.Windows.Forms.ComboBox();
			this.DisplayAverage = new System.Windows.Forms.CheckBox();
			this.DisplayStdDev = new System.Windows.Forms.CheckBox();
			this.DisplayMedian = new System.Windows.Forms.CheckBox();
			this.label3 = new System.Windows.Forms.Label();
			this.FineFilter = new System.Windows.Forms.ComboBox();
			this.trackBar1 = new System.Windows.Forms.TrackBar();
			this.trackBar2 = new System.Windows.Forms.TrackBar();
			((System.ComponentModel.ISupportInitialize)(this.trackBar1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.trackBar2)).BeginInit();
			this.SuspendLayout();
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.menuItem1});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.MenuFileOpen,
																					  this.MenuFileExit});
			this.menuItem1.Text = "&File";
			// 
			// MenuFileOpen
			// 
			this.MenuFileOpen.Index = 0;
			this.MenuFileOpen.Shortcut = System.Windows.Forms.Shortcut.CtrlO;
			this.MenuFileOpen.Text = "&Open Log...";
			this.MenuFileOpen.Click += new System.EventHandler(this.MenuFileOpen_Click);
			// 
			// MenuFileExit
			// 
			this.MenuFileExit.Index = 1;
			this.MenuFileExit.Text = "E&xit";
			this.MenuFileExit.Click += new System.EventHandler(this.MenuFileExit_Click);
			// 
			// OpenFileDlg
			// 
			this.OpenFileDlg.DefaultExt = "log";
			this.OpenFileDlg.Filter = "Log files|*.log|All Files|*.*";
			this.OpenFileDlg.FileOk += new System.ComponentModel.CancelEventHandler(this.OpenFileDlg_FileOk);
			// 
			// plot
			// 
			this.plot.AllowSelection = false;
			this.plot.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.plot.BackColor = System.Drawing.SystemColors.Control;
			this.plot.Legend = null;
			this.plot.Location = new System.Drawing.Point(8, 120);
			this.plot.Name = "plot";
			this.plot.Padding = 10;
			this.plot.PlotBackColor = System.Drawing.Color.White;
			this.plot.ShowCoordinates = true;
			this.plot.Size = new System.Drawing.Size(640, 328);
			this.plot.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
			this.plot.TabIndex = 2;
			this.plot.Title = "";
			this.plot.TitleFont = new System.Drawing.Font("Arial", 14F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Pixel);
			this.plot.XAxis1 = null;
			this.plot.XAxis2 = null;
			this.plot.YAxis1 = null;
			this.plot.YAxis2 = null;
			// 
			// FilterIP
			// 
			this.FilterIP.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.FilterIP.Location = new System.Drawing.Point(80, 8);
			this.FilterIP.Name = "FilterIP";
			this.FilterIP.Size = new System.Drawing.Size(128, 21);
			this.FilterIP.Sorted = true;
			this.FilterIP.TabIndex = 3;
			this.FilterIP.SelectedIndexChanged += new System.EventHandler(this.FilterIP_SelectedIndexChanged);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 8);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(72, 16);
			this.label2.TabIndex = 4;
			this.label2.Text = "Filter IP:";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(320, 8);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(64, 16);
			this.label1.TabIndex = 6;
			this.label1.Text = "Plot:";
			// 
			// SelectPlot
			// 
			this.SelectPlot.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.SelectPlot.Location = new System.Drawing.Point(392, 8);
			this.SelectPlot.Name = "SelectPlot";
			this.SelectPlot.Size = new System.Drawing.Size(256, 21);
			this.SelectPlot.TabIndex = 5;
			this.SelectPlot.SelectedIndexChanged += new System.EventHandler(this.SelectPlot_SelectedIndexChanged);
			// 
			// DisplayAverage
			// 
			this.DisplayAverage.Location = new System.Drawing.Point(216, 8);
			this.DisplayAverage.Name = "DisplayAverage";
			this.DisplayAverage.Size = new System.Drawing.Size(96, 16);
			this.DisplayAverage.TabIndex = 7;
			this.DisplayAverage.Text = "Average";
			this.DisplayAverage.CheckedChanged += new System.EventHandler(this.DisplayAverage_CheckedChanged);
			// 
			// DisplayStdDev
			// 
			this.DisplayStdDev.Location = new System.Drawing.Point(216, 24);
			this.DisplayStdDev.Name = "DisplayStdDev";
			this.DisplayStdDev.Size = new System.Drawing.Size(96, 16);
			this.DisplayStdDev.TabIndex = 8;
			this.DisplayStdDev.Text = "1 StdDev";
			this.DisplayStdDev.CheckedChanged += new System.EventHandler(this.DisplayStdDev_CheckedChanged);
			// 
			// DisplayMedian
			// 
			this.DisplayMedian.Location = new System.Drawing.Point(216, 40);
			this.DisplayMedian.Name = "DisplayMedian";
			this.DisplayMedian.Size = new System.Drawing.Size(96, 16);
			this.DisplayMedian.TabIndex = 9;
			this.DisplayMedian.Text = "Median";
			this.DisplayMedian.CheckedChanged += new System.EventHandler(this.DisplayMedian_CheckedChanged);
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(320, 32);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(72, 16);
			this.label3.TabIndex = 10;
			this.label3.Text = "Fine Filter:";
			// 
			// FineFilter
			// 
			this.FineFilter.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.FineFilter.Location = new System.Drawing.Point(392, 32);
			this.FineFilter.Name = "FineFilter";
			this.FineFilter.Size = new System.Drawing.Size(256, 21);
			this.FineFilter.Sorted = true;
			this.FineFilter.TabIndex = 11;
			this.FineFilter.SelectedIndexChanged += new System.EventHandler(this.FineFilter_SelectedIndexChanged);
			// 
			// trackBar1
			// 
			this.trackBar1.Location = new System.Drawing.Point(8, 64);
			this.trackBar1.Name = "trackBar1";
			this.trackBar1.Size = new System.Drawing.Size(312, 45);
			this.trackBar1.TabIndex = 12;
			this.trackBar1.TickStyle = System.Windows.Forms.TickStyle.TopLeft;
			this.trackBar1.Scroll += new System.EventHandler(this.trackBar1_Scroll);
			// 
			// trackBar2
			// 
			this.trackBar2.Location = new System.Drawing.Point(336, 64);
			this.trackBar2.Name = "trackBar2";
			this.trackBar2.Size = new System.Drawing.Size(312, 45);
			this.trackBar2.TabIndex = 13;
			this.trackBar2.TickStyle = System.Windows.Forms.TickStyle.TopLeft;
			this.trackBar2.Scroll += new System.EventHandler(this.trackBar2_Scroll);
			// 
			// MainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(656, 457);
			this.Controls.Add(this.trackBar2);
			this.Controls.Add(this.trackBar1);
			this.Controls.Add(this.FineFilter);
			this.Controls.Add(this.label3);
			this.Controls.Add(this.DisplayMedian);
			this.Controls.Add(this.DisplayStdDev);
			this.Controls.Add(this.DisplayAverage);
			this.Controls.Add(this.label1);
			this.Controls.Add(this.SelectPlot);
			this.Controls.Add(this.label2);
			this.Controls.Add(this.FilterIP);
			this.Controls.Add(this.plot);
			this.Menu = this.mainMenu1;
			this.Name = "MainForm";
			this.Text = "Network Bandwidth Analysis Tool";
			this.Load += new System.EventHandler(this.MainForm_Load);
			((System.ComponentModel.ISupportInitialize)(this.trackBar1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.trackBar2)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new MainForm());
		}

		private static double[] CreateAverages( double[] v )
		{
			double sum = 0;
			foreach (double x in v)
			{
				sum += x;
			}
			double average = sum / v.GetLength(0);
			double[] r = new double[v.GetLength(0)];
			for (int i=0; i<r.GetLength(0); i++)
				r[i] = average;
			return r;
		}

		private static double[] CreateMedians( double[] v )
		{
			double[] sorted = (double[])v.Clone();
			System.Array.Sort( sorted );
			double median = sorted[v.GetLength(0)/2];
			double[] r = new double[v.GetLength(0)];
			for (int i=0; i<r.GetLength(0); i++)
				r[i] = median;
			return r;
		}

		private void CreateTimeSeriesPlot( double[] times, double[] values )
		{
			if (values.GetLength(0) < 1)
			{
				plot.Visible = false;
				return;
			}
			else
			{
				plot.Visible = true;
			}

			double minTime = times[0];
			double maxTime = times[0];
			for (int i=1; i<times.GetLength(0); i++)
			{
				if (times[i] < minTime)
					minTime = times[i];
				if (times[i] > maxTime)
					maxTime = times[i];
			}
			trackBar1.SetRange((int)minTime,(int)maxTime);
			trackBar2.SetRange(trackBar1.Value,(int)maxTime);

			int count = 0;
			for (int i=0; i<times.GetLength(0); i++)
			{
				if (times[i] < trackBar1.Value)
					continue;
				if (times[i] > trackBar2.Value)
					continue;
				count++;
			}
			double[] newTimes = new double[count];
			double[] newValues = new double[count];
			count = 0;
			for (int i=0; i<times.GetLength(0); i++)
			{
				if (times[i] < trackBar1.Value)
					continue;
				if (times[i] > trackBar2.Value)
					continue;
				newTimes[count] = times[i];
				newValues[count] = values[i];
				count++;
			}
			times = newTimes;
			values = newValues;

			if (values.GetLength(0) < 1)
			{
				plot.Visible = false;
				return;
			}

			scpl.Marker m = 
				new scpl.Marker( scpl.MarkerType.Cross1, 6, new Pen(Color.Blue, 2.0f) );
			scpl.PointPlot pp = new scpl.PointPlot( m );
			pp.ValueData = values;
			pp.AbscissaData = times;
			plot.Add(pp);
			pp = new scpl.PointPlot( m );
			if (DisplayAverage.Checked)
			{
				scpl.LinePlot lp = new scpl.LinePlot();
				lp.ValueData = CreateAverages(values);
				lp.AbscissaData = times;
				plot.Add(lp);
			}
			if (DisplayMedian.Checked)
			{
				scpl.LinePlot lp = new scpl.LinePlot();
				lp.ValueData = CreateMedians(values);
				lp.AbscissaData = times;
				plot.Add(lp);
			}
		}

		private System.Collections.Hashtable 
			SimplifyHash( System.Collections.Hashtable data, int n )
		{
			double[] values = new double[data.Count];
			String[] keys = new String[data.Count];
			data.Values.CopyTo(values,0);
			data.Keys.CopyTo(keys,0);
			System.Array.Sort(values,keys);
			System.Array.Reverse(values);
			System.Array.Reverse(keys);
			System.Collections.Hashtable newData = new System.Collections.Hashtable();
			if (n > data.Count)
				n = data.Count;
			for (int i=0; i<n; i++)
				newData.Add(keys[i], values[i]);
			return newData;
		}

		private void CreateHistoPlot( System.Collections.Hashtable data )
		{
			if (data.Count < 3)
			{
				plot.Visible = false;
				return;
			}

			plot.Visible = true;

			scpl.HistogramPlot hp = new scpl.HistogramPlot();

			trackBar2.SetRange(2, data.Count+1);
			trackBar1.SetRange(2, trackBar2.Value);

			data = SimplifyHash(data, trackBar2.Value);
			System.Collections.Hashtable kdata = SimplifyHash(data, trackBar1.Value);

			double[] values = new double[data.Count];
			data.Values.CopyTo(values,0);
			hp.ValueData = values;
			plot.Add(hp);

			scpl.LabelAxis axis = new scpl.LabelAxis( plot.XAxis1 );
			int i = 0;
			foreach (String k in data.Keys)
			{
				if (kdata.Contains(k))
					axis.AddLabel(k, (double)i);
				else
					axis.AddLabel("", (double)i);
				values[i] = (double) data[k];
				i++;
			}
			axis.LabelFont = new Font("Arial", 10);

			plot.XAxis1 = axis;
		}

		private void TestHistoPlot()
		{
			System.Collections.Hashtable data = new System.Collections.Hashtable();
			data.Add("blah",5);
			data.Add("foo",7);
			data.Add("phi",12);
			CreateHistoPlot(data);
		}

		private void CreateMessageTotalSizePlot()
		{
			CategorySummation cs = bandwidthLog.MessageTotals(FilterIP.SelectedItem.ToString());
			CreateHistoPlot( cs.Totals() );
		}

		private void CreateMessageCountsPlot()
		{
			CategorySummation cs = bandwidthLog.MessageTotals(FilterIP.SelectedItem.ToString());
			CreateHistoPlot( cs.Counts() );
		}

		private void CreateMessageAverageSizePlot()
		{
			CategorySummation cs = bandwidthLog.MessageTotals(FilterIP.SelectedItem.ToString());
			CreateHistoPlot( cs.Averages() );
		}

		private void CreateMessageMaximumSizePlot()
		{
			CategorySummation cs = bandwidthLog.MessageTotals(FilterIP.SelectedItem.ToString());
			CreateHistoPlot( cs.Maximum() );
		}

		private void CreateMessageMinimumSizePlot()
		{
			CategorySummation cs = bandwidthLog.MessageTotals(FilterIP.SelectedItem.ToString());
			CreateHistoPlot( cs.Minimum() );
		}

		private void CreatePacketSizeOverTimePlot()
		{
			CreateTimeSeriesPlot( 
				bandwidthLog.PacketTimes(FilterIP.SelectedItem.ToString()),
				bandwidthLog.PacketSizes(FilterIP.SelectedItem.ToString()) );
		}

		private void CreateTotalOverheadSizeOverTimePlot()
		{
			CreateTimeSeriesPlot( 
				bandwidthLog.PacketTimes(FilterIP.SelectedItem.ToString()),
				bandwidthLog.OverheadSizes(FilterIP.SelectedItem.ToString()) );
		}

		private void CreateOverheadSizeOverTimePlot()
		{
			CreateTimeSeriesPlot( 
				bandwidthLog.PacketTimes(FilterIP.SelectedItem.ToString()),
				bandwidthLog.OverheadSizes(FilterIP.SelectedItem.ToString(), FineFilter.SelectedItem.ToString()) );
		}

		private void CreateTotalPacketSizeOverTimePlot()
		{
			double[] sizes = bandwidthLog.PacketSizes(FilterIP.SelectedItem.ToString());
			for (int i=0; i<sizes.GetLength(0); i++)
				sizes[i] += 28;
			CreateTimeSeriesPlot( 
				bandwidthLog.PacketTimes(FilterIP.SelectedItem.ToString()),
				sizes );
		}

		private void CreateMessageSizeOverTimePlot()
		{
			String ip = FilterIP.SelectedItem.ToString();
			String msg = FineFilter.SelectedItem.ToString();
			CreateTimeSeriesPlot(
				bandwidthLog.MessageTimes(ip, msg),
				bandwidthLog.MessageSizes(ip, msg) );
		}

		private void CreateMessageHeaderSizeOverTimePlot()
		{
			String ip = FilterIP.SelectedItem.ToString();
			String msg = FineFilter.SelectedItem.ToString();
			CreateTimeSeriesPlot(
				bandwidthLog.MessageTimes(ip, msg),
				bandwidthLog.MessageHeaderSizes(ip, msg) );
		}

		private void CreateDataSizeOverTimePlot()
		{
			String ip = FilterIP.SelectedItem.ToString();
			String msg = FineFilter.SelectedItem.ToString();
			CreateTimeSeriesPlot(
				bandwidthLog.DataTimes(ip, msg),
				bandwidthLog.DataSizes(ip, msg) );
		}

		private void NoFineFilter()
		{
			FineFilter.Items.Clear();
			FineFilter.Enabled = false;
		}

		private void MessageFineFilter()
		{
			FineFilter.Items.Clear();
			FineFilter.Enabled = true;
			FineFilter.Items.AddRange(bandwidthLog.AllMessageNames);
			FineFilter.SelectedIndex = 0;
		}

		private void DataFineFilter()
		{
			FineFilter.Items.Clear();
			FineFilter.Enabled = true;
			FineFilter.Items.AddRange(bandwidthLog.AllDataNames);
			FineFilter.SelectedIndex = 0;
		}

		private void OverheadFineFilter()
		{
			FineFilter.Items.Clear();
			FineFilter.Enabled = true;
			FineFilter.Items.AddRange(bandwidthLog.AllOverheadNames);
			FineFilter.SelectedIndex = 0;
		}

		private bool inUpdate = false;
		private InitFineFilterDelegate lastFineFilter = null;
		private void UpdateUI()
		{
			if (inUpdate)
				return;
			inUpdate = true;

			bool loaded = bandwidthLog != null;

			FilterIP.Enabled = loaded;
			SelectPlot.Enabled = loaded;
			DisplayAverage.Enabled = loaded;
			DisplayMedian.Enabled = loaded;
			DisplayStdDev.Enabled = loaded;
			FineFilter.Enabled &= loaded;
			
			if (loaded)
			{
				plot.Clear();
				PlotType pt = GetPlotType(SelectPlot.SelectedItem.ToString());
				if (pt.initFineFilter != lastFineFilter)
				{
					pt.initFineFilter();
					lastFineFilter = pt.initFineFilter;
				}
				pt.createPlot();
				plot.Refresh();
			}
			else
			{
				lastFineFilter = null;
			}

			inUpdate = false;
		}

		PlotType GetPlotType(String name)
		{
			foreach (PlotType p in plotTypes)
				if (p.name == name)
					return p;
			throw new System.Exception();
		}

		private void MenuFileOpen_Click(object sender, System.EventArgs e)
		{
			if (OpenFileDlg.ShowDialog() == System.Windows.Forms.DialogResult.OK)
			{
				BandwidthLog newBandwidthLog = 
					new BandwidthLog(new System.IO.StreamReader(OpenFileDlg.FileName));
				bandwidthLog = newBandwidthLog;

				FilterIP.Items.Clear();
				FilterIP.Items.AddRange(bandwidthLog.AllIPs);
				FilterIP.SelectedIndex = 0;

				UpdateUI();
			}
		}

		private void MenuFileExit_Click(object sender, System.EventArgs e)
		{
			Application.Exit();
		}

		private void MainForm_Load(object sender, System.EventArgs e)
		{
			UpdateUI();
		}

		private void OpenFileDlg_FileOk(object sender, System.ComponentModel.CancelEventArgs e)
		{
		
		}

		private void label1_Click(object sender, System.EventArgs e)
		{
		
		}

		private void DisplayAverage_CheckedChanged(object sender, System.EventArgs e)
		{
			UpdateUI();
		}

		private void DisplayStdDev_CheckedChanged(object sender, System.EventArgs e)
		{
			UpdateUI();
		}

		private void DisplayMedian_CheckedChanged(object sender, System.EventArgs e)
		{
			UpdateUI();
		}

		private void FineFilter_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			UpdateUI();
		}

		private void FilterIP_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			UpdateUI();
		}

		private void SelectPlot_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			UpdateUI();
		}

		private void trackBar1_Scroll(object sender, System.EventArgs e)
		{
			UpdateUI();
		}

		private void trackBar2_Scroll(object sender, System.EventArgs e)
		{
			UpdateUI();
		}

	}
}
