/*
ScPl - A plotting library for .NET

BasePlot.cs
Copyright (C) 2003
Matt Howlett

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
   
2. Redistributions in binary form must reproduce the following text in 
   the documentation and / or other materials provided with the 
   distribution: 
   
   "This product includes software developed as part of 
   the ScPl plotting library project available from: 
   http://www.netcontrols.org/scpl/" 

------------------------------------------------------------------------

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: BasePlot.cs,v 1.8 2004/04/26 04:18:41 mhowlett Exp $

*/

using System;
using System.Drawing;

namespace scpl
{
	/// <summary>
	/// Summary description for BasePlot.
	/// </summary>
	public abstract class BasePlot
	{
		/// <summary>
		/// Parameterless and empty constructor.
		/// </summary>
		protected BasePlot()
		{
		}

		#region DrawLegendLine
		/// <summary>
		/// Method that the trace classes use to draw the line
		/// in the plot legend.
		/// </summary>
		/// <param name="g">The Graphics surface.</param>
		/// <param name="startEnd">The RectangleF storing the position of the legend line.</param>
		public virtual void DrawLegendLine( Graphics g, RectangleF startEnd )
		{
			bool needToDisposePen_ = false;
			Pen	p;
			if ( this.pen_ != null )
			{
				p = (System.Drawing.Pen)this.pen_;
			}
			else
			{
				p =	new	Pen(this.color_);
				needToDisposePen_ = true;
			}

			g.DrawLine( p, startEnd.Left, (startEnd.Top + startEnd.Bottom)/2.0f, 
				startEnd.Right, (startEnd.Top + startEnd.Bottom)/2.0f );

			if (needToDisposePen_) p.Dispose();
		}
		#endregion

		#region set Pen
		/// <summary>
		/// Accessor for the Pen used to draw the trace.
		/// </summary>
		public System.Drawing.Pen Pen
		{
			set
			{
				pen_ = value;
			}
		}
		/// <summary>
		/// The protected Pen member used to draw the trace.
		/// </summary>
		protected System.Drawing.Pen pen_;
		#endregion

		#region get/set Color
		/// <summary>
		/// Plot Color property.
		/// </summary>
		public System.Drawing.Color Color
		{
			set
			{
				color_ = value;
			}
			get
			{
				return color_;
			}
		}
		/// <summary>
		/// Color of Plot [TODO: Did we agree not to have this here!?!!].
		/// </summary>
		protected System.Drawing.Color color_ = Color.Black;
		#endregion

		#region Label
		/// <summary>
		/// The trace label.
		/// </summary>
		public string Label
		{
			get
			{
				return label_;
			}
			set
			{
				this.label_ = value;
			}
		}
		
		private string label_ = "";
		#endregion

		#region ShowLegendLine
		public bool ShowLegendLine
		{
			get
			{
				return showLegendLine_;
			}
			set
			{
				this.showLegendLine_ = value;
			}
		}
		private bool showLegendLine_ = true;
		#endregion

		#region DataSource
		public object DataSource
		{
			get
			{
				return this.dataSource_;
			}
			set
			{
				this.dataSource_ = value;
			}
		}
		protected object dataSource_ = null;
		#endregion
		#region DataMember
		public string DataMember
		{
			get
			{
				return this.dataMember_;
			}
			set
			{
				this.dataMember_ = value;
			}
		}
		protected string dataMember_ = null;
		#endregion
		#region ValueData
		public object ValueData
		{
			get
			{
				return this.valueData_;
			}
			set
			{
				this.valueData_ = value;
			}
		}
		protected object valueData_ = null;
		#endregion		
		#region AbscissaData
		public object AbscissaData
		{
			get
			{
				return this.abscissaData_;
			}
			set
			{
				this.abscissaData_ = value;
			}
		}
		protected object abscissaData_ = null;
		#endregion
	}
}
