/*
ScPl - A plotting library for .NET

PointOLHC.cs
Copyright (C) 2003-2004
Matt Howlett, Paolo Pierini

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
   
2. Redistributions in binary form must reproduce the following text in 
   the documentation and / or other materials provided with the 
   distribution: 
   
   "This product includes software developed as part of 
   the ScPl plotting library project available from: 
   http://www.netcontrols.org/scpl/" 

------------------------------------------------------------------------

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

$Id: PointOLHC.cs,v 1.2 2004/04/26 04:18:41 mhowlett Exp $

*/

using System;

namespace scpl
{
	public class DataOLHC : PointD
	{

		public PointOLHC( double x, double open, double low, double high, double close )
		{
			this.open_ = open;
			this.close_ = close;
			this.low_ = low;
			this.high_ = high;
			this.SetY();
		}

		private void SetY()
		{
			this.x_ = this.close_;
		}

		public double Open
		{
			get
			{
				return open_;
			}
			set
			{
				open_ = value;
				this.SetY();
			}
		}
		private double open_;

		public double Close
		{
			get
			{
				return close_;
			}
			set
			{
				close_ = value;
				this.SetY();
			}
		}
		private double close_;

		public double Low
		{
			get
			{
				return low_;
			}
			set
			{
				low_ = value;
				this.SetY();
			}
		}
		private double low_;

		public double High
		{
			get
			{
				return high_;
			}
			set
			{
				high_ = value;
				this.SetY();
			}
		}
		private double high_;

	}
}
