#include "email.h"
#include <winsock2.h>
#include <ws2tcpip.h>
#include "thread.h"
#include <vector>
#include <string>
#include <process.h>
#include <iostream>

#define EMAIL_SERVER "mail:25"

struct EmailData
{
	std::vector<std::string> to;
	std::string message;
};

sockaddr_in AddrFromString( std::string str )
{
	sockaddr_in addr;
	memset(&addr, 0, sizeof(addr));

	if (str.empty())
		throw std::runtime_error("Empty address");
	std::string::size_type leftBracketPos = str.find('[');
	std::string::size_type rightBracketPos = str.find(']');
	/*switch (leftBracketPos)
	{
	case 0:
		// ipv6 style address string... we can't handle this yet
		// TODO: ipv6 support
	default:
		throw std::runtime_error( "Invalid address: " + str );
	case std::string::npos:
		if (rightBracketPos != std::string::npos)
			throw std::runtime_error( "Invalid address (contains ']'): " + str );
		break;
	}*/

	if(leftBracketPos == std::string::npos)
	{
		if (rightBracketPos != std::string::npos)
			throw std::runtime_error( "Invalid address (contains ']'): " + str );
	}
	else throw std::runtime_error( "Invalid address: " + str );

	std::string::size_type lastColonPos = str.find(':');
	std::string port;
	if (lastColonPos != std::string::npos && (lastColonPos > rightBracketPos || rightBracketPos == std::string::npos))
	{
		port = str.substr( lastColonPos+1 );
		str = str.substr( 0, lastColonPos );
	}
	// TODO: ipv6 stripping of []

	struct addrinfo * result = NULL;
	struct addrinfo hints;
	memset( &hints, 0, sizeof(hints) );
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	int err = getaddrinfo( str.c_str(), port.empty()? NULL : port.c_str(), &hints, &result );
	std::string errorMsg = "Unable to resolve address";
	if (!err)
	{
		for (struct addrinfo * p = result; p; p = p->ai_next)
		{
			switch (p->ai_addr->sa_family)
			{
			case AF_INET:
				{
					sockaddr_in * pAddr = (sockaddr_in *) p->ai_addr;
					addr = *pAddr;
					errorMsg = std::string();
				}
				break;

			default:
				errorMsg = "Unhandled address family in name lookup";
			}
		}
	}
	else
	{
		errorMsg = (char*) gai_strerror(err);
	}

	if (result)
		freeaddrinfo( result );

	if (!errorMsg.empty())
		throw std::runtime_error(errorMsg);

	return addr;
}

char GetCharFrom( SOCKET sock )
{
	while (true)
	{
		fd_set fds;
		FD_ZERO(&fds);
		FD_SET(sock, &fds);
		timeval timeout;
		timeout.tv_sec = 300;
		timeout.tv_usec = 0;
		// not portable to *nix
		int n = select(SOCKET(0), &fds, NULL, NULL, &timeout);
		switch (n)
		{
		case 0:
			throw std::runtime_error("Timeout on socket");
		case SOCKET_ERROR:
			throw std::runtime_error("Error waiting for read on socket");
		}
		char output;
		int r = recv( sock, (char*) &output, 1, 0 );
		if (r == SOCKET_ERROR)
		{
			if (WSAGetLastError() != WSAEWOULDBLOCK)
				continue;
			throw std::runtime_error("Error in WSARecv");
		}
		else if (r)
		{
			return output;
		}
		else
		{
			if (WSAGetLastError() != WSAEWOULDBLOCK)
				continue;
			throw std::runtime_error("No bytes received by recv");
		}
	}
}

std::string ReadResponse( SOCKET sock )
{
	std::string input;
	char c;
	do 
	{
		c = GetCharFrom(sock);
		input += c;
	} while (c != '\n');
	while (!input.empty() && (input[input.length()-1] == '\r' || input[input.length()-1] == '\n'))
		input.resize(input.length()-1);
	return input;
}

void CheckResponse( SOCKET sock )
{
	std::string response = ReadResponse(sock);

	if (response.length() < 3)
		throw std::runtime_error("Response too short: " + response);
	if (!isdigit(response[0]) || !isdigit(response[1]) || !isdigit(response[2]) || !isspace(response[3]))
		throw std::runtime_error("Response malformed: " + response);

	int code = (response[0] - '0')*100 + (response[1] - '0')*10 + (response[2] - '0');

	switch (code)
	{
	case 220:
	case 250:
	case 354:
		break;

	default:
		throw std::runtime_error("Bad response: " + response);
	}
}

void SendCommand( SOCKET sock, std::string request )
{
	request += "\r\n";
	send( sock, request.c_str(), request.length(), 0 );

	try
	{
		CheckResponse(sock);
	}
	catch (std::exception& e)
	{
		request.resize(request.length() - 2);
		throw std::runtime_error( e.what() + std::string("\nIn response to ") + request );
	}
}

void SendEmail( void * ptr )
{
	std::auto_ptr<EmailData> pEmail( static_cast<EmailData*>(ptr) );

	try
	{
		bool sockOk = false;
		SOCKET sock;
		for (int i=0; i<5; i++)
		{
			sock = socket( AF_INET, SOCK_STREAM, IPPROTO_TCP );
			if (sock != INVALID_SOCKET)
			{
				sockOk = true;
				break;
			}
			Sleep(1000);
		}
		if (!sockOk)
			throw std::runtime_error("Failed creating socket");

		try
		{
			bool ok = false;
			for (int i=0; i<5; i++)
			{
				sockaddr_in saddr = AddrFromString(EMAIL_SERVER);
				if (0 == connect( sock, (sockaddr*)&saddr, sizeof(saddr) ))
				{
					ok = true;
					break;
				}
				Sleep(1000);
			}
			if (!ok)
				throw std::runtime_error("Failed connecting to " + std::string(EMAIL_SERVER));

			SendCommand(sock, "HELO mail");
			for (std::vector<std::string>::const_iterator iterTo = pEmail->to.begin(); iterTo != pEmail->to.end(); ++iterTo)
			{
				SendCommand(sock, "MAIL FROM:<craig@crytek.de>");
				SendCommand(sock, "RCPT TO:<" + *iterTo + ">");
				SendCommand(sock, "DATA");
				std::string message = "Subject: Network Stream Analysis Notification\r\n\r\n" + pEmail->message;
				SendCommand(sock, message + "\r\n.");
			}
			SendCommand(sock, "QUIT");
		}
		catch (...)
		{
			closesocket( sock );
			throw;
		}
		closesocket( sock );
	}
	catch (std::exception& e)
	{
		SCOPED_GLOBAL_LOCK;
		std::cout << "Emailing exception: " << e.what() << std::endl;
	}
}

void Email( const std::string& message )
{
	EmailData * pEmail = new EmailData;

	pEmail->to.push_back( "craig" );
	pEmail->to.push_back( "marcio" );
	pEmail->to.push_back( "jan" );
	pEmail->message = message;

	_beginthread( SendEmail, 0, pEmail );
}
