/* 
	cache definitions and includes for SPU 4-way set associative software cache
*/

#ifndef __CACHE_DEFS_H
#define __CACHE_DEFS_H
#pragma once

#if defined(PS3)

#if defined(__SPU__)

#define PREFETCH		//if enabled, prefetching is performed
#define SUPP_ASYNC	//if enabled, asynchronous write backs for address ranges are supported

#if defined(SUPP_ASYNC)
//	#define PREF_ASYNC	//prefers asynchronous write backs in conditions
#endif

//enable if to expect more flushes without write backs
#define PREF_NO_WRITE_BACK

#if defined(SPU_CACHE_MISS_USE_ASM)
	//overwrite settings since it is always used in asm impl. of cache miss handler
	#if !defined(PREFETCH)
		#define PREFETCH
	#endif
	#if !defined(SUPP_ASYNC)
		#define SUPP_ASYNC
	#endif
	#undef NO_WRITE_BACK
#else
	//enable for debugging reason
	//#define NO_WRITE_BACK
#endif

#if !defined(SPU_CACHE_MISS_USE_ASM)
//	#define ENABLE_HAZARD_MODE	//switch on to perform check for cache hazards, also switches from asm to c version
#endif	//SPU_CACHE_MISS_USE_ASM
#endif//__SPU__

//since only one transfer is happening at a time -> use fixed tag IDs
#define CACHE_TAG_BASE_ID 0x1F
#define SetCacheTagID(set) CACHE_TAG_BASE_ID
#define SetCacheTagMask(set) 	(1 << SetCacheTagID(set))
#define GetPrefetchTagID(index) (CACHE_TAG_BASE_ID - index)

//keep shift, mask and size of cache line in sync
//do not change cache line size
#define scSPUCacheLineSize				128
#define scSPUCacheLineSizeShift		7
#define scSPUCacheLineSizeMask		(scSPUCacheLineSize-1)

//should remain fixed at 4 way set associative
//lookup is only implemented for 4 ways
#define scSPUCacheSetNumWays			4
#define scSPUCacheSetNumWaysMask	(scSPUCacheSetNumWays - 1)
#define scSPUCacheSetNumWaysShift	2

#define TOTAL_CACHE_SIZE(a) ((a<<1)+(a>>4))

//one cache line for temp storing, used across cache misses, do not use for other things
//overwrites initial boot loader and stack usage (not supposed to return anyway)
//do not change numbers, used in asm too
#define g_scWriteBackSavedArea	((vec_uint4*)(256 * 1024 - scSPUCacheLineSize))		//262016
#define g_scWriteBackArea				((vec_uint4*)(256 * 1024 - 2*scSPUCacheLineSize))	//261888
#define g_scWriteBackMask				((vec_uint4*)(256 * 1024 - 3*scSPUCacheLineSize))	//261760
#define g_scWriteBackMaskAtomic	((vec_uint4*)(256 * 1024 - 4*scSPUCacheLineSize)) //261632


#endif //PS3
#endif //__CACHE_DEFS_H
