#ifndef __SPU_DMAELEMENT_H
#define __SPU_DMAELEMENT_H
#pragma once

#if defined(PS3)
#if !defined(_SPU_JOB)

#if defined(__SPU__)
	#include "SPU.h"
#endif

namespace NSPU
{
	namespace NDriver
	{
		//DMA element info block for static variables (other memory goes through software cache)
		struct SDMAElement
		{
			//input PPU->SPU and output PPU<-SPU
			unsigned int addrEAMain;			//effective main memory address where memory gets transfered to or from
			unsigned int pointerOffsLS;	
			unsigned int pad0;						//make it a multiple of 16
			unsigned short size;					//size of transfer in bytes
			unsigned short pad1;

#if defined(__SPU__)
			//special version for SPU without return value and assumed 16 byte alignment -> copy vectors
			__attribute__((always_inline))
			inline void operator=(const SDMAElement& crFrom)
			{
				*(vec_uint4*)this = *(vector unsigned int*)&crFrom;
			}
#else
			__attribute__((always_inline))
			inline SDMAElement& operator=(const SDMAElement& crFrom)
			{
				addrEAMain		= crFrom.addrEAMain;
				pointerOffsLS = crFrom.pointerOffsLS;
				size					= crFrom.size;
				return *this;
			}
#endif
		} _ALIGN(16);
	}//NDriver
}//NSPU

#endif //_SPU_JOB	
#endif //PS3
#endif //__SPU_DMAELEMENT_H
