/*---------------Compilation test script for Ps3 and Xenon-------------------------*/


// Create Shell objects.
var WshShell = WScript.CreateObject("WScript.Shell");
var FSO = WScript.CreateObject("Scripting.FileSystemObject");

var ForReading = 1, ForWriting = 2, ForAppending = 8;
var TristateUseDefault = -2, TristateTrue = -1, TristateFalse = 0;

// Which Sever will be used for sending mails
var MailServer= "mail2.INTERN.CRYTEK.DE";

// Programms for compiling the Project
var BuildConsole = "\"C:\\Program Files\\Xoreax\\IncrediBuild\\BuildConsole.exe\""; 
var MsDevStudio = "\"C:\\Program Files\\Microsoft Visual Studio 8\\Common7\\Ide\\devenv.exe\"";

var BuildDrive = "E:\\";
var BuildFolder = BuildDrive + "Game02_Build";
var ProjectCppWorkspace = BuildFolder + "\\code\\Solutions\\CryEngine.sln";
var BinPS3Folder = BuildFolder + "\\BinPS3";
//var ProjectCppWorkspace = "D:/Perforce/depot/Main/Code/Solutions/CryEngine.sln";

var MakeWConf = "C:\\PS3_Compiling\\makewrapper.conf";

var CurDir = WshShell.CurrentDirectory;

var a_reciepent_ALL = new Array ( "Timur@crytek.de","FP_Build@crytek.de","MarcoK@Crytek.de");
var a_reciepent_PS3 = new Array ( "Michaelg@Crytek.de","saschad@Crytek.de");
var a_reciepent_XENON = new Array ( "Scott@Crytek.de");
var a_reciepent_ERROR = new Array ( "denis@crytek.de" );

var Compiling_Platform = "";
var Compile_PS3 = false;
var Compile_Xenon = false;
var BuildConfig_Xenon = "\"Profile Xenon|Win32\"";
var BuildConfig_PS3 = "\"Profile PS3|Win32\"";

var UseIncrediBuild = false;
var CppProject = "*";

var script_Log = CurDir+"/PS3_Xenon_Logs/PS3_Xenon_Compiling_Script.log" ;
var CppLog_Xenon = CurDir+"/PS3_Xenon_Logs/Xenon_compiling.log";
var CppLog_PS3 = CurDir+"/PS3_Xenon_Logs/PS3_compiling.log";
var a_Mailfiles_ALL = new Array( );
var a_Mailfiles_PS3 = new Array( CppLog_PS3  );
var a_Mailfiles_XENON = new Array(  CppLog_Xenon );
var a_Mailfiles_ERROR = new Array(  CurDir+"/PS3_Xenon_Logs/PS3_Xenon_Compiling_Script.log",CppLog_PS3,CppLog_Xenon );
var ps3Failed = false;
var xenonFailed = false;
var numFailedXENON = 0;
var numFailedPS3 = 0;
var messageALL = "";
var ERROR = false;



///////////////////////////////////////////////////////////////////////////////
// Functions.
///////////////////////////////////////////////////////////////////////////////


//+++++++++++++++++++++++++Compile Project using Incredebuild/MSDevStudio+++++++++++++++++++++++++
function CompileProject(  workspace,ProjectToCompile,config , CppLog )
{
	
	Log( "Compiling Solution: "+workspace+" In Configuration: "+config );
	var CmdLine;

	if (UseIncrediBuild)
	{
		CmdLine = BuildConsole + " "+workspace+" /Cfg=\"" + config + " Xenon\" /Prj="+ProjectToCompile+" /Rebuild /BrowseInfo=OFF /Log=" + "\"" + CppLog + "\""+ " /All /NoLink /Wait";
	}
	else
	{
		CmdLine = MsDevStudio + " " + workspace + " /rebuild " + config + " /out " + CppLog;
	}
	
	Result = WshShell.Run( CmdLine,1,true );
	if (Result != 0)
	{
		return false;
	}
	return true;
}

//+++++++++++++++++++++++++Copying folders and files with arguments+++++++++++++++++++++++++
function Copy(Source,Destination,Recrusive,KeepAttributes,CopyHiddenFiles,Exclude)
{
	var cmdLine = "xcopy ";
	cmdLine += Source + " " + Destination;
	cmdLine +=" /I /Y /C /R";
	if (Exclude != "") cmdLine +=" /exclude:"+Exclude;
	if (Recrusive) cmdLine +=" /E";
	if (KeepAttributes) cmdLine +=" /K";
	if (CopyHiddenFiles) cmdLine +=" /H";
	Log( "Start copying Folder "+Source+" to "+Destination);
	result = WshShell.Run( cmdLine,1,true );
	if(result != 0)
	{
		Log("Error: Copying couldn't be done correctly");
		return (false);
	}
	else
		return (true);
}

//+++++++++++++++++++++++++Function for sending mails+++++++++++++++++++++++++
function SendMail( recipient,msg,subject,attachmentsArray,importance )
{
	var cdoConfig = new ActiveXObject("CDO.Configuration");
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/sendusing") = 2; //cdoSendUsingPort
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpauthenticate") = 1; //cdoBasic
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpserver") = MailServer;
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpserverport") = 25;
	cdoConfig.Fields("http://schemas.microsoft.com/cdo/configuration/smtpconnectiontimeout") = 60;
	
	cdoConfig.Fields.Update();

	var cdoMessage = new ActiveXObject( "CDO.Message" );
	cdoMessage.Configuration = cdoConfig;

	cdoMessage.Subject = subject;
	cdoMessage.From = "Build@crytek.de";
	cdoMessage.To = recipient;
	cdoMessage.TextBody = msg;

	var i;
	for (i = 0; i < attachmentsArray.length; i++)
	{
		if (FSO.FileExists( attachmentsArray[i] ))
		{
			cdoMessage.AddAttachment( attachmentsArray[i] );
		}
	}

	cdoMessage.Send();
	cdoConfig = null;
	cdoMessage = null
}

//+++++++++++++++++++++++++Function for writing to the log+++++++++++++++++++++++++
function Log(str) 
{
	logFile.WriteLine( str );
	WScript.Echo(str);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////
// Main.
///////////////////////////////////////////////////////////////////////////////
try
{
// Trying to create a Subfolder named PS3_XENON_LOGS if not exists
if (FSO.FolderExists(CurDir+"\\PS3_Xenon_Logs") == false)
	{
		try
		{
			FSO.CreateFolder(CurDir+"\\PS3_Xenon_Logs");
		}
		catch(e)
		{
			WScript.Echo("Warning: "+CurDir+"\\PS3_Xenon_Logs"+e.description);
		}
	}

// Delete the script log 
if (FSO.FileExists( script_Log ))
{
	FSO.DeleteFile( script_Log );
}

// Create new script log 
logFile = FSO.CreateTextFile(script_Log,true );           
Log( "----------CompileScript for different Platforms---------\r\nComments and bugs to Denis@Crytek.de\r\n\r\n" );

Log("Deleting old compiling logs");
// Delete the old ps3 and xenon compiling logs
if (FSO.FileExists( CppLog_Xenon ))
{
	FSO.DeleteFile( CppLog_Xenon );
}
if (FSO.FileExists( CppLog_PS3 ))
{
	FSO.DeleteFile( CppLog_PS3 );
}

Log("Catching Name of the Platform to compile");
// Catch Name of the Platform to compile
if (WScript.Arguments.Named.Exists("Platform"))
{
	Compiling_Platform = WScript.Arguments.Named.Item("Platform");
	Compiling_Platform = Compiling_Platform.toLowerCase();
}

if(Compiling_Platform == "all")
{
	Compile_PS3 = true;
	Compile_Xenon = true;
}
else if(Compiling_Platform == "ps3")
{
	Compile_PS3 = true;
	Compile_Xenon = false;
}
else if(Compiling_Platform == "xenon")
{
	Compile_PS3 = false;
	Compile_Xenon = true;
}
else
{
	Log( "No valid Platform was selected. Please give a argument if starting this script e.g. <scriptname> /Platform:Xenon" );
	WScript.Quit(1);
}

Log("Starting Script.\r\nSelected Platform: "+Compiling_Platform);

if(Compile_Xenon)
{
	// Compile
	CompileProject( ProjectCppWorkspace,CppProject, BuildConfig_Xenon , CppLog_Xenon );
	// Check if file exists
	if(FSO.FileExists(CppLog_Xenon))
	{
		// Load the Log
		var loadedXenonLog = FSO.OpenTextFile( CppLog_Xenon, ForReading );
		// Check whether the file is empty
		if(!loadedXenonLog.AtEndOfStream)
		{
			var xenonLogOutput = loadedXenonLog.ReadAll();
			// Search the Log whether the compling had errors
			firstPos = xenonLogOutput.search("succeeded");
			lastPos =  xenonLogOutput.search("failed");
			// Check whether a normal compiling output was given or some other error happened
			if(firstPos!="-1" && lastPos!="-1")
			{
				// Set the pointers on the number of failed projects
				firstPos = firstPos + 11;
				lastPos = lastPos - 1;
				// Get the number of failed projects
				numFailedXENON = xenonLogOutput.slice(firstPos,lastPos);
				// if a project failed to compile send a mail
				if(numFailedXENON>=1)
				{
					xenonFailed = true;
				}
			}
			else
			{
				Log("Error: Compiling could not be started. Not found succeeded or failed into the logs ");
				xenonFailed = false;
				ERROR = true;
			}
			
			xenonLogOutput = null;
		}
		else
		{
			Log( "Error: File is empty " + a_Mailfiles_XENON);
			xenonFailed = false;
			ERROR = true;
		}
		
		loadedXenonLog.Close();
	}
	else
	{
		Log( "Error: File does not exist " + a_Mailfiles_XENON);
		xenonFailed = false;
		ERROR = true;
	}
}


if(Compile_PS3)
{
	Copy ( MakeWConf , BinPS3Folder , false , true , true , "" );
	// Compile
	CompileProject( ProjectCppWorkspace,CppProject, BuildConfig_PS3 , CppLog_PS3 );
	// Check if file exists
	if(FSO.FileExists(CppLog_PS3))
	{
		// Load the Log
		var loadedPS3Log = FSO.OpenTextFile( CppLog_PS3, ForReading );
		// Check whether the file is empty
		if(!loadedPS3Log.AtEndOfStream)
		{
			var ps3LogOutput = loadedPS3Log.ReadAll();
			// Search the Log whether the compling had errors
			firstPos = ps3LogOutput.search("succeeded");
			lastPos =  ps3LogOutput.search("failed");
			// Check whether a normal compiling output was given or some other error happend
			if(firstPos!="-1" && lastPos!="-1")
			{
				// Set the pointers on the number of failed projects
				firstPos = firstPos + 11;
				lastPos = lastPos - 1;
				// Get the number of failed projects
				numFailedPS3 = ps3LogOutput.slice(firstPos,lastPos);
				// if a project failed to compile send a mail
				if(numFailedPS3>=1)
				{
					ps3Failed = true;
				}
			}
			else
			{
				Log("Error: Compiling could not be started. Not found succeeded or failed into the logs ");
				ps3Failed = false;
				ERROR = true;
			}
			
			ps3LogOutput = null;
		}
		else
		{
			Log( "Error: File is empty " + a_Mailfiles_PS3 );
			ps3Failed = false;
			ERROR = true;
		}
		
		loadedPS3Log.Close();
	}
	else
	{
		Log( "Error: File does not exist " + a_Mailfiles_PS3 );
		ps3Failed = false;
		ERROR = true;
	}
}

if(xenonFailed==true)
{
	Log( "Sending Mail to "+a_reciepent_XENON+" With subject: Xenon compiling test" );
	SendMail( a_reciepent_XENON , numFailedXENON + " Projects failed during the compiling test" , "Xenon compiling test" , a_Mailfiles_XENON , 1 );
	a_Mailfiles_ALL[1] = CppLog_Xenon;
	messageALL = numFailedXENON + " Xenon Projects failed during the compiling test";
}

if(ps3Failed==true)
{
	Log( "Sending Mail to "+a_reciepent_PS3+" With subject: PS3 compiling test" );
	SendMail( a_reciepent_PS3 , numFailedPS3 + " Projects failed during the compiling test" , "PS3 compiling test" , a_Mailfiles_PS3 , 1 );
	a_Mailfiles_ALL[2] = CppLog_PS3;
	messageALL += "\n"+numFailedPS3 + " PS3 Projects failed during the compiling test";
}

if(ps3Failed==true || xenonFailed==true)
{
	Log( "Sending Mail to "+a_reciepent_ALL+" With subject: Compiling test" );
	logFile.Close();
	SendMail( a_reciepent_ALL , messageALL , "Compiling test" , a_Mailfiles_ALL , 1 );
}

if(ERROR==true)
SendMail( a_reciepent_ERROR , "ERROR while Compiling test" , "ERROR while Compiling test" , a_Mailfiles_ERROR , 1 );

	
}
catch(e)
{
	WScript.Echo("Error: "+e.description);
	LogFile = FSO.CreateTextFile(  CurDir + "/PS3_Xenon_Logs/PS3_Xenon_CompilingScript_ERROR.log",true );           
	LogFile.WriteLine("Error: "+e.description);
	WScript.Quit(1);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////