
#include "stdafx.h"
#include "PhotoBump10.h"
#include "PhotoBump10Doc.h"
#include "PhotoBump10View.h"
#include "Video.h"
#include "PhotoFrame.h"
#include "PhotoImage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////////
void CPhotoBump10Doc::Adjust3DPoints(CPhotoFrame *pFrame)
{
	CCamera *pCam=&pFrame->m_Camera;

	float fTotalError=0;
	// just to get the gl matrix back
	int w=pFrame->m_pImage->m_nWidth;
	int h=pFrame->m_pImage->m_nHeight;

	pCam->m_nViewport[0]=0;
	pCam->m_nViewport[1]=0;
	pCam->m_nViewport[2]=w;
	pCam->m_nViewport[3]=h;		
	m_pVideo->SetCamera(pCam,false,false);				
	for (lstPhotoVerticesIt i2=m_lstVertices.begin();i2!=m_lstVertices.end();i2++)
	{
		CPhotoVertex *pVert=(*i2);
		vector3f vRes;
		vector3f vNewPos;		

		m_pVideo->ProjectToScreen(pVert->m_vPos,vRes,pCam);
		float fX=pVert->m_X[pFrame->m_nFrameNum];
		float fY=pVert->m_Y[pFrame->m_nFrameNum];
		float fCurrError=sqrtf(sqr(vRes.x-fX)+sqr(vRes.y-fY));		

		for (int k=0;k<9*3;k++)
		{		
			vNewPos=pVert->m_vPos+m_vDirs[k];
			m_pVideo->ProjectToScreen(vNewPos,vRes,pCam);			
			float fError=sqrtf(sqr(vRes.x-fX)+sqr(vRes.y-fY));
			if (fError<fCurrError)
			{
				fCurrError=fError;
				pVert->m_vPos=vNewPos;				
			}
		} //k

		fTotalError+=fCurrError;			
	} //i

	pFrame->m_fCalibError=fTotalError;

}
