#pragma once

#include <vector>														// STL vector<>


#include "Cry_Math.h"												// Vec3





//////////////////////////////////////////////////////////////////////
class CPbTri
{
public:
	//! calculates the area of a 2D triangle
	//! /param pfX pointer to three x values
	//! /param pfY pointer to three y values
  static float	CalcArea											( float *pfX, float *pfY );

	//!
	void					DrawTriPointer								( int color, const bool inbConservative );

	// normalize normal after calling this function
	//! /param s x coordinate in the texture
	//! /param t y coordinate in the texture
	//! /param inbDoClipping do clipping within the triangle area
  void					CalcBarycentricCoordsFromUV		( float s, float t, Vec3 &point, Vec3 &normal,
																								Vec3 &outvTangent, Vec3 &outvBinormal, Vec3 &outvTNormal,
																								bool inbDoClipping );
	//! /param inbDoClipping do clipping within the triangle area
  void					CalcBarycentricCoordsFromPoint( const Vec3 &point, Vec3 &normal, bool inbDoClipping );

	//!
  bool					CalcIntersectionFromTo				( const Vec3 &invStart, const Vec3 &invEnd );

	//! /return FLT_MAX nothing was intersected
	float					CalcIntersectionFromDir				( const Vec3 &invStart, const Vec3 &invDir );

	//!
  static float	CalcTriArea										( const Vec3 &p0, const Vec3 &p1, const Vec3 &p2 );

	//! does the triangles share one or more vertices?
	bool					IsConnectedTo									( CPbTri& inTriangle );

	//! extend the given bounding box
	void					ExtendMinMax									( Vec3 &inoutMin, Vec3 &inoutMax );

	//!
	void					ExtendSphere									( Vec3 invMid, float &outfRadius2 );

	//! /param iniAxis
	DWORD					PlaneSplit										( int iniAxis, float value ); // returnwert:0=left,1=both,2=right

	//! return the Trueform/PN Triangle generated position (used for displacement mapping)
	//! /param inS 
	//! /param inT
	//! /param inbDoClipping 
	//! /param outPos
	//! /param outNormal
	//! /param inbQuadratic true=quadratic normal interpolation, linear otherwise
	void					CalcPNTriangleData						( float inS, float inT, bool inbDoClipping, Vec3 &outPos, Vec3 &outNormal, const bool inbQuadratic );

	//! calculates m_Plane,m_fArea3d and m_fArea
	void					RefreshInternals							( void );

	// *******************************************************************************

  Plane					m_Plane;							//!< plane of the triangle 
  Vec3					m_Verts[3];						//!< vertex positions
  Vec3					m_VertsNormal[3];			//!< vertex normals
	DWORD					m_iTriMaterialID;			//!< material id 0..

	Vec3					m_vTangent[3];				//!< used for tangent space bumpmapping
	Vec3					m_vBinormal[3];				//!< used for tangent space bumpmapping
	Vec3					m_vTNormal[3];				//!< used for tangent space bumpmapping

	float					m_fS[3];							//!< texture x=s coordinates
  float					m_fT[3];							//!< texture y=t coordinates

  float					m_fArea;							//!< area in texture-space
	float					m_fArea3d;						//!< area in world-space

	void					CalcBarycentrics							( float inS, float inT, float outCoor[3], bool inbDoClipping );
};



class CIntersInfo
{
public:
  Vec3			m_Point;				//!<
  float			m_fDist;				//!< from starting point
  CPbTri *	m_pTri;					//!< must not be 0
};



typedef std::vector<CIntersInfo>						CIntInfoList;
typedef std::vector<CIntersInfo>::iterator	CIntInfoIt;


