#pragma once

#include "SimpleIndexedMesh.h"												// CSimpleIndexedMesh
#include "Properties.h"																// CProperties
#include "PBCloneMap.h"																// CPBCloneMap

#include <string>																			// STL string

#include "RasterImageOutput.h"												// CRasterImageOutput


/*!
    \brief class used for storing all the relevant data for the normasl map generation (used by worker thread)
    \author Martin Mittring
    \version 1.0
    \date    2/22/2002
*/
class CPolyBumpWorkerThread
{
public:
	//! constructor
											CPolyBumpWorkerThread						( void );

	//! destructor
	virtual							~CPolyBumpWorkerThread					( void );

	//! get the low resolution mesh
	//! /return pointer to the low resolution mesh
 CSimpleIndexedMesh *	GetLowMesh											( void );

	//! get the high resolution mesh
	//! /return pointer to the high resolution mesh
 CSimpleIndexedMesh *	GetHighMesh											( void );
	
	//! this has to be called from time to time to show the user the current state and to process UI messages
	//! /return true/false: false means the user tries to stop the process with the UI
  //! /inszPassName pass name string
	//! /param iniPercent shows the user how much work is done so far (0..100)
	bool								ThreadPollMessages							( float infPercent, const char *inszPassName );

	//! Get the window handle of the process window
	//! /return window handle
	HWND								GetThreadderHWND								( void );

	//! Set the window handle of the process window
	//! /param inhWnd window handle
	void								SetThreadderHWND								( HWND inhWnd );

	//! set the handle to the kill event (this event is checked in ThreadPollMessages() from time to time)
	//! /param inlphHnd kill event
	void								SetKillEvent										( HANDLE *inlphHnd );

	//! load the optional bump TARGA (.TGA) filename
	//! /param inszPathName path and name as null terminated string
	void								LoadBumpMapPathName							( const char *inszPathName );

	//! return the derivate values from the bumpmap
	//! /param infX x coordinate in the texture from 0.0f to 1.0f
	//! /param infX y coordinate in the texture from 0.0f to 1.0f
	//! /param outfDX derivate in the x direction
	//! /param outfDY derivate in the y direction
	//! /return true/false: true=bumpmap was supplied
	bool								GetBumpMapDerivate							( float infX, float infY, float &outfDX, float &outfDY );

	//! extend an existing filename (with possible extension) with some data (percent, bumpstrength)
	std::string					ExtendFilename									( std::string insFilename );

	// Attributes *************************************************************************************

	//! set attribute
	void								SetStartTime										( DWORD indwStartTime );

	//! get attribute
	DWORD								GetStartTime										( void );
		

	// **************************************************************************************

	CProperties							m_Properties;						//!< properties chosen by the user at start time

	CRasterImageOutput			m_BitMapOutput;					//! file type for the output, sage interface for Maya and 3DSMax

	CPBCloneMap							m_CloneMap;							//!< used for clonemapping

	bool										m_bUserHasStopped;			//!< use has stopped the process

private:

	CSimpleIndexedMesh			m_LowMesh;							//!< low resolution mesh
	CSimpleIndexedMesh			m_HighMesh;							//!< high resolution mesh

	HWND										m_hThreadderWnd;				//!< handle to the progress window
	HANDLE *								m_lphKillReceiveEvent;	//!< pointer to the kill event from CPolyBumpPlugin
	DWORD	*									m_pBumpMapBuffer;				//!< Pointer to the bumpmap (RGBA), 0 means no bumpmapping
	DWORD										m_dwBumpmapWidth;				//!< width of the bumpmap
	DWORD										m_dwBumpmapHeight;			//!< height of the bumpmap
	DWORD										m_dwStartTime;					//!< for time calculations (in ms)
};


