
//////////////////////////////////////////////////////////////////////
//
//	Crytek SuperFramework Source code
//	
//	File:SphereHierarchy.h
//
//	History: 	
//  -July 16,2001: Created by Marco Corbetta
//
//////////////////////////////////////////////////////////////////////

#ifndef SPHERE_HIER_H
#define SPHERE_HIER_H

#if _MSC_VER > 1000
# pragma once
#endif

//////////////////////////////////////////////////////////////////////
class CintersInfo
{
public:
  Vec3d   m_Point;  
  float   m_fDist2;
  CPbTri  *m_pTri;  
};

//////////////////////////////////////////////////////////////////////
typedef std::vector<CintersInfo> CIntInfoList;
typedef std::vector<CintersInfo>::iterator CIntInfoIt;

//////////////////////////////////////////////////////////////////////
typedef std::list<CPbTri *> CPbTriList;
typedef std::list<CPbTri *>::iterator CPbTriIt;

class CPbMesh;
//////////////////////////////////////////////////////////////////////
class CSphereHier
{
public:
	//! constructor
											  CSphereHier									();    
	//! desstructor
											  ~CSphereHier								();    

  void									Build												( CPbMesh *mesh );
  void									CalcIntersectionRecursive		( const Vec3d &p1,const Vec3d &p2 );

	
	void									GetDistanceQuery						( const Vec3d p, const Vec3d normal, float &rad );


private:
  void									BuildRecursive							( CPbTriList &lsttri,
																											const Vec3d &mins,const Vec3d &maxs,
																											int mintris, int iniRecursions=9 );

	// ******************************************************
public:
  float									m_fRadius2;
  Vec3d									m_Center;
  CSphereHier *					m_pChildren[2];  
  CPbTriList						m_lstLeafTris;

  static int						m_nNumTests;					// for debug
  static CIntInfoList		m_lstIntersTris;

	static int						m_nProcessedTris;			// for UpdateProgress
	static int						m_nTriNumber;					// for UpdateProgress
};


#endif