////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   platform.h
//  Version:     v1.00
//  Created:     11/12/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: Platform dependend stuff.
//               Include this file instead of windows.h
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __platform_h__
#define __platform_h__
#pragma once

#if defined(WIN32) && !defined(WIN64)
#define _CPU_X86
// Insert your headers here
#include <windows.h>
#include <Win32specific.h>

#define RC_EXECUTABLE "rc.exe"
#endif

#if defined(WIN64)
#define _CPU_AMD64
// Insert your headers here
#include <windows.h>
#include <Win64specific.h>  

#define RC_EXECUTABLE "rc64.exe"
#endif

#include "stdio.h"

//////////////////////////////////////////////////////////////////////////
// Use our own memory manager.
// No Any STL includes must be before this line.
//////////////////////////////////////////////////////////////////////////
#ifndef NOT_USE_CRY_MEMORY_MANAGER
#define USE_NEWPOOL
#include <CryMemoryManager.h>
#endif // NOT_USE_CRY_MEMORY_MANAGER

#ifdef __cplusplus
// define the standard string
#include <string>
#if defined(WIN64)// && defined(_DLL)
namespace cry_std
{
	template<typename T>
	class char_traits: public ::std::char_traits<T>
	{};
	// to avoid importing the string
	template <typename T>
	class string: public ::std::basic_string<T,char_traits<T> >
	{
	public:
		typedef ::std::basic_string<T,char_traits<T> > Base;
		string(){}
		string (const Base& s): Base(s.c_str()) {} 
		string (const string& s): Base(s.c_str()) {} 
		string (const T p): Base(p){}
		string (const T* p): Base(p){}
		//string (const_iterator itBegin, const_iterator itEnd): Base(itBegin, itEnd) {}
		string (const T* p, size_t n) : Base(p, n){}
		string (const T* p, const T* q): Base (p, q-p) {}
    string (const Base& s, size_t pos, size_t sz): Base(s,pos,sz) {}
		string& operator = (const Base& s)
		{
		// in Amd64 platform, the STL has reference-counted string
		// because of this, before self-assignment through a pointer,
		// the string gets destructed, which renders the pointer hanging.
		// to correct this, we avoid self-assignment through pointer
		if (s.c_str() != c_str())
			assign(s.c_str());
		return *this;
		}
		string& operator = (const T* p)
		{
		// in Amd64 platform, the STL has reference-counted string
		// because of this, before self-assignment through a pointer,
		// the string gets destructed, which renders the pointer hanging.
		// to correct this, we avoid self-assignment through pointer
		if (p != c_str())
			assign(p);
		return *this;
		}
		string& operator = (const string& s)
		{
		// in Amd64 platform, the STL has reference-counted string
		// because of this, before self-assignment through a pointer,
		// the string gets destructed, which renders the pointer hanging.
		// to correct this, we avoid self-assignment through pointer
		if (s.c_str() != c_str())
			assign (s.c_str());
		return *this;
		}
		void push_back(T c) {(*this) += c;}
		void clear() {resize(0);}

		string& operator += (const Base& s) {append(s);return *this;}
		string& operator += (T c) {append(1,c); return *this;}
		string& operator += (const T* p) {append(p);return *this;}
	};
	template <typename T> string<T> operator + (const string<T>& left, const string<T>& right) {return string<T>(left)+=right;} 
	template <typename T> string<T> operator + (const typename string<T>::Base& left, const string<T>& right) {return string<T>(left)+=right;} 
	template <typename T> string<T> operator + (const string<T>& left, const typename string<T>::Base& right) {return string<T>(left)+=right;} 
	template <typename T> string<T> operator + (const T* left, const string<T>& right) {return string<T>(left)+=right;} 
	template <typename T> string<T> operator + (const string<T>& left, const T* right) {return string<T>(left)+=right;} 
	template <typename T> string<T> operator + (const T left, const string<T>& right) {return string<T>(left)+=right;} 
	template <typename T> string<T> operator + (const string<T>& left, const T right) {return string<T>(left)+=right;} 
}

typedef cry_std::string<char>//std::basic_string<char, cry_std::char_traits<char>, std::allocator<char> >
	string;
typedef cry_std::string<wchar_t>//std::basic_string<wchar_t, cry_std::char_traits<wchar_t>, std::allocator<wchar_t> >
	wstring;

#else	// defined(WIN64)
typedef std::string string;
typedef std::wstring wstring;
#endif // defined(WIN64)
#endif // __cplusplus

#ifdef _XBOX
#define _CPU_X86
#include <xtl.h>
#include "XBoxSpecific.h"
#endif


// 32/64 Bit versions.
#define SIGN_MASK(x) ((intptr_t)(x) >> ((sizeof(size_t)*8)-1))

#ifdef WIN32
typedef signed char         s8;
typedef signed short        s16;
typedef signed long         s32;
typedef signed __int64			s64;
typedef unsigned char				u8;
typedef unsigned short			u16;
typedef unsigned long				u32;
typedef unsigned __int64		u64;

typedef volatile u8         vu8;
typedef volatile u16        vu16;
typedef volatile u32        vu32;
typedef volatile u64        vu64;
typedef volatile s8         vs8;
typedef volatile s16        vs16;
typedef volatile s32        vs32;
typedef volatile s64        vs64;

typedef float               f32;
typedef double              f64;
typedef volatile f32        vf32;
typedef volatile f64        vf64;
#endif




#ifdef GAMECUBE
typedef signed char         s8;
typedef signed short        s16;
typedef signed long         s32;
typedef signed long long		s64;
typedef unsigned char				u8;
typedef unsigned short			u16;
typedef unsigned long				u32;
typedef unsigned long long	u64;

typedef volatile u8         vu8;
typedef volatile u16        vu16;
typedef volatile u32        vu32;
typedef volatile u64        vu64;
typedef volatile s8         vs8;
typedef volatile s16        vs16;
typedef volatile s32        vs32;
typedef volatile s64        vs64;

typedef float               f32;
typedef double              f64;
typedef volatile f32        vf32;
typedef volatile f64        vf64;

#endif



#ifdef PS2
typedef signed char         s8;
typedef signed short        s16;
typedef signed int          s32;
typedef signed long	        s64;
typedef unsigned char		u8;
typedef unsigned short		u16;
typedef unsigned int		u32;
typedef unsigned long    	u64;

typedef volatile u8         vu8;
typedef volatile u16        vu16;
typedef volatile u32        vu32;
typedef volatile u64        vu64;
typedef volatile s8         vs8;
typedef volatile s16        vs16;
typedef volatile s32        vs32;
typedef volatile s64        vs64;

typedef float               f32;
typedef double              f64;
typedef volatile f32        vf32;
typedef volatile f64        vf64;

#endif




#endif // __platform_h__
