// PolyBumpApplicationView.cpp : implementation of the CPolyBumpApplicationView class
//

#include "stdafx.h"
#include "PolyBumpApplication.h"

#include "PolyBumpApplicationDoc.h"
#include "PolyBumpApplicationView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CPolyBumpApplicationView

IMPLEMENT_DYNCREATE(CPolyBumpApplicationView, CView)

BEGIN_MESSAGE_MAP(CPolyBumpApplicationView, CView)
END_MESSAGE_MAP()

// CPolyBumpApplicationView construction/destruction

CPolyBumpApplicationView::CPolyBumpApplicationView()
{
}

CPolyBumpApplicationView::~CPolyBumpApplicationView()
{
}


BOOL CPolyBumpApplicationView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}



DWORD Vec3ToColor( const Vec3 &v )
{
	DWORD r = (DWORD)(v.x*127.5+128.0f);
	DWORD g = (DWORD)(v.y*127.5+128.0f);
	DWORD b = (DWORD)(v.z*127.5+128.0f);
 
	return (r<<16) | (g<<8) | b;
}


void AddLine( CDC *pDC, uint32 &dwLineY, const int iLineCY, const char *szLine )
{
	pDC->TextOut(0,dwLineY,szLine,(int)strlen(szLine));

	dwLineY += iLineCY;
}


// CPolyBumpApplicationView drawing
void CPolyBumpApplicationView::OnDraw( CDC *pDC )
{
	CPolyBumpApplicationDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc)
		return;

	uint32 dwLineY=0;

	CSRFData *pSRFData = pDoc->m_WorkerThreadData.GetSRFData();

	if(!pSRFData)
	{
		pDC->TextOut(0,dwLineY,"Calculation in progress ...");
		return;				// is processing
	}

	{
		uint32 dwWidth=pSRFData->GetWidth(),dwHeight=pSRFData->GetHeight();
		uint32 dwPreviewSize = 128;			// should be power of two
		uint32 dwStep = max((uint32)1,max(dwWidth,dwHeight)/dwPreviewSize);

		dwWidth/=dwStep;dwHeight/=dwStep;

		for(uint32 dwY=0;dwY<dwHeight;++dwY)
		for(uint32 dwX=0;dwX<dwWidth;++dwX)
		{
			uint32 dwXS=dwX*dwStep, dwYS=dwY*dwStep;
/*
			{
				uint16 id = pSRFData->GetLowPolyTriangleId(dwXS,dwYS);

				pDC->SetPixel(dwX,dwHeight-dwY,id);
			}
*/
			{
				Vec3 vNormal = pSRFData->GetWorldHighPolyNormal(dwXS,dwYS);

				pDC->SetPixel(dwX,dwHeight-dwY,Vec3ToColor(vNormal));
			}
		}

		dwLineY+=dwHeight+2;
	}


	int iLineCY = pDC->GetTextExtent("My",2).cy;

	for(uint32 dwI=0;;++dwI)
	{
		const char *szLine = pSRFData->GetInfoString(dwI);			if(!szLine)break;

		AddLine(pDC,dwLineY,iLineCY,szLine);
	}

	uint32 dwComputationTime = (pDoc->m_WorkerThreadData.GetComputationTime()+999)/1000;

	if(dwComputationTime)
	{
		AddLine(pDC,dwLineY,iLineCY,"");

		{
			char str[256];

			sprintf(str,"ComputationTime: %d min %d sec",dwComputationTime/60,dwComputationTime%60);
			AddLine(pDC,dwLineY,iLineCY,str);
		}
	}
}




// CPolyBumpApplicationView diagnostics

#ifdef _DEBUG
void CPolyBumpApplicationView::AssertValid() const
{
	CView::AssertValid();
}

void CPolyBumpApplicationView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CPolyBumpApplicationDoc* CPolyBumpApplicationView::GetDocument() const // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPolyBumpApplicationDoc)));
	return (CPolyBumpApplicationDoc*)m_pDocument;
}
#endif //_DEBUG


// CPolyBumpApplicationView message handlers
