// Copyright: (c) by Crytek GmbH
#pragma once

#include "3DObject.h"												// C3DObject
#include "3DLight.h"												// C3DLight

#include <vector>														// STL vector<>
using namespace std;												// STL

// you can have multive scenes in one application

class C3DScene
{
public:

	//! constructor
	C3DScene();

	//! destructor
	virtual ~C3DScene();

	//! render all objects in the scene
	//! /param inpDevice interface pointer to the D3DDevice
	void Render( C3DRenderer &inRenderer );

	//! load .OBJ and add to scene
	//! /param inszFileName filename with path to the OBJ file (.MTL is searched in the same directory)
	//! /param inpDevice interface pointer to the D3DDevice
	//! /param inbObjectSpace true=bumpmap is in object space, false= in tangent space
	//! /return 0=failed, otherwise the pointer to the object is returned
	C3DObject *LoadOBJAndAdd( C3DRenderer &inRenderer, const char *inszFileName, bool inbObjectSpace );

	//!
	C3DLight *AddLight();

	//! get the bounding box O(n) n=objects in scene (could be used to find the midpoint)
	//! no objects -> BBox( (0,0,0)-(0,0,0) )
	//! /param outMin minimum values for each axis
	//! /param outMax maximum values for each axis
	//! /return true=succes, false=there is no object
	bool GetBoundingBox( D3DXVECTOR3 &outvMin, D3DXVECTOR3 &outvMax ) const;

	//!
	void FreeObjects();

	//!
	void FreeLights();

	//!
	//! /return return the pointer to the indwNo-th lighsource, 0 otherwise
	C3DLight *GetLightNo( DWORD indwNo );

	//!
	void GetStats( DWORD &outdwFaces, DWORD &outdwVertices );

	// attributes ********************************************************************

	//! get attribute
	D3DXCOLOR GetAmbientColor();

	//! set attribute
	void SetAmbientColor( D3DXCOLOR inAmbientColor );

private:

	vector<C3DObject *>			m_Objects;				//!< all scene objects
	vector<C3DLight *>			m_Lights;					//!< all light emitting objects
	D3DXCOLOR								m_AmbientColor;		//!< ambient color

	DWORD										m_dwFaces;				//!< for statistics
	DWORD										m_dwVertices;			//!< for statistics
};
