// Copyright: (c) by Crytek GmbH
#include "stdafx.h"														// for precompiled headers (has to be in first place)
#include <Windowsx.h>													// GET_X_PARAM() GET_Y_PARAM()
#include <assert.h>														// assert()
#include "stdio.h"														// sprintf()
#include "Error.h"														// Error, Message
#include "resource.h"													// resources
#include "3DRenderer.h"												// C3DRenderer
#include "ProcessorClock.h"										// CProcessorClock
#include "3DApplication.h"										// CApplication




void UpdateMenuState( HWND inHwnd, C3DApplication *inpApplication )
{
	HMENU hMenu=GetMenu(inHwnd);

	{
		bool bValue=inpApplication->GetSecondViewOnOff();
		CheckMenuItem(hMenu,ID_VIEW_SECNVIEWON,MF_BYCOMMAND|(bValue?MF_CHECKED:MF_UNCHECKED));
	}

	{
		bool bValue=inpApplication->GetForceDirLights();
		CheckMenuItem(hMenu,ID_FORCEDIRLIGHTS,MF_BYCOMMAND|(bValue?MF_CHECKED:MF_UNCHECKED));
	}

	{
		bool bValue=inpApplication->GetTriBaseVectorDisplay();
		CheckMenuItem(hMenu,ID_VIEW_SHOWTRIBASEVECTORS,MF_BYCOMMAND|(bValue?MF_CHECKED:MF_UNCHECKED));
	}

	{
		bool bValue=inpApplication->GetVertexBaseVectorDisplay();
		CheckMenuItem(hMenu,ID_VIEW_SHOWVERTEXBASEVECTORS,MF_BYCOMMAND|(bValue?MF_CHECKED:MF_UNCHECKED));
	}

	{
		bool bValue=inpApplication->GetNormalVectorDisplay();
		CheckMenuItem(hMenu,ID_VIEW_SHOWNORMALVECTORS,MF_BYCOMMAND|(bValue?MF_CHECKED:MF_UNCHECKED));
	}
}





LRESULT CALLBACK MsgProc( HWND hwnd,      // handle to window
													UINT uMsg,      // message identifier
													WPARAM wParam,  // first message parameter
													LPARAM lParam ) // second message parameter
{
	C3DApplication *application=(C3DApplication *)GetWindowLong(hwnd,GWL_USERDATA);

	switch(uMsg)
  {
    case WM_DESTROY:
      PostQuitMessage(0);
      return 0;

		case WM_WINDOWPOSCHANGING:																							// minimum size
			{
				WINDOWPOS *lPos=(WINDOWPOS *)lParam;

				if(lPos->cx<320)lPos->cx=320;
				if(lPos->cy<240)lPos->cy=240;
			}
			return(0);

		case WM_SIZE:
			{
					assert(application);			if(!application)return(FALSE);

					application->m_Renderer.Resize3DEnvironment();
					InvalidateRect(application->m_Renderer.GetWindowHWND(),0,false);
					UpdateWindow(application->m_Renderer.GetWindowHWND());
			}
      break;

		case WM_LBUTTONDOWN:
		case WM_RBUTTONDOWN:
		case WM_MBUTTONDOWN:
			{
				assert(application);			if(!application)return(FALSE);

				application->m_RelMouse.OnButtonDown(hwnd);	
			}
			break;

		case WM_LBUTTONUP:
		case WM_RBUTTONUP:
		case WM_MBUTTONUP:
			{
				assert(application);			if(!application)return(FALSE);

				if(wParam==0)
					application->m_RelMouse.OnButtonUp();	
			}
			break;

		case WM_MOUSEMOVE:
			{
				assert(application);			if(!application)return(FALSE);

				int relX,relY;
				bool bButtonDown=(wParam&MK_LBUTTON)!=0 || (wParam&MK_MBUTTON)!=0 || (wParam&MK_RBUTTON)!=0;
				
				application->m_RelMouse.OnMouseMove(hwnd,bButtonDown,relX,relY);	
				application->MouseMessage(wParam,relX,relY,0);
			}
			break;

		case WM_MOUSEWHEEL:
			{
				assert(application);			if(!application)return(FALSE);
				
				int zDelta = GET_WHEEL_DELTA_WPARAM(wParam);

				application->MouseMessage(0,0,0,-zDelta);
			}
			break;

		case WM_PAINT:
			{
				assert(application);			if(!application)return(FALSE);

				application->Render();
	      ValidateRect(hwnd,NULL);
			}
      return 0;

		case WM_COMMAND:
			assert(application);			if(!application)return(FALSE);
			switch(LOWORD(wParam))
			{
				case ID_FILE_QUIT:
					DestroyWindow(hwnd);
					break;
				case IDD_INPUTDATA:
					application->Command_InputData();
					break;
				case ID_VIEW_CENTER:
					application->Command_ViewCenter();
					break;
				case ID_LIGHT_RESETLIGHTING:
					application->Command_ResetLighting();
					break;
				case ID_VIEW_CYCLERENDERMODEINFIRSTVIEW:						// F2
					application->Command_CycleRendermode(0,true);
					break;
				case ID_VIEW_CYCLERENDERMODEINSECONDVIEW:						// F3
					application->Command_CycleRendermode(1,true);
					break;
				case ID_VIEW_CYCLERENDERMODEINFIRSTVIEW2:						// shift F2
					application->Command_CycleRendermode(0,false);
					break;
				case ID_VIEW_CYCLERENDERMODEINSECONDVIEW2:					// shift F3
					application->Command_CycleRendermode(1,false);
					break;
				case ID_VIEW_CYCLERENDERMODEINBOTHVIEW:							// F4
					application->Command_CycleRendermode(2,true);
					break;
				case ID_SCALEDEBUGPLUS:
					application->Command_ChangeDebugScale(0.1f);
					break;
				case ID_SCALEDEBUGMINUS:
					application->Command_ChangeDebugScale(-0.1f);
					break;
				case ID_VIEW_CYCLERENDERMODEINBOTHVIEW2:						// shift F4
					application->Command_CycleRendermode(2,false);
					break;
				case ID_VIEW_SECNVIEWON:
					application->SetSecondViewOnOff(!application->GetSecondViewOnOff());
					UpdateMenuState(hwnd,application);
					break;
				case ID_LIGHT_AMBIENTCOLOR:
					application->Command_ChooseAmbientColor();
					break;
				case ID_LIGHT_COLOR:
					application->Command_ChooseMainLightColor();
					break;
				case ID_BACKLIGHT_COLOR:
					application->Command_ChooseBackLightColor();
					break;
				case ID_FORCEDIRLIGHTS:
					application->SetForceDirLights(!application->GetForceDirLights());
					UpdateMenuState(hwnd,application);
					break;
				case ID_HELP_ABOUT:
					application->Command_AboutBox();
					break;
				case ID_VIEW_SHOWVERTEXBASEVECTORS:
					application->SetVertexBaseVectorDisplay(!application->GetVertexBaseVectorDisplay());
					UpdateMenuState(hwnd,application);
					break;
				case ID_VIEW_SHOWTRIBASEVECTORS:
					application->SetTriBaseVectorDisplay(!application->GetTriBaseVectorDisplay());
					UpdateMenuState(hwnd,application);
					break;
				case ID_VIEW_SHOWNORMALVECTORS:
					application->SetNormalVectorDisplay(!application->GetNormalVectorDisplay());
					UpdateMenuState(hwnd,application);
					break;
			}
			return 0;		// message was processed
  }

  return(DefWindowProc(hwnd,uMsg,wParam,lParam));
}





// main function
int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow )
{
	HWND hWnd=0;																																	// window 

	HCURSOR hCursor=LoadCursor(hInstance,MAKEINTRESOURCE(IDC_POINTER));						// cursor
	HMENU hMenu=LoadMenu(hInstance,MAKEINTRESOURCE(IDR_APPMENU));									// menu
	HICON hIcon=LoadIcon(hInstance,MAKEINTRESOURCE(IDI_APPICON));									// icon

	// Register the window class.
  WNDCLASSEX wc = { sizeof(WNDCLASSEX), CS_CLASSDC, MsgProc, 0L, 4,							// 4 Bytes extra for storing
                    GetModuleHandle(NULL), NULL, hCursor, NULL, NULL,						//   the C3DRenderer pointer
                    "PolyBump Previewer by Crytek", hIcon };
  RegisterClassEx( &wc );


	HWND hDesk=GetDesktopWindow();
	RECT size;

	GetWindowRect(hDesk,&size);

	if(!MyProcessorClock.Init())return(false);

	C3DApplication Application;

  // Create the application's window.
  hWnd = CreateWindow( "PolyBump Previewer by Crytek", "PolyBump Previewer by Crytek", 
                       WS_OVERLAPPEDWINDOW,																			// sizable window
											 size.left+100,size.top+100,
											 size.right-size.left-200,size.bottom-size.top-200,
	                     GetDesktopWindow(), hMenu, wc.hInstance, NULL );

	// store the renderer pointer for the message loop
	SetWindowLong(hWnd,GWL_USERDATA,(LONG)(&Application));				

	UpdateMenuState(hWnd,&Application);

	if(Application.Init(hWnd,hInstance,lpCmdLine))
	{
		while(!Application.IsAppQuiting())
			Application.RunMessageLoop();
	}

	Application.DeInit();

	return 0;
}


