// Copyright: (c) by Crytek GmbH
#if !defined(AFX_PROCESSORCLOCK_H__36C3223F_1CA8_44B3_B82F_2AFE1B892F7A__INCLUDED_)
#define AFX_PROCESSORCLOCK_H__36C3223F_1CA8_44B3_B82F_2AFE1B892F7A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <windows.h>
#include <winnt.h>
// erst ab Pentium funktionsfhig

class CProcessorClock  
{
public:

	//! constructor
	CProcessorClock();

	//! destructor
	virtual ~CProcessorClock();

	//! Init (set time=0)
	//! \return true=success, false=failed(no CPU with PerformanceCounter)
	bool Init();

	//! get ms value
	DWORD GetActualTime();		

	//! get 1/100 ms value
	DWORD GetActualTimem100();		

	//! get time in the internal precicion (use with GetDifference100() )
	LARGE_INTEGER GetActualTimeAccurate();

	//! (CurrentTime - )/m_PerformanceFrequency
	//! \return difference time in 1/100 ms (minimum=1)
	DWORD GetDifference100( LARGE_INTEGER inSavedTime );

private:

	LARGE_INTEGER				m_PerformanceFrequency;					//!< CPU ticks per second
	LARGE_INTEGER				m_PerformanceLevelStart;				//!< CPU start time
};



extern CProcessorClock MyProcessorClock;

#endif // !defined(AFX_PROCESSORCLOCK_H__36C3223F_1CA8_44B3_B82F_2AFE1B892F7A__INCLUDED_)
