#include "stdafx.h"														// for precompiled headers (has to be in first place)
#include <assert.h>														// assert()
#include "3DMaterial.h"												// C3DMaterial,POLYBUMPVERTEX
#include "3DTools.h"													// PI



// outVertices[indwCount*2+2]
void Build3DCone( POLYBUMPVERTEX *outVertices, DWORD indwCount, float infR1, float infR2,
									D3DXVECTOR3 invPos1, D3DXVECTOR3 invPos2 )
{
	float step=(float)(2*PI/(float)(indwCount));

	// 
	D3DXVECTOR3 vDir=invPos2-invPos1;
	D3DXVECTOR3 vBase1;
	D3DXVECTOR3 vBase2;

	D3DXVec3Normalize(&vDir,&vDir);
	GetOtherBaseVec(vDir,vBase2,vBase1);

	for(float wi=0.0;wi<2*PI+step*0.5;wi+=step)
	{
		float x1=sinf(wi)*infR1;
		float y1=cosf(wi)*infR1;
		float x2=sinf(wi)*infR2;
		float y2=cosf(wi)*infR2;

		D3DXVECTOR3 vPos1=invPos1+vBase1*x1+vBase2*y1;
		D3DXVECTOR3 vPos2=invPos2+vBase1*x2+vBase2*y2;

		outVertices->pos=vPos1;outVertices++;
		outVertices->pos=vPos2;outVertices++;
	}
}



// /param invDirection has to be normalized
// /param outvA
// /param outvB
void GetOtherBaseVec( const D3DXVECTOR3 &invDirection, D3DXVECTOR3 &outvA, D3DXVECTOR3 &outvB )
{
	if(invDirection[2]<-0.5f || invDirection[2]>0.5f)
	{
		outvA[0]=invDirection[2];
		outvA[1]=invDirection[1];
		outvA[2]=-invDirection[0];
	}
	else
	{
		outvA[0]=invDirection[1];
		outvA[1]=-invDirection[0];
		outvA[2]=invDirection[2];
	}
	D3DXVec3Cross(&outvB,&invDirection,&outvA);
	D3DXVec3Cross(&outvA,&invDirection,&outvB);
}



float CalcAngle( const D3DXVECTOR3 &invA, const D3DXVECTOR3 &invB )
{
	double LengthQ=D3DXVec3Length(&invA)*D3DXVec3Length(&invB);

	if(LengthQ<0.01)LengthQ=0.01;

	return((float)(acos(D3DXVec3Dot(&invA,&invB)/LengthQ)));
}