//
// This file is part of PolyBump(tm) Previewer
//
// (C) Crytek
//

vs.1.0


// V_POSITION			v0
// V_NORMAL				v1				// unused
// V_TEXTURE			v3
// V_U					v4
// V_V					v5
// V_N					v6

// CV_ZERO				c0				// unused
// CV_ONE				c1				// unused
// CV_WORLDVIEWPROJ_0	c2,c3,c4,c5		//
// CV_WORLDVIEW			c6,c7,c8,c9		//
// CV_WORLD				c13,c14,c15,c16	//
// CV_HALF				c18				//
// CV_LIGHT_DIRECTION	c21				//
// CV_LIGHT_POSITION	c22				// unused
// CV_MATERIALPROP		c23				//
// CV_EYE_POS_WORLD		c24				// unused
// CV_DIFFLIGHTCOLOR	c25				// premultiplied with material diffuse color
// CV_SPECLIGHTCOLOR	c26				// premultiplied with material specular color
// CV_LIGHT_DIRECTION	c27				// unused, eye direction
// CV_AMBIENTLIGHTCOLOR	c28				// premultiplied with material ambient color
// CV_SUBSLIGHTCOLOR	c29				// premultiplied with material subsurface color

// S_WORLD				r0
// T_WORLD				r1
// SxT_WORLD			r2
// LIGHT_LOCAL			r3
// VERTEX_WORLD			r4
// EYE_VECTOR			r5
// HALF_ANGLE			r7



; Transform position to clip space and output it
dp4 oPos.x, v0, c2
dp4 oPos.y, v0, c3
dp4 oPos.z, v0, c4
dp4 oPos.w, v0, c5


// fake subsurface scattering into ambient
dp3 r1, v1 , c21    // perform lighting N dot L calculation in world space      
mad r1, c18,r1,c18	// -1..1 -> 0..1
mul r1,r1.rrrr,c29	// *subsurface color
mul r1,c18.rrrr,r1	// *0.5
add oD0,r1,c28


; Transform basis vectors to world space (only neccessary if world is transformed)
dp3 r0.x, v4, c13			// U
dp3 r0.y, v4, c14
dp3 r0.z, v4, c15

dp3 r1.x, v5, c13			// V
dp3 r1.y, v5, c14
dp3 r1.z, v5, c15

dp3 r2.x, v6, c13			// N
dp3 r2.y, v6, c14
dp3 r2.z, v6, c15





; transform light by basis vectors to put it
; into texture space
dp3 r3.x, r0.xyz, c21			// light direction
dp3 r3.y, r1.xyz, c21
dp3 r3.z, r2.xyz, c21


; Normalize the light vector
dp3 r3.w, r3, r3
rsq r3.w, r3.w
mul r3, r3, r3.w





// light direction is fixed for the calculation because we have a directional light
mov r5,-c27





// Add them to average & create half angle vector
add r7,  c21, r5


;  Normalize it
dp3 r7.w, r7, r7
rsq r7.w, r7.w
mul r7,   r7, r7.w

/////////////////////////////////////////////////
; Transform half angle vector to local space and
;  output to tex coord set 3 for specular calc

// Write result to a temporary r2 and use 1 extra
//  instruction for the mov so that we can output
//  it to diffuse color also.  Normaly, you should
//  write the result directly to oTn and save yourself
//  the mov instruction

dp3 oT3.x, r7, r0
dp3 oT3.y, r7, r1
dp3 oT3.z, r7, r2
mov oT3.w, c1

/////////////////////////////////////
// move light vector to TC 2


mov oT2, r3
mov oT2.w, c1.w		// w to 0



; output texture coords (normalmap and decalmap)
mov oT0, v3
mov oT1, v3
