////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   convertcontext.h
//  Version:     v1.00
//  Created:     4/11/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __convertcontext_h__
#define __convertcontext_h__
#pragma once

#include "PathUtil.h"

struct IResourceCompiler;
struct IConfig;
struct IRCLog;
struct ICfgFile;

//! Section in rc.ini file for common settings.
#define COMMON_SECTION "Common"

// [MichaelS] Moved this into convert context from ResourceCompiler so that it can be threadsafe.
// Stats are gathered in a vector per thread and then collated at the end.
class CFileStats
{
public:
	uint32				m_SrcFileSizeKB;	//!< in KB
	uint32				m_DstFileSizeKB;	//!< in KB
	string				m_sInfo;					//!< \t seperated list of properties (used for excel export)
	string				m_sDestFilename;	//!<
	string				m_sPreset;				//!<
};

/** Enumeration of supported platforms.
*/
enum Platform
{
	PLATFORM_UNKNOWN,	//!< Unknown platform.
	PLATFORM_PC,
	PLATFORM_XBOX,
	PLATFORM_PS2,
	PLATFORM_GAMECUBE,

	// This entry must be last in Platform enum.
	PLATFORM_LAST,
};

struct IConfig;

/** ConvertContext is a description of what should be processed by convertor.
*/
struct ConvertContext
{
	// this string must be prepended to all paths (it's with the trailing slash)
	CString masterFolder;

	//! Source file that needs to be converted. (name on the disk - might be different from final e.g. "~temp123.tmp")
	CString sourceFileIntermediate;
	//! Source file that needs to be converted. (final name of file - e.g. "dirt.tif")
	CString sourceFileFinal;
	// Source file extension (use this if you need the extension, the sourceFile might not have the right extension e.g. .tmp)
	// is always lower case (e.g. ".tif")
	CString sourceFileFinalExtension;
	//! Output file that would be created from sourceFile. (relative or absolute)
	CString outputFile;

	// Returns
	//   the file with path you should read from
	CString getSourcePath() {return masterFolder + Path::Make(sourceFolder,sourceFileIntermediate);}
	CString getOutputPath() {return masterFolder + Path::Make(m_sOutputFolder,outputFile);}

	// Returns
	//   path to the resource compiler exe including path e.g.  "c:\temp\bin32\rc\"
	CString getCompilerFolderPath() const
	{
		char szRCPath[1000];

		if (GetModuleFileName (NULL, szRCPath, sizeof(szRCPath)))
			return Path::GetPath(szRCPath);

		assert(0);
		return "";
	}

	//! Source file folder, so that the source file can be opened regardless whether the 
	//! path is given in sourceFile or not
	CString sourceFolder;

	//! Pointer to resource compiler interface.
	IResourceCompiler *pRC;
	//! Configuration settings for this file.
	IConfig *config;
	//! Returns the log to put the messages during conversion to:
	//! use Log(), LogWarning() and LogError()
	IRCLog *pLog;

	//! Dont log much info into log.
	bool bQuiet;

	//! file specific config file, must not be 0 (if there was no file, a empty instance with the right filename is created)
	ICfgFile *pFileSpecificConfig;

	//! presets config (for use with the image compiler)
	ICfgFile *presets;

	//! Platform to which file must be processed.
	Platform platform;

	//! e.g. "PC", "XBOX"
	CString plattformName;

//private: // --------------------------------------------------------------------------------------------

	int													threads;											// Number of threads 
	CString											m_sFileFolder;								// relative folder where the file is located, relative to source folder e.g. "Textures\Animals\Pets\"
	CString											m_sOutputFolder;							// Output folder
	std::vector<CFileStats> *		fileStats;										//
};

#endif // __convertcontext_h__