#pragma once

#include <d3d9.h>
#include <d3dx9.h>
#include <dxerr9.h>
#include "IConvertor.h"							// IConvertor
#include "ImageCompiler.h"
#include "TextureFallbackSystem.h"

class CImageConvertor : public IConvertor
{
public:

	//! constructor
	CImageConvertor();
	//! destructor
	~CImageConvertor();

	// interface IConvertor ----------------------------------------------------

	virtual void Release();
	virtual void Init(IConfig* config, IRCLog* log, const char* exePath);
	virtual void DeInit();
	virtual ICompiler* CreateCompiler();
	virtual bool SupportsMultithreading() const;
	virtual int GetNumPlatforms() const;
	virtual Platform GetPlatform( int index ) const;
	virtual int GetNumExt() const;
	virtual const char* GetExt( int index ) const;
	virtual DWORD GetTimestamp() const;

	// -------------------------------------------------------------------------

private:
	CTextureFallbackSystem m_TextureFallbackSystem;
	bool m_bInitialized;
};
