// ResourceCompilerImage.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include <assert.h>
#include "ResourceCompilerImage.h"
#include "IResCompiler.h"
#include "ImageConvertor.h"							// CImageConvertor
#include "SRFCompiler.h"								// CSRFCompiler

HMODULE g_hInst;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		g_hInst = (HMODULE)hModule;
		break;
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
    return TRUE;
}


// This is an example of an exported function.
void __stdcall RegisterConvertors( IResourceCompiler *pRC )
{
	// image formats
	{
		CImageConvertor *pImageConv=new CImageConvertor();

		pRC->RegisterConvertor(pImageConv);

		pRC->RegisterKey("userdialog","0/1 to show the userdialog for the ResourceCompilerImage");
		pRC->RegisterKey("preset","e.g. \"NormalmapHigh\" to overwrite the preset");
		pRC->RegisterKey("reduce","0=non /1=half resolution /2=quarter resolution");
		pRC->RegisterKey("fallback","TextureFallbackFile.dat is updated with down sampled versions");
		pRC->RegisterKey("userdialogcustom","0/1=enabled additional user controls");
		pRC->RegisterKey("mipmaps","0/1");
		pRC->RegisterKey("mipgamma","1=on(better for diffuse textures) or 0=off(for non RGB textures)");
		pRC->RegisterKey("mipnormalize","0/1=useful for normalmaps");
		pRC->RegisterKey("pixelformat","e.g. 3DC, DXT1, X8R8G8B8");
		pRC->RegisterKey("bumpblur","");
		pRC->RegisterKey("bumptype","");
		pRC->RegisterKey("bumpstrength","");
		pRC->RegisterKey("globalcompressor","0=DirectX(default), 1=NVDXTLib, 2=ATI, 3=TIF");
		pRC->RegisterKey("globalmipblur","default blur is is 2 (->4x4 kernel)");
		pRC->RegisterKey("globalgamma","linear math requires monitor gamma (default 2.2)");
		pRC->RegisterKey("autooptimize","0/1=automatic adjusting to reasonable settings");
		pRC->RegisterKey("ser","0/1=supress reduce resolution during loading, 0(default)");
		pRC->RegisterKey("dns","0/1=do not stream this texture, 0(default)");
		pRC->RegisterKey("autooptimizefile","0/1=auto optimize for this file, 1(default)");
		pRC->RegisterKey("minalpha","0..255 to limit alpha value, (can prevent NAN in shader)");
		pRC->RegisterKey("powof2","1=texture needs to be power of 2 in width and height, 0 otherwise");
		pRC->RegisterKey("detectL8","if R=G=B and no alpha then use L8 (luminance)");
		pRC->RegisterKey("mc","maintain alpha coverage in mipmaps (experimental)");
		pRC->RegisterKey("ms","0=no sharpening .. 100=full sharpening");
		pRC->RegisterKey("M0","adjust mipalpha, 0..50=normal..100");
		pRC->RegisterKey("M1","adjust mipalpha, 0..50=normal..100");
		pRC->RegisterKey("M2","adjust mipalpha, 0..50=normal..100");
		pRC->RegisterKey("M3","adjust mipalpha, 0..50=normal..100");
		pRC->RegisterKey("M4","adjust mipalpha, 0..50=normal..100");
		pRC->RegisterKey("M5","adjust mipalpha, 0..50=normal..100");
		pRC->RegisterKey("nooutput","supress output");
		pRC->RegisterKey("M","compact version of M0,M1,...");
		pRC->RegisterKey("overwritefilename","overwrite given input filename (destination not affected)");
		pRC->RegisterKey("overwriteextension","overwrite the file extension");
		pRC->RegisterKey("globalreduce","[0..[ to remove the top mipmap levels");
		pRC->RegisterKey("bumptype_a","0=none, 1=Gauss, 2=GaussAlpha");
		pRC->RegisterKey("bumpstrength_a","-1000.0 .. 1000.0");
		pRC->RegisterKey("bumpblur_a","0 .. 10.0");
		pRC->RegisterKey("ext_tif","ignore tif files");	
		pRC->RegisterKey("copy_tif","copy tif files");	
		pRC->RegisterKey("ext_dds","ignore dds files");	
		pRC->RegisterKey("copy_dds","copy dds files");	
		pRC->RegisterKey("imgflags","flags propagated to engine (binary number 1=cubemap, 2=volume, 4=decal)");	
		pRC->RegisterKey("targetroot_low","optional path to a reduced copy of the destination image");
		pRC->RegisterKey("colormodel","0=rgb (default), 1=cie");
		pRC->RegisterKey("filesingle","0=off(default), 1=on, add hint to the file if there are no additional files e.g. DDNDIF");	// useful for the build process only 
	}

	// SRF format
	{
		CSRFCompiler *pSRFComp=new CSRFCompiler();

		pRC->RegisterConvertor(pSRFComp);
//		pRC->RegisterKey();
	}
}

#undef DEFINE_GUID
#define DEFINE_GUID(name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8) \
	EXTERN_C const GUID DECLSPEC_SELECTANY name \
	= { l, w1, w2, { b1, b2,  b3,  b4,  b5,  b6,  b7,  b8 } }
DEFINE_GUID(IID_IDirect3DTexture9, 0x85c31227, 0x3de5, 0x4f00, 0x9b, 0x3a, 0xf1, 0x1a, 0xc3, 0x8c, 0x18, 0xb5);
