#ifndef __SRFPROPERTIES_H
#define __SRFPROPERTIES_H

#pragma once

// should match the order in the dialog
enum EUsedSpaceType
{
	EUST_Object,
	EUST_Tangent,
};

// should match the order in the dialog
enum ENormalOutputType
{
	ENOT_R8G8B8,
	ENOT_R8G8,
};



// should match the order in the dialog
enum EDisplaceOutputType
{
	EDOT_None,
	EDOT_LinearSigned,
};

#include "ImageProperties.h"				// CBumpProperties


class CSRFProperties :public CBumpProperties
{
public:

	//
	CSRFProperties()
	{		
		m_bUserDialog=false;
		SetToDefault();
	}

	void SetToDefault()
	{
		m_OccmapBrightenup=0.0f;
		m_eUsedSpaceType=EUST_Tangent;
		m_eNormalOutputType=ENOT_R8G8B8;
		m_bOutputAccess=false;
		m_bOutputUnoccAreaDir=false;
		m_bOutputHorizonMap=false;
		m_eDisplaceOutputType=EDOT_None;
		m_iReduceResolutionFile=0;
		m_dwExpandBorder=16;

		CBumpProperties::SetToDefault();
	}

	// config properties
	bool								m_bUserDialog;						// show the user dialog for interactive tweaking

	EUsedSpaceType			m_eUsedSpaceType;					//
	ENormalOutputType		m_eNormalOutputType;			//
	bool								m_bOutputAccess;					//
	bool								m_bOutputUnoccAreaDir;		//
	bool								m_bOutputHorizonMap;			//
	EDisplaceOutputType m_eDisplaceOutputType;		//
	float								m_OccmapBrightenup;				// 0..100 in percent
	int									m_iReduceResolutionFile;	// -2..3 to remove the top mipmap levels
	DWORD								m_dwExpandBorder;					// [0..[ to remove avoid problems in lower mipmaps
};

#endif // __SRFPROPERTIES_H