////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2001-2006.
// -------------------------------------------------------------------------
//  File name:   AnimationInfoLoader.h
//  Version:     v1.00
//  Created:     22/6/2006 by Alexey Medvedev.
//  Compilers:   Visual Studio.NET 2005
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef _ANIMATION_INFO_LOADER
#define _ANIMATION_INFO_LOADER

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class ICryXML;

class IAnimationLoaderListener
{
public:
	enum MessageType
	{
		MESSAGE_INFO,
		MESSAGE_WARNING,
		MESSAGE_ERROR
	};
	virtual void OnAnimationLoaderMessage(MessageType type, const char* szMessage) = 0;
};

enum EMoveDirection
{
	EMD_Ignore,
	eMD_Forward,
	eMD_Back,
	eMD_Right,
	eMD_Left
};


// Obsolete 
//enum EDirection 
//{
//	ED_Ignore,
//	ED_Identity,
//	ED_L90,
//	ED_R90,
//	ED_180
//};

inline void FixString(std::string& str)
{
	std::transform(str.begin(),str.end(),str.begin(),tolower);	
	std::replace(str.begin(),str.end(), '\\','/' );	
}

// Compression parameters for individual bone
struct CompressionPreset
{
	std::string m_Name;

	struct BonePreset
	{
		float m_fRotError;
		float m_fPosError;
		uint8 m_RotCompressionFormat;
		uint8 m_PosCompressionFormat;
	};

	typedef std::map<uint32,BonePreset> TBoneInfoMap;
	TBoneInfoMap m_BoneInfoMap;

	const BonePreset * FindBonePreset(uint32  bone)
	{
		TBoneInfoMap::iterator it = m_BoneInfoMap.find(bone);
		if (it != m_BoneInfoMap.end())
		{
			return &(it->second);
		}

		return 0;
	}
};

struct SDirection 
{
	float m_fTime;
	float m_fDirection;
	SDirection() : m_fTime(0.0f), m_fDirection(0.0f) {};
	SDirection(float time, float direction) : m_fTime(time), m_fDirection(direction) {};
};

// Processing & compression parametrs for single animation
struct SAnimationDesc //: public CNameCRCHelper
{
	int	m_CompressionQuality;
	int m_FootPlant;
	int m_Human;
	int m_Hunter;
	int m_FixedToFoots;
	int m_DeleteRotController;
	int m_DeletePosController;
	int m_Weapon;
	int m_SkipSaveToDatabase;
	int m_ReverseDirection;
	int m_RootToHeels;
	EMoveDirection m_MoveDirection;
	//EDirection m_Direction;
	//float m_fDirection;
	std::vector<SDirection> m_Directions;
	CompressionPreset m_Preset;
	float m_fRootQuality;
	float m_fFloorDist;
	float m_fSpeedXY;


	float m_RotatePosRoot, m_RotateQuatRoot , m_RotatePosChild, m_RotateQuatChild; 

	void SetAnimationName(std::string name)
	{
		m_AnimationName = name;
		FixString(m_AnimationName);
	}


	SAnimationDesc() :  m_CompressionQuality(0), m_FootPlant(0), m_MoveDirection(EMD_Ignore)/*, m_fDirection(-1.0f)*/, m_Human(0), m_FixedToFoots(0), m_DeleteRotController(1), m_DeletePosController(1), m_Hunter(0),
											m_RotatePosRoot(0.0f), m_RotateQuatRoot(0.0f), m_RotatePosChild(0.0f), m_RotateQuatChild(0.0f), m_Weapon(0), m_SkipSaveToDatabase(0),m_ReverseDirection(0), m_RootToHeels(0),
											m_fRootQuality(1.0f), m_fFloorDist(0.03f), m_fSpeedXY(0.005f)

	{

	};

	const std::string& GetAnimationName() const { return m_AnimationName;};
private:
	std::string m_AnimationName;


};

// Container of parameters for animations for reference model
struct SAnimationDefinition 
{
	std::string m_Model;
	std::string m_DBName;	
	

	SAnimationDesc m_MainDesc;

	std::vector<SAnimationDesc> m_OverrideAnimations;
	const SAnimationDesc& GetAnimationDesc(const std::string& name ) const;

	void SetAnimationPath(std::string& name)
	{
		m_AnimationPath = name;
		FixString(m_AnimationPath);
		m_AnimationPathWithoutSlash = m_AnimationPath;


		while (m_AnimationPathWithoutSlash[m_AnimationPathWithoutSlash.length() - 1] == '/')
		{
			m_AnimationPathWithoutSlash.erase(m_AnimationPathWithoutSlash.length() - 1, 1);
		}

	}

	bool FindIdentical(const std::string& name, bool checkLen = false );
	const std::string& GetAnimationPath() const { return m_AnimationPath; };
	const std::string& GetAnimationPathWithoutSlash() const { return m_AnimationPathWithoutSlash; };

private:

	std::string m_AnimationPath;
	std::string m_AnimationPathWithoutSlash;

};


// Helper class for loading & parsing parameters from .cba file
class CAnimationInfoLoader
{
public:
	CAnimationInfoLoader(ICryXML *pXML);
	~CAnimationInfoLoader(void);


	bool LoadDescription(const std::string& name, IAnimationLoaderListener * pListener);
	const SAnimationDefinition * GetAnimationDefinition(const std::string& name ) const;

	std::vector<SAnimationDefinition> m_Definitions;
private:
	ICryXML	* m_pXML;
};


void ReportWarning(IAnimationLoaderListener* pListener, const char* szFormat, ...);
void ReportInfo(IAnimationLoaderListener* pListener, const char* szFormat, ...);
void ReportError(IAnimationLoaderListener* pListener, const char* szFormat, ...);

#endif