////////////////////////////////////////////////////////////////////////////
//
// Crytek Engine Source File.
// Copyright (C), Crytek Studios, 2001-2006.
// -------------------------------------------------------------------------
// File name: AnimationInfoLoader.h
// Version: v1.00
// Created: 22/6/2006 by Alexey Medvedev.
// Compilers: Visual Studio.NET 2005
// Description:
// -------------------------------------------------------------------------
// History:
//
////////////////////////////////////////////////////////////////////////////
#ifndef _ANIMATION_LOADER
#define _ANIMATION_LOADER

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include "NameCRCHelper.h"
#include "Controller.h"
#include "AnimationInfoLoader.h"
#include "IXMLSerializer.h"
#include "CGF\CGFLoader.h"
#include "CGF\CGFSaver.h"
#include "CGF\LoaderCAF.h"
#include "ControllerPQLog.h"
#include "ControllerTCB.h"
#include "ControllerPQ.h"
#include "SkeletonInfo.h"
#include "CGFContent.h"
#include "ConvertContext.h"
#include "CryVersion.h"
#include "CompressionController.h"
#include "Ticks.h"


#define IDENTITY (-gf_PI/2)

#define R90  (IDENTITY-gf_PI/2)
#define R180 (IDENTITY-gf_PI-0.001f)

#define L90  (IDENTITY+gf_PI/2)
#define L180 (IDENTITY+gf_PI-0.001f)


#define ABS_R90  (-gf_PI/2)
#define ABS_R180 (-gf_PI-0.001f)

#define ABS_L90  (+gf_PI/2)
#define ABS_L180 (+gf_PI-0.001f)

struct SFootPlant
{
	f32 m_LHeelStart,m_LHeelEnd;
	f32 m_LToe0Start,m_LToe0End;
	f32 m_RHeelStart,m_RHeelEnd;
	f32 m_RToe0Start,m_RToe0End;

	SFootPlant()
	{
		m_LHeelStart=-10000.0f; m_LHeelEnd=-10000.0f;
		m_LToe0Start=-10000.0f; m_LToe0End=-10000.0f;
		m_RHeelStart=-10000.0f; m_RHeelEnd=-10000.0f;
		m_RToe0Start=-10000.0f; m_RToe0End=-10000.0f;
	};

};

ILINE SFootPlant operator * (const SFootPlant& fp, f32 t)
{
	SFootPlant rfp;
	rfp.m_LHeelStart=fp.m_LHeelStart*t; rfp.m_LHeelEnd=fp.m_LHeelEnd*t;
	rfp.m_LToe0Start=fp.m_LToe0Start*t; rfp.m_LToe0End=fp.m_LToe0End*t;
	rfp.m_RHeelStart=fp.m_RHeelStart*t; rfp.m_RHeelEnd=fp.m_RHeelEnd*t;
	rfp.m_RToe0Start=fp.m_RToe0Start*t; rfp.m_RToe0End=fp.m_RToe0End*t;
	return rfp;
}

//vector self-addition
ILINE void operator += (SFootPlant& v0, const SFootPlant& v1)
{
	v0.m_LHeelStart+=v1.m_LHeelStart; v0.m_LHeelEnd+=v1.m_LHeelEnd;
	v0.m_LToe0Start+=v1.m_LToe0Start; v0.m_LToe0End+=v1.m_LToe0End;
	v0.m_RHeelStart+=v1.m_RHeelStart; v0.m_RHeelEnd+=v1.m_RHeelEnd;
	v0.m_RToe0Start+=v1.m_RToe0Start; v0.m_RToe0End+=v1.m_RToe0End;
}

struct AnimEvents
{
	f32 m_time; //percentage value
	string m_strEventName;
	string m_strSoundName;
	string m_strBoneName;
};

struct BSAnimation
{
	Vec3 m_Position;
	string m_strAnimName;
};

struct ColorRGB{ uint8 r,g,b; };

// the flags used in the nFlags member
enum CA_AssetFlags
{
	// if this is true, then the asset has valid info data (has been loaded at least once)
	CA_ASSET_LOADED = 0x001,
	// if this is true, then its possible to use this asset with the loop-flag
	CA_ASSET_CYCLE = 0x002,
	// if this is true, this is a special cycle animation (loop-flag is also set)
	CA_ASSET_IDLECYCLE = 0x004,
	// if this is true, then the asset is a locomotion group
	CA_ASSET_LMG = 0x008,
	// if this is true, then the asset has been processed at loading time
	CA_ASSET_LMG_VALID = 0x010,
	// if this is true, then the asset has been processed at loading time
	CA_ASSET_PROCESSED = 0x020
};


typedef std::vector<IController_AutoPtr> TControllersVector;

class GlobalAnimationHeader: public CNameCRCHelper
{
public:
	GlobalAnimationHeader ()
	{
		// m_nRefCount = 0;
		m_nFlags = 0;
		m_fSecsPerTick = 0.000208f;
		m_nTicksPerFrame = 160;

		m_nStartKey = -1;
		m_nEndKey = -1;
		m_fStartSec = -1; // Start time in seconds.
		m_fEndSec = -1; // End time in seconds.

		m_fScale = 0.01f;
		m_fDistance = -1.0f;
		m_fSpeed = -1.0f;
		m_fSlope = 0.0f;
		m_fSlopeDiffZ = 0.0f;
		m_MoveDirection = Vec3(0,-1,0);
		m_StartPosition.SetIdentity();// = Vec3(ZERO);
		m_nBlendCodeLMG = 0;
		m_bDeleteControllers = false;

	}

	virtual ~GlobalAnimationHeader()
	{
	};

	const char * GetPathName() const { return GetName(); };
	const string& GetPathNameString()const { return GetNameString(); };

	void SetPathName(const string& name){ SetName(name); };

	size_t sizeofThis () const;

	std::string m_NameForSave;

	//---------------------------------------------------------------
	IController* GetController(uint32 nControllerID);

	f32 m_fScale;
	// the flags (see the enum in the top of the declaration)
	uint32 m_nFlags;

	Vec3 m_MoveDirection; //the initial moving direction of this motion
//	Vec3 m_StartPos;
//	Quat m_StartQuat;
	QuatT m_StartPosition;


	// timing data, retrieved from the timing_chunk_desc
	int32 m_nTicksPerFrame;
	f32 m_fSecsPerTick;
	int32 m_nStartKey;
	int32 m_nEndKey;
	f32 m_fStartSec; //Start time in seconds.
	f32 m_fEndSec; //End time in seconds.
	f32 m_fDistance; //the absolute distance this objects is moving
	f32 m_fSpeed; //speed (meters in second)
	f32 m_fSlope; //uphill-downhill measured in degrees
	f32 m_fSlopeDiffZ; //the height-difference between first and last frame

	SFootPlant m_FootPlantVectors;
	std::vector<uint8> m_FootPlantBits;

	std::vector<AnimEvents> m_AnimEvents;

	std::vector<CControllerInfo> m_arrControlerInfo;
	DynArray<string> m_arrBoneNameTable;	//names of bones

	// controllers comprising the animation; within the animation, they're sorted by ids
	TControllersVector m_arrController;

	uint32 m_nBlendCodeLMG;
	std::vector<BSAnimation> m_arrBSAnimations;

	//FIXME!
	bool m_bDeleteControllers;

	ILINE uint32 IsAssetLoaded() const {return m_nFlags&CA_ASSET_LOADED;}
	ILINE void OnAssetLoaded(){m_nFlags |= CA_ASSET_LOADED;}

	ILINE uint32 IsAssetCycle() const {return m_nFlags&CA_ASSET_CYCLE;}
	ILINE void OnAssetCycle(){m_nFlags |= CA_ASSET_CYCLE;}
	ILINE void OnAssetNoCycle(){m_nFlags &= ~CA_ASSET_CYCLE;}

	ILINE uint32 IsAssetIdleCyclical() const {return m_nFlags&CA_ASSET_IDLECYCLE;}
	ILINE void OnAssetIdleCyclical(){m_nFlags |= CA_ASSET_IDLECYCLE;}

	ILINE uint32 IsAssetLMG() const {return m_nFlags&CA_ASSET_LMG;}
	ILINE void OnAssetLMG(){m_nFlags |= CA_ASSET_LMG;}

	ILINE uint32 IsAssetLMGValid()const { return m_nFlags&CA_ASSET_LMG_VALID; }
	ILINE void OnAssetLMGValid(){ m_nFlags |= CA_ASSET_LMG_VALID; }

	ILINE uint32 IsAssetProcessed()const { return m_nFlags&CA_ASSET_PROCESSED; }
	ILINE void OnAssetProcessed(){ m_nFlags |= CA_ASSET_PROCESSED; }

};


struct DebugJoint
{
	DebugJoint()
	{
		m_idxParent = -1;
		m_RelativeQuat.SetIdentity();
		m_AbsoluteQuat.SetIdentity();
	}

	int16 m_idxParent; //index of the parent-joint
	QuatT m_RelativeQuat; //current relative rotation and position of animation
	QuatT m_AbsoluteQuat;
};


class ILoaderCGFListener;
class CSkeletonInfo;
struct ConvertContext;
class CContentCGF;
class CTrackStorage;

class CAnimation
{
public:
	CAnimation(CSkeletonInfo * pInfo);
	~CAnimation(void);

	enum EDeleteMethod { eAll, eOld, eNew, eSkipDelete};

	bool CheckLoco(std::string& str);

	bool LoadAnimationFromFile(const char * name, const char * savename, ILoaderCGFListener * pListener, SAnimationDesc& animDesc, bool bUseGLobal, bool bNeedCalculate);
	uint32 SaveAnimationToFile(const char * name, ILoaderCGFListener * pListener, const ConvertContext &cc, bool bSaveInfo);

	bool ProcessAnimation(ILoaderCGFListener * pListener, CTrackStorage * pStorage, bool bNeedCalculate, bool bUpdate);

	void SaveToDB(CTrackStorage * pStorage, bool bUpdate);

	void MakeCompression(uint32 numBones, float coeff, CompressionInfo &compInfo, CCompressonator &compController, uint32 format, uint32 footskel)
	{
		CreateLoopError(numBones, coeff, compInfo, format, footskel);

		compController.CreateCompression(m_GlobalAnimationHeader, m_CompressedAnimation,  compInfo, m_pInfo, m_AnimDesc, GAID);//, m_pInfo);
	}

	void CreateLoopError(uint32 numBones, float coeff, CompressionInfo &compInfo, uint32 format, uint32 footskel)
	{
		compInfo.m_Info.clear();

		compInfo.m_Info.resize(numBones);

		for (uint32 i=0; i<numBones; i++)
		{
			CompressionLevelInfo info;
			info.boneLevel = 0; //not used yet
			info.m_bPosCompression = eCompression;//eCompression;
			info.m_bRotCompression = eCompression;// eCompression;
			info.m_bSclCompression = eNoCompression;

			info.m_PositionError = 0.00000001f * coeff;
			info.m_RotationError = 0.00000001f * coeff;

			info.m_ScaleFormat = eNoCompressVec3;
			info.m_PositionFormat = eNoCompressVec3;
			info.m_RotationFormat = format;//eSmallTree64BitExtQuat;//eSmallTree64BitQuat;//eNoCompressQuat;
			info.m_DeletePos = m_AnimDesc.m_DeletePosController;
			info.m_DeleteRot = m_AnimDesc.m_DeleteRotController;

			compInfo.m_Info[i] = info;

		}

	}

	void MakeErrors(uint32 numBones, CompressionInfo &compInfo, int16 master, int16 footskel, SAnimationDesc * pDesc, CSkeletonInfo * pSkeleton, int weapon_bone);

	void DefaultError(int16 master, CompressionInfo & compInfo, uint32 bone, int16 footskel)
	{

		CompressionLevelInfo info;
		info.boneLevel = 0; //not used yet
		info.m_bPosCompression = eCompression;//eCompression;
		info.m_bRotCompression = eCompression;// eCompression;
		info.m_bSclCompression = eNoCompression;
		info.m_DeletePos = m_AnimDesc.m_DeletePosController;
		info.m_DeleteRot = m_AnimDesc.m_DeleteRotController;
		info.m_ScaleFormat = eNoCompressVec3;
		info.m_PositionFormat = eNoCompressVec3;

		if (master == -1)
		{
			info.m_PositionError = 0.00000001f * (float)m_AnimDesc.m_CompressionQuality;
			info.m_RotationError = 0.00000001f* (float)m_AnimDesc.m_CompressionQuality;
			info.m_RotationFormat = /*eSmallTree64BitExtQuat;//*/eAutomaticQuat;//eSmallTree64BitQuat;//eNoCompressQuat;
		}
		else
		{
			// after increasing precision 64Bit we can use this errors
			info.m_PositionError = 0.000000001f * (float)m_AnimDesc.m_CompressionQuality;
			info.m_RotationError = 0.000000001f * (float)m_AnimDesc.m_CompressionQuality;
			info.m_RotationFormat = eSmallTree64BitExtQuat;//eSmallTree64BitQuat;//eNoCompressQuat;
		}

		if ((bone == 0 ) && footskel)
		{
			if (m_AnimDesc.m_fRootQuality == 0.0f)
			{
				info.m_bPosCompression = eNoCompression;//eCompression;
				info.m_bRotCompression = eNoCompression;// eCompression;
			}
			else
				info.m_PositionError = 0.005f * (float)m_AnimDesc.m_CompressionQuality;
//			info.m_bPosCompression = eUseOld;
	//		info.m_bRotCompression = eUseOld;
		}

		compInfo.m_Info.push_back(info);

	}
	void DeleteOldChunk(EDeleteMethod delFlag, bool bEraseAnotherChunks);

	bool HasNewFormat();

	bool HasOldFormat() const
	{
		return m_bOldFormat;
	}

	bool HasTCBFormat() const
	{
		return m_bTCBFormat;
	}


private:

	//Vec3 GetPosition(IController * pController, float )
	bool CompareKeyTimes(KeyTimesInformationPtr& ptr1, KeyTimesInformationPtr& ptr2);
	void DetectCycleAnimations(ILoaderCGFListener * pListener);//uint32 AnimID);
	void EvaluateSpeed(ILoaderCGFListener * pListener);//uint32 AnimID);
	void BigFuckingArrow(int lheel_idx, int rheel_idx, bool bRootToHeels, bool bCheckLocoStuff = false, bool bUseLoco = true);

	void CreateNewController(std::vector<int>& arrFullTimes, std::vector<PQLog>& arrFullQTKeys, int numController, float fRotErr = 0.000000001f, float fPosErr = 0.000000001f );

	void SetFootplantBitsAutomatically( std::vector< std::vector<DebugJoint> >& arrSkeletons, int32 nAnimID,int32 nGlobalAnimID,int32 lHidx,int32 rHidx,int32 lTidx,int32 rTidx,int32 lNidx,int32 rNidx, const SAnimationDesc& desc );
	void CreateSkeletonArray( std::vector< std::vector<DebugJoint> >& arrSkeletons, GlobalAnimationHeader& header );
	void SetFootplantVectors( std::vector< std::vector<DebugJoint> >& arrSkeletons, uint32 nAnimID, SFootPlant& rFootPlants, uint32 nGlobalAnimID );


	int  SaveControllers(CSaverCGF& saver, /*std::vector<IController* >*/TControllersVector& m_arrController);
	void SaveCController(CController * pController, CSaverCGF& saver);
	void SaveWaveletController(CCompressedController * pController, CSaverCGF& saver);
	bool GetError(std::vector< std::vector<DebugJoint> >& arrSkeletons1, std::vector< std::vector<DebugJoint> >& arrSkeletons2, int nJoint, float error);

	void ReverseTracks();

public:
	DWORD		m_dwTimestamp;
private:

	GlobalAnimationHeader m_GlobalAnimationHeader;
	GlobalAnimationHeader m_CompressedAnimation;
	GlobalAnimationHeader m_LastGoodAnimation;
	CSkeletonInfo * m_pInfo;
	SAnimationDesc m_AnimDesc;
	std::string m_sName;
	CChunkFile m_ChunkFile;
	bool m_bNewFormat;
	bool m_bOldFormat;
	bool m_bTCBFormat;
	std::vector<ColorRGB> g_arrDistMap24;

	int GAID;

};

#endif