#include "stdafx.h"

#include "AnimationLoader.h"
#include "CompressionController.h"
#include "ControllerPQ.h"


void CCompressonator::SetDirection(float dir, Quat& quat)
{
	//if (dir == ED_Identity)
	//{
	//	quat.SetRotationZ(0);
	//}
	//else
	//	if (dir == ED_L90)
	//	{
	//		quat.SetRotationZ(ABS_L90);
	//	}
	//	else
	//		if (dir == ED_R90)
	//		{
	//			quat.SetRotationZ(ABS_R90);
	//		}
	//		else
	//			if (dir == ED_180)
	//			{
	//				quat.SetRotationZ(ABS_R180);
	//			}

	quat.SetRotationZ(dir);
}

void CCompressonator::CreateWaveletCompression(GlobalAnimationHeader& header, GlobalAnimationHeader& newheader, CompressionInfo& info)
{

	//!!!!!!!!!!!!!!!!!!!!!!!!!!
	// FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!FIXME!
	return;

	GlobalAnimationHeader temp;
	temp = header;

	// fixme!!!
	//	CreateCompression(header, temp, info, 0);

	int TotalCompressed = 0;
	int OldCompression = 0;

	for (uint32 c = 0; c < header.m_arrController.size(); ++c )
	{

		CCompressedController * pNewController = new CCompressedController;

		CController * pCController  = dynamic_cast<CController*>(temp.m_arrController[c].get());

		if (!pCController)
		{
			assert(false);
			return;
		}

		pNewController->SetPositionController(pCController->GetPositionController());
		pNewController->SetRotationController(pCController->GetRotationController());

		pNewController->Compress(/*pCController);//*/header.m_arrController[c]);

		TotalCompressed += pNewController->GetCompressedSize();

		if (pCController->GetRotationController())
			OldCompression += pCController->GetRotationController()->GetRotationStorage()->GetDataRawSize();

		if (pCController->GetPositionController())
			OldCompression += pCController->GetPositionController()->GetPositionStorage()->GetDataRawSize();

		newheader.m_arrController[c] = pNewController;
		pNewController->m_pGlobalAnimationHeader = &newheader;
		pNewController->m_nControllerId = pCController->m_nControllerId;
	}

	float res = (float)OldCompression / (float)TotalCompressed;




}

void CCompressonator::FillTrackInfo(GlobalAnimationHeader &header, uint32 c, uint32 &curControllerId, std::vector<Quat>& Rotations, std::vector<Vec3>& Positions, std::vector<int>& RotTimes, std::vector<int>& PosTimes)
{
	CControllerPQLog * pController = dynamic_cast<CControllerPQLog *>(header.m_arrController[c].get());

	if (pController)
	{
		Rotations.clear();
		Positions.clear();
		PosTimes.clear();
		RotTimes.clear();

		Rotations.reserve(pController->m_arrTimes.size());
		Positions.reserve(pController->m_arrTimes.size());
		PosTimes.reserve(pController->m_arrTimes.size());
		RotTimes.reserve(pController->m_arrTimes.size());

		curControllerId = pController->m_nControllerId;

		int32 oldtime =  -1;

		for (uint32 i = 0; i < pController->m_arrTimes.size(); ++i)
		{
			if (oldtime != pController->m_arrTimes[i])
			{
				oldtime = pController->m_arrTimes[i];
				Rotations.push_back(!exp(pController->m_arrKeys[i].vRotLog));
				Positions.push_back(pController->m_arrKeys[i].vPos);
				RotTimes.push_back(pController->m_arrTimes[i]);
				PosTimes.push_back(pController->m_arrTimes[i]);

			}
		}
	}
	else
	{
		CController * pCController  = dynamic_cast<CController*>(header.m_arrController[c].get());

		if (!pCController)
		{
			assert(false);
			return;
		}

		Rotations.resize(pCController->GetRotationController()->GetNumKeys());
		RotTimes.resize(pCController->GetRotationController()->GetNumKeys());

		Positions.resize(pCController->GetPositionController()->GetNumKeys());
		PosTimes.resize(pCController->GetPositionController()->GetNumKeys());

		curControllerId = pCController->m_nControllerId;
		for (uint32 i = 0; i < RotTimes.size(); ++i)
		{
				pCController->GetRotationController()->GetValueFromKey(i, m_Rotations[i]);//!exp(pController->m_arrKeys[i].vRotLog);
				RotTimes[i] = pCController->GetRotationController()->GetTimeFromKey(i);//pController->m_arrTimes[i];
		}
		for (uint32 i = 0; i < PosTimes.size(); ++i)
		{
				pCController->GetPositionController()->GetValueFromKey(i, m_Positions[i]);//pController->m_arrKeys[i].vPos;
				PosTimes[i] = pCController->GetPositionController()->GetTimeFromKey(i);//pController->m_arrTimes[i];
		}
	}
}



void CCompressonator::CreateCompression(GlobalAnimationHeader& header, GlobalAnimationHeader& newheader, CompressionInfo& info, CSkeletonInfo * skeleton, SAnimationDesc& desc, int GAID )
{
	m_Rotations.clear();
	m_Positions.clear();
	m_Scales.clear();

	int skiprot = 0;
	int skippos = 0;
	uint32 curControllerId = -1;

	IController_AutoPtr pRootController;
	int rootBoneTrack = -1;
	uint32 rootBone = 0;
	// found root bone and save original data

	for (uint32 c = 0; c < header.m_arrController.size(); ++c)
	{
		curControllerId = 0;

		CControllerPQLog * pController = dynamic_cast<CControllerPQLog *>(header.m_arrController[c].get());
		if (pController)
		{
			curControllerId = pController->m_nControllerId;
		}
		else
		{
			CController * pCController  = dynamic_cast<CController*>(header.m_arrController[c].get());

			if (!pCController)
			{
				assert(false);
				return;
			}
			curControllerId = pCController->m_nControllerId;
		}

		uint32 be = skeleton->m_SkinningInfo.m_arrBonesDesc.size();
		int boneNumber = -1;
		for (uint32 b = 0; b < be; ++b)
		{
			if (skeleton->m_SkinningInfo.m_arrBonesDesc[b].m_nControllerID == curControllerId)
			{
				boneNumber = b;
//				break;
			}

			if (skeleton->m_SkinningInfo.m_arrBonesDesc[b].m_nOffsetParent == 0)
			{
				rootBone = b;
			}
		}

		if (boneNumber != -1)
		{
			if (skeleton->m_SkinningInfo.m_arrBonesDesc[boneNumber].m_nOffsetParent == 0)
			{
				//uint32 parentNumber = boneNumber + skeleton->m_SkinningInfo.m_arrBonesDesc[boneNumber].m_nOffsetParent;
				// root bone!
				//FillTrackInfo(header, c, curControllerId, rootRotations, rootPositions, rootTimes);
				pRootController = header.m_arrController[c];
				rootBone = boneNumber;
				rootBoneTrack = c;
//				break;
			}
		}
		else {

			//char buf[255]; 
			//sprintf(buf, "\n%s",header.m_arrBoneNameTable[c]);
			//OutputDebugStr(buf);
			
//			skeleton->m_SkinningInfo.
		}
	}



	for (uint32 c = /*info.m_SkipBones*/ 0 ; c < header.m_arrController.size(); ++c)
	{
		CompressionLevelInfo *currentInfo = info.GetInfo(c);
		if (currentInfo == 0)
			currentInfo = info.GetInfo(3);

		FillTrackInfo(header, c, curControllerId, m_Rotations, m_Positions, m_RotTimes, m_PosTimes);

		bool bIdenticalPos(true);
		bool bIdenticalRot(true);

		// rotate root & childroot
		uint32 be = skeleton->m_SkinningInfo.m_arrBonesDesc.size();
		int boneNumber = -1;
		for (uint32 b = 0; b < be; ++b)
		{
			if (skeleton->m_SkinningInfo.m_arrBonesDesc[b].m_nControllerID == curControllerId)
			{
				boneNumber = b;
				break;
			}
		}

		if (rootBoneTrack == c)
		{
			// root bone. Rotate
			Quat rotRot;
			Quat rotPos;
			SetDirection(desc.m_RotatePosRoot, rotPos);
			SetDirection(desc.m_RotateQuatRoot, rotRot);

			uint32 count = m_RotTimes.size();
			for (uint32 s = 0; s < count; ++s)
			{
				m_Rotations[s] = rotRot * m_Rotations[s];
			}

			count = m_PosTimes.size();
			for (uint32 s = 0; s < count; ++s)
			{
				m_Positions[s] = rotPos * m_Positions[s]; 
			}

		}
		else
		{
			if (boneNumber != -1)
			{
				uint32 parentNumber = boneNumber + skeleton->m_SkinningInfo.m_arrBonesDesc[boneNumber].m_nOffsetParent;

				if (parentNumber == 0)
				{
					// root bone child
					Quat rotRot;
					Quat rotPos;
					SetDirection(desc.m_RotatePosChild, rotPos);
					SetDirection(desc.m_RotateQuatChild, rotRot);

					// Rotations
					uint32 count = m_RotTimes.size();
					for (uint32 s = 0; s < count; ++s)
					{
						bool bWeapon =  desc.m_Weapon > 0;

						bIdenticalPos = false;
						bIdenticalRot = false;

						if (bWeapon)
						{
							Quat oldRot;
							Vec3 oldPos; 
							float norm_time = 0.0f; 
							norm_time = (m_RotTimes[s]  - header.m_fStartSec * TICKS_PER_SECOND) / (TICKS_PER_SECOND * (header.m_fEndSec - header.m_fStartSec));

							if (pRootController)
							{
								pRootController->GetO(GAID, norm_time, oldRot);
								pRootController->GetP(GAID, norm_time, oldPos);
							}
							else
							{
								// no root bone controller

								QuatT val = QuatT(skeleton->m_SkinningInfo.m_arrBonesDesc[rootBone].m_DefaultB2W);
								oldRot = val.q;
								oldPos = val.t;
							}


							Matrix34 src(oldRot);
							src.SetTranslation(oldPos);

							Matrix34 res(m_Rotations[s]);
							res.SetTranslation(m_Positions[s]);

							Matrix34 absolute = src * res;

							Quat absolute180Rot = rotRot*Quat(absolute);
							Vec3 absPos = absolute.GetTranslation();
							Vec3 absolute180Pos = rotPos*absPos;


							Matrix34 absolute180(absolute180Rot);
							absolute180.SetTranslation(absolute180Pos);
							
							newheader.m_arrController[0]->GetO(GAID, norm_time, oldRot);
							newheader.m_arrController[0]->GetP(GAID, norm_time, oldPos);

							Matrix34 newsrc(oldRot);
							newsrc.SetTranslation(oldPos);

							res = newsrc.GetInverted() * absolute180;
							m_Rotations[s] = Quat(res);
//							m_Positions[s] = res.GetTranslation();
						}
						else
						{
//							m_Positions[s] = rotPos * m_Positions[s]; 
							m_Rotations[s] = rotRot * m_Rotations[s];
						}


					}

					//Positions
					count = m_PosTimes.size();
					for (uint32 s = 0; s < count; ++s)
					{
						bool bWeapon =  desc.m_Weapon > 0;

						bIdenticalPos = false;
						bIdenticalRot = false;

						if (bWeapon)
						{
							Quat oldRot;
							Vec3 oldPos; 
							float norm_time = 0.0f; 
							norm_time = (m_RotTimes[s]  - header.m_fStartSec * TICKS_PER_SECOND) / (TICKS_PER_SECOND * (header.m_fEndSec - header.m_fStartSec));

							if (pRootController)
							{
								pRootController->GetO(GAID, norm_time, oldRot);
								pRootController->GetP(GAID, norm_time, oldPos);
							}
							else
							{
								// no root bone controller

								QuatT val = QuatT(skeleton->m_SkinningInfo.m_arrBonesDesc[rootBone].m_DefaultB2W);
								oldRot = val.q;
								oldPos = val.t;
							}


							Matrix34 src(oldRot);
							src.SetTranslation(oldPos);

							Matrix34 res(m_Rotations[s]);
							res.SetTranslation(m_Positions[s]);

							Matrix34 absolute = src * res;

							Quat absolute180Rot = rotRot*Quat(absolute);
							Vec3 absPos = absolute.GetTranslation();
							Vec3 absolute180Pos = rotPos*absPos;


							Matrix34 absolute180(absolute180Rot);
							absolute180.SetTranslation(absolute180Pos);

							newheader.m_arrController[0]->GetO(GAID, norm_time, oldRot);
							newheader.m_arrController[0]->GetP(GAID, norm_time, oldPos);

							Matrix34 newsrc(oldRot);
							newsrc.SetTranslation(oldPos);

							res = newsrc.GetInverted() * absolute180;
//							m_Rotations[s] = Quat(res);
							m_Positions[s] = res.GetTranslation();
						}
						else
						{
							m_Positions[s] = rotPos * m_Positions[s]; 
//							m_Rotations[s] = rotRot * m_Rotations[s];
						}


					}

				}
			}
		}

		if(boneNumber != -1)
		{
			uint32 parentNumber = boneNumber + skeleton->m_SkinningInfo.m_arrBonesDesc[boneNumber].m_nOffsetParent;
		}
		// check is it track useful?

		uint32 size = m_Rotations.size();
		Quat rot = m_Rotations[0];
		Vec3 pos = m_Positions[0];

		for (uint32 i = 1; i < size; ++i)
		{	
			if (!rot.IsEquivalent(m_Rotations[i]))//,0.0000001f))
			{
				bIdenticalRot = false;
				break;
			}
		}

		size = m_Positions.size();
		for (uint32 i = 1; i < size; ++i)
		{	
			if (!pos.IsEquivalent(m_Positions[i]))//,0.0000001f))
			{
				bIdenticalPos = false;
				break;
			}
		}


		bool bSinglePos(false);
		bool bSingleRot(false);

		if (bIdenticalRot || bIdenticalPos)
		{
			// check with reference model
			if (skeleton == 0)
			{
				bIdenticalRot = false;
				bIdenticalPos = false;
			}

			// get relative quat from skeleton
			if (boneNumber != -1)
			{
				Quat testQuat;
				Vec3 testPos;
				QuatT val;

				if (skeleton->m_SkinningInfo.m_arrBonesDesc[boneNumber].m_nOffsetParent != 0)
				{
					val = QuatT(skeleton->m_SkinningInfo.m_arrBonesDesc[boneNumber + skeleton->m_SkinningInfo.m_arrBonesDesc[boneNumber].m_nOffsetParent ].m_DefaultW2B * skeleton->m_SkinningInfo.m_arrBonesDesc[boneNumber].m_DefaultB2W);
				}
				else
				{
					val = QuatT(skeleton->m_SkinningInfo.m_arrBonesDesc[boneNumber].m_DefaultB2W);
				}

				testQuat = val.q;
				testPos = val.t;

				if (bIdenticalRot && !rot.IsEquivalent(testQuat))//,0.0000001f))
				{
					bIdenticalRot = false;
					//					bSingleRot = true;
				}

				if (bIdenticalPos && !pos.IsEquivalent(testPos/*,0.000001f*/))//,0.0000001f))
				{
					bIdenticalPos = false;
					//					bSinglePos = true;
				}
			}
			else
			{
				bIdenticalRot = false;
				bIdenticalPos = false;
			}
		}

		//		 no need to store this track. remove it
		if (bIdenticalPos && bIdenticalRot && (c > 0) && (currentInfo->m_DeleteRot > 0)  && (currentInfo->m_DeletePos > 0) )
		{
			newheader.m_arrController[c] = 0;//pNewController[minIndex];
			continue;
		}

		if (bIdenticalPos && (c > 0) && (currentInfo->m_DeletePos > 0) )
		{
			currentInfo->m_bPosCompression = eSkipTrack;
		}

		if (bIdenticalRot && (c > 0) && (currentInfo->m_DeleteRot > 0) )
		{
			currentInfo->m_bRotCompression = eSkipTrack;
		}

		ECompressionInformation types[] = {	eNoCompressQuat, eSmallTree48BitQuat, eSmallTree64BitExtQuat}; 
		uint32 typesSize = 3;

		if (currentInfo->m_RotationFormat != eAutomaticQuat)
		{
			typesSize = 1;
			types[0] = (ECompressionInformation)currentInfo->m_RotationFormat;
		}

		//CController * pNewController[typesSize];
		std::vector<CController *> pNewController(typesSize);

		uint32 minSize = -1;
		uint32 minIndex;

		for (uint32 format = 0; format < typesSize; ++ format)
		{
			pNewController[format] = new CController;
			currentInfo->m_RotationFormat = types[format];


			if (currentInfo->m_bRotCompression != eSkipTrack)
				CompressRotations(pNewController[format], currentInfo, bSingleRot);

			if (currentInfo->m_bPosCompression != eSkipTrack)
				CompressPositions(pNewController[format], currentInfo, bSinglePos);

			pNewController[format]->m_nControllerId = header.m_arrController[c]->GetID();

			uint32 currentSize = pNewController[format]->SizeOfThis();
			if (currentSize < minSize)
			{
				minSize = currentSize;
				minIndex = format;
			}
		}

		if (currentInfo->m_bRotCompression == eUseOld && currentInfo->m_bPosCompression == eUseOld)
			pNewController[minIndex] = (CController*)header.m_arrController[c].get();
		header.m_arrController[c]->AddRef();


		pNewController[minIndex]->m_pGlobalAnimationHeader = &newheader;
		newheader.m_arrController[c] = pNewController[minIndex];

		for (uint32 format = 0; format < typesSize; ++ format)
		{
			if (format != minIndex)
				delete pNewController[format] ;
		}
	}

}

// return true if difference between 2 quats is bigger than error
bool error_quat(Quat& q1, Quat& q2, float error)
{
	Float4Storage dist;

	dist.x= fabs(q1.v.x) - fabs(q2.v.x);
	dist.y= fabs(q1.v.y) - fabs(q2.v.y);
	dist.z= fabs(q1.v.z) - fabs(q2.v.z);
	dist.w= fabs(q1.w) - fabs(q2.w);

	float curerr = dist.x * dist.x  + dist.y * dist.y + dist.z * dist.z + dist.w * dist.w;
	if ( curerr > error)//0.00001f)
	{
		return true;
	}

	return false;
}

bool error_vec3(Vec3& q1, Vec3& q2, float error)
{
	Vec3 dist;

	dist.x= fabs(q1.x) - fabs(q2.x);
	dist.y= fabs(q1.y) - fabs(q2.y);
	dist.z= fabs(q1.z) - fabs(q2.z);
	//	dist.w= fabs(q1.w) - fabs(q2.w);

	float curerr = dist.x * dist.x  + dist.y * dist.y + dist.z * dist.z;
	if ( curerr > error)//0.00001f)
	{
		return true;
	}

	return false;
}

BaseCompressedQuat * GetCompressedQuat(int format, int count)
{ 
	switch(format)
	{
	case eNoCompress:
	case eNoCompressQuat:
		return new TNoCompressedQuat[count];

	case eShotInt3Quat:
		return new TShortInt3CompressedQuat[count];

	case eSmallTreeDWORDQuat:
		return new TSmallTreeDWORDCompressedQuat[count];

	case eSmallTree48BitQuat:
		return new TSmallTree48BitCompressedQuat[count];

	case eSmallTree64BitQuat:
		return new TSmallTree64BitCompressedQuat[count];

	case eSmallTree64BitExtQuat:
		return new TSmallTree64BitExtCompressedQuat[count];

	case ePolarQuat:
		return new TPolarQuatQuat[count];
	}

	return 0;
}

BaseCompressedVec3 * GetCompressedVec3(int format, int count)
{
	switch(format)
	{
	case eNoCompressVec3:
	default:
		return new TBaseCompressedVec3[count];
	}

	return 0;
}


void  CCompressonator::CompressRotations(CController * pController, CompressionLevelInfo * pInfo, bool bAddFirst)
{
	// create new controller
	uint32 numKeys = m_Rotations.size();

	KeyTimesInformationPtr pTimes;// = new F32KeyTimesInformation;//CKeyTimesInformation;

	if (m_RotTimes[numKeys-1] < 256)
		pTimes = new ByteKeyTimesInformation;
	else
		if (m_RotTimes[numKeys-1] < 65536)
			pTimes = new UINT16KeyTimesInformation;
		else
			pTimes = new F32KeyTimesInformation;

	
	TrackInformationPtr pNewTrack  =  TrackInformationPtr(new RotationTrackInformation);
	TrackRotationStoragePtr pStorage = ControllerHelper::GetRotationControllerPtr(pInfo->m_RotationFormat);
	pNewTrack->SetRotationStorage(pStorage);
		
	pNewTrack->SetKeyTimesInformation(pTimes);
	pController->SetRotationController( pNewTrack);

	if (bAddFirst)
	{
		pTimes->AddKeyTime(m_RotTimes[0]);
		pStorage->AddValue(m_Rotations[0]);

	}
	else
	{
		unsigned int nextstep = 1;
		uint32 count = 0;
		uint32 lastKey = 0;

		std::auto_ptr<BaseCompressedQuat> currentcompressed( GetCompressedQuat(pInfo->m_RotationFormat,1));
		std::auto_ptr<BaseCompressedQuat> lastcompressed(GetCompressedQuat(pInfo->m_RotationFormat,1)); 

		for (unsigned int iKey = 0; iKey < numKeys; iKey+= nextstep)
		{
			if (pInfo->m_bRotCompression == eCompression)
			{
				currentcompressed->FromQuat(m_Rotations[iKey]);
				Quat tmp = currentcompressed->ToQuat();

				unsigned int iNextKey = iKey + 2;
				for(; iNextKey < numKeys; ++iNextKey)
				{
					lastcompressed->FromQuat(m_Rotations[iNextKey]);
					Quat last = lastcompressed->ToQuat();
					bool result = false;
					for (unsigned int iTest =1; iTest <= iNextKey - iKey; ++iTest)
					{
						float step = (float)iTest/((float)iNextKey - (float)iKey);

						Quat interpolated;
						interpolated.SetSlerp(tmp, last, step);

						if (error_quat(interpolated, m_Rotations[iKey+iTest], pInfo->m_RotationError))
						{
							result = true;
							break;
						}
					}

					if (result)
					{
						// test failed
						iNextKey -= 1;
						break;
					}
				}

				nextstep = iNextKey - iKey; 
				++count;
			}

			pTimes->AddKeyTime(m_RotTimes[iKey]);
			pStorage->AddValue(m_Rotations[iKey]);
			lastKey = iKey;
		}

		if ((lastKey < numKeys - 1))// && (!m_Rotations[numKeys-1].IsEquivalent(m_Rotations[lastKey])))
		{
			pTimes->AddKeyTime(m_RotTimes[numKeys - 1]);
			pStorage->AddValue(m_Rotations[numKeys - 1]);
			++count;
		}
	}
}

void CCompressonator::CompressPositions(CController * pController, CompressionLevelInfo * pInfo, bool bAddFirst)
{
	// create new controller
	uint32 numKeys = m_Positions.size();

	KeyTimesInformationPtr pTimes;// = new F32KeyTimesInformation;//CKeyTimesInformation;
	/*float compressionMaxError = 0.00000001f;*/
	if (m_PosTimes[numKeys-1] < 256)
		pTimes = new ByteKeyTimesInformation;
	else
		if (m_PosTimes[numKeys-1] < 65536)
			pTimes = new UINT16KeyTimesInformation;
		else
			pTimes = new F32KeyTimesInformation;

//	PositionInformationPtr pNewTrack = ControllerHelper::GetPositionControllerPtr(pInfo->m_PositionFormat);
	PositionInformationPtr pNewTrack = PositionInformationPtr(new PositionTrackInformation);

	TrackPositionStoragePtr pStorage = ControllerHelper::GetPositionControllerPtr(pInfo->m_PositionFormat);

	pNewTrack->SetPositionStorage(pStorage);


		//GetCompressedPositionTrack(pInfo->m_PositionFormat);
	pNewTrack->SetKeyTimesInformation(pTimes);
	pController->SetPositionController( pNewTrack);

	if (bAddFirst)
	{
		pTimes->AddKeyTime(m_PosTimes[0]);
		pStorage->AddValue(m_Positions[0]);
	}
	else
	{
		unsigned int nextstep = 1;
		uint32 count = 0;
		unsigned int iLastKey = 0;

		for (unsigned int iKey = 0; iKey < numKeys; iKey+= nextstep)
		{
			if (pInfo->m_bPosCompression == eCompression)
			{
				std::auto_ptr<BaseCompressedVec3> currentcompressed( GetCompressedVec3(pInfo->m_PositionFormat,1));
				currentcompressed->FromVec3(m_Positions[iKey]);
				Vec3 tmp = currentcompressed->ToVec3();

				unsigned int iNextKey = iKey + 2;
				for(; iNextKey < numKeys; ++iNextKey)
				{
					std::auto_ptr<BaseCompressedVec3> lastcompressed(GetCompressedVec3(pInfo->m_PositionFormat,1)); 
					lastcompressed->FromVec3(m_Positions[iNextKey]);
					Vec3 last = lastcompressed->ToVec3();


					bool result = false;
					for (unsigned int iTest =1; iTest <= iNextKey - iKey; ++iTest)
					{
						float step = (float)iTest/((float)iNextKey - (float)iKey);
						//slerp_quats(interpolated, step ,tmp, last); 
						Vec3 interpolated;
						interpolated.SetLerp(tmp, last, step);

						if (error_vec3(interpolated, m_Positions[iKey+iTest], pInfo->m_PositionError))
						{
							result = true;
							break;
						}
					}

					if (result)
					{
						// test failed
						iNextKey -= 1;
						break;
					}
				}

				nextstep = iNextKey - iKey; 
				++count;
			}

			iLastKey = iKey;
			pTimes->AddKeyTime(m_PosTimes[iKey]);
			pStorage->AddValue(m_Positions[iKey]);
		}

		if ((iLastKey < numKeys - 1))
		{
			pTimes->AddKeyTime(m_PosTimes[numKeys - 1]);
			pStorage->AddValue(m_Positions[numKeys - 1]);
			++count;
		}
	}
}



