#ifndef CHARACTER_COMPILER
#define CHARACTER_COMPILER

#include "IConvertor.h"
#include "MeshCompiler\MeshCompiler.h"

struct ConvertContext;
class CContentCGF;
class CChunkFile;
class CPhysicsInterface;
class ICryXML;

struct CCC 
{
	string m_Model;
	f32 m_RotatePosRoot;
	f32 m_RotateQuatRoot;
	f32 m_RotatePosChild;
	f32 m_RotateQuatChild;
};


class CharacterCompiler : public IConvertor, public ICompiler
{
public:
	class Error
	{
	public:
		Error (int nCode);
		Error (const char* szFormat, ...);
		const char* c_str()const {return m_strReason.c_str();}
	protected:
		string m_strReason;
	};

	CharacterCompiler(ICryXML * pXml);
	~CharacterCompiler();

	// IConvertor methods.
	void Init(IConfig* config, IRCLog* log, const char* exePath) {}
	void DeInit() {}
	bool GetOutputFile( ConvertContext &cc );
	ICompiler* CreateCompiler();
	bool SupportsMultithreading() const;
	int GetNumPlatforms() const;
	Platform GetPlatform( int index ) const;
	virtual int GetNumExt() const { return 1; };
	virtual const char* GetExt( int index ) const { return "chr"; };
	DWORD GetTimestamp() const;

	// ICompiler methods.
	bool Process( ConvertContext &cc );

	// ICompiler + IConvertor methods.
	void Release();

private:
	void DeleteOldChunks( CContentCGF *pCGF,CChunkFile &chunkFile );
	CContentCGF* MakeCompiledCGF( CContentCGF *pCGF, std::vector<uint16> *pVertexRemapping, std::vector<uint16> *pIndexRemapping );
	// Physicalize all meshes in cgf.
	void Physicalize( CContentCGF *pCGF );
	bool LoadCharacterConversionFile( const char* FilePath );

private:
	mesh_compiler::CMeshCompiler m_meshCompiler;
	CPhysicsInterface *m_pPhysicsInterface;
	std::vector<CCC> m_arrCrysisCharacterConversion;

	ICryXML * m_pXML;


	int m_refCount;
};

#endif