////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2001-2005.
// -------------------------------------------------------------------------
//  File name:   FileUtils.h
//  Version:     v1.00
//  Created:     15/11/2004 by Timur.
//  Compilers:   Visual Studio.NET 2003
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __CryFile_h__
#define __CryFile_h__
#pragma once

//////////////////////////////////////////////////////////////////////////
// Substitude of Engine CryFile.
//////////////////////////////////////////////////////////////////////////

// [MichaelS 16/11/2005]
// This class used to be called CCryFile (the same name as a class in the engine).
// However, CryPath.h was changed so that it indirectly included the engine CCryFile,
// causing this not to build. The fix that was least dodgy was to rename this class.
class CCryFile_RC
{
public:
	CCryFile_RC() { m_file = 0; }
	CCryFile_RC( const char *filename, const char *mode )
	{
		m_file = 0;
		Open( filename,mode );
	}
	~CCryFile_RC() { Close(); }

	bool Open( const char *filename, const char *mode )
	{
		m_filename = filename;
		m_file = fopen(filename,mode);
		return m_file != 0;
	}
	void Close()
	{
		if (m_file)
			fclose(m_file);
	}

	//! Writes data in a file to the current file position.
	size_t Write( void *lpBuf,size_t nSize ) { return fwrite(lpBuf,1,nSize,m_file); };
	//! Reads data from a file at the current file position.
	size_t Read( void *lpBuf,size_t nSize ) { return fread(lpBuf,1,nSize,m_file); } ;
	//! Retrieves the length of the file.
	size_t GetLength()
	{
		long curr = ftell(m_file);
		fseek( m_file,0,SEEK_END );
		long size = ftell(m_file);
		fseek(m_file,curr,SEEK_SET);
		return size;
	}

	//! Positions the current file pointer.
	size_t Seek( size_t seek, int mode ) { return fseek(m_file,seek,mode); }
	//! Positions the current file pointer at the beginning of the file.
	void SeekToBegin() { Seek(0,SEEK_SET); };
	//! Positions the current file pointer at the end of the file.
	size_t SeekToEnd() { Seek(0,SEEK_END); };
	//! Retrieves the current file pointer.
	size_t GetPosition() { return ftell(m_file); };

	//! Tests for end-of-file on a selected file.
	bool IsEof() { return feof(m_file) != 0; };

	//! Flushes any data yet to be written.
	void Flush() {};

	//! A handle to a pack object.
	FILE* GetHandle() const { return m_file; };

	// Description:
	//    Retrieves the filename of the selected file.
	const char* GetFilename() const { return m_filename.c_str(); };

	// Description:
	//    Retrieves the filename after adjustment to the real relative to engine root path.
	//    Ex. original filename "textures/red.dds" adjusted filename will look like "game/textures/red.dds"
	// Return:
	//    Adjusted filename, this is a pointer to a static string, copy return value if you want to keep it.
	const char* GetAdjustedFilename() const;

	//! Check if file is opened from pak file.
	bool IsInPak() const;

	//! Get path of archive this file is in.
	const char* GetPakPath() const;

private:
	string m_filename;
	FILE *m_file;
};

#endif // __CryFile_h__
