////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2001-2004.
// -------------------------------------------------------------------------
//  File name:   MeshCompiler.h
//  Version:     v1.00
//  Created:     5/11/2004 by Timur.
//  Compilers:   Visual Studio.NET 2003
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __MeshCompiler_h__
#define __MeshCompiler_h__
#pragma once

#include "IIndexedMesh.h"

// Max number of sub materials in mesh.
#define MAX_SUB_MATERIALS 32

namespace mesh_compiler
{
	/*
#define TANG_FLOATS 1
#ifdef TANG_FLOATS
	typedef float uint8f;
#else
	typedef uint8 uint8f;
#endif

	typedef Vec4_tpl<uint8f> Vec4bf;		//used for tangents only

	_inline uint8f tPackF2B(float f)
	{
#ifdef TANG_FLOATS
		return f;
#else
		return (uint8f)((f + 1.0f) / 2.0f * 255.0f);
#endif
	}
	_inline float tPackB2F(uint8f i)
	{
#ifdef TANG_FLOATS
		return i;
#else
		return (float)((float)i / 255.0f * 2.0f - 1.0f);
#endif
	}
	*/

	enum EMeshCompileFlags
	{
		MESH_COMPILE_OPTIMIZE = 0x0001,
		MESH_COMPILE_TANGENTS = 0x0002,
	};

	//////////////////////////////////////////////////////////////////////////
	class CMeshCompiler
	{
	public:
		CMeshCompiler();
		~CMeshCompiler();

		// for flags see EMeshCompilerFlags
		bool Compile( CMesh &mesh,int flags=(MESH_COMPILE_TANGENTS|MESH_COMPILE_OPTIMIZE) );

		void ReduceMeshToLevel( CMesh &mesh,float fLevel );

		// Remap indices for all compile operations.
		void SetVertexRemapping( std::vector<uint16> *pVertexMap ) { m_pVertexMap = pVertexMap; };
		void SetIndexRemapping( std::vector<uint16> *pIndexMap ) { m_pIndexMap = pIndexMap; };
		void SetFaceRemapping( std::vector<uint16> *pMapFaceToFace0 ) { m_pMapFaceToFace0 = pMapFaceToFace0; };

		void ShareVertices( CMesh &mesh );

		// Weld positions and indices.
		// All vertices that are closer to each other then fEpsilon
		// are welded together and the new position array is re-indexed.
		// Optionally return index remaping from new to old vertex indices in pIndicesRemap.
		void WeldPositions( Vec3 *pVertices, int &nVerts, std::vector<int> &indices,float fEpsilon=VEC_EPSILON );

		bool CompareMeshes( CMesh &mesh1,CMesh &mesh2 );

		const char* GetLastError() { return m_LastError; }

	private:
		void CompactBuffer( CMesh &mesh,uint8 *vertexMatId );
		bool CheckForDegenerateFaces( CMesh &mesh );
		void FindVertexRanges( CMesh &mesh );
		bool StripifyMesh( CMesh &mesh );
		void UpdateFaces( CMesh &mesh );

	private:
		struct SBasisFace {
			uint16 v[3];
		};
		std::vector<uint16> m_tempIndices;
		std::vector<SMeshFace*> m_vhash_table[MAX_SUB_MATERIALS];
		std::vector<SBasisFace> m_thash_table[MAX_SUB_MATERIALS];
		std::vector<uint16> m_index_hash_table[256];
		
		std::vector<uint16> *m_pVertexMap;
		std::vector<uint16> *m_pIndexMap;
		std::vector<uint16> *m_pMapFaceToFace0;

		string m_LastError;
	};
};

#endif // __MeshCompiler_h__
