#ifndef STAT_CGF_COMPILER
#define STAT_CGF_COMPILER

#include "Cry_Color.h"
#include "IConvertor.h"
#include "MeshCompiler\MeshCompiler.h"

struct ConvertContext;
class CContentCGF;
class CChunkFile;
class CPhysicsInterface;
struct CMaterialCGF;

class CStatCFGCompiler : public IConvertor, public ICompiler
{
public:
	class Error
	{
	public:
		Error (int nCode);
		Error (const char* szFormat, ...);
		const char* c_str()const {return m_strReason.c_str();}
	protected:
		string m_strReason;
	};

	CStatCFGCompiler();
	~CStatCFGCompiler();

	// IConvertor methods.
	void Init(IConfig* config, IRCLog* log, const char* exePath) {}
	void DeInit() {}
	bool GetOutputFile( ConvertContext &cc );
	int GetNumPlatforms() const;
	ICompiler* CreateCompiler();
	bool SupportsMultithreading() const;
	Platform GetPlatform( int index ) const;
	virtual int GetNumExt() const { return 2; };
	virtual const char* GetExt( int index ) const { return index ? "cga" : "cgf"; };
	DWORD GetTimestamp() const;

	// ICompiler methods.
	bool Process( ConvertContext &cc );

	// ICompiler + IConvertor methods.
	void Release();

private:
	void DeleteOldChunks( CContentCGF *pCGF,CChunkFile &chunkFile );

private:
	mesh_compiler::CMeshCompiler m_meshCompiler;
	CPhysicsInterface *m_pPhysicsInterface;

	int m_refCount;
};

#endif