#include "stdafx.h"
#include "StaticObjectCompiler.h"
#include "StatCGFPhysicalize.h"
#include "StatCGFSHCompiler.h"
#include "MeshCompiler\MeshCompiler.h"

CStaticObjectCompiler::CStaticObjectCompiler(CPhysicsInterface *pPhysicsInterface)
:	m_pPhysicsInterface(pPhysicsInterface)
{
}

//////////////////////////////////////////////////////////////////////////
CContentCGF* CStaticObjectCompiler::MakeCompiledCGF( CContentCGF *pCGF )
{
	CContentCGF *pCompiledCGF = new CContentCGF( pCGF->GetFilename() );
	*pCompiledCGF->GetExportInfo() = *pCGF->GetExportInfo(); // Copy export info.
	*pCompiledCGF->GetPhysiclizeInfo() = *pCGF->GetPhysiclizeInfo();

	int nMeshCompileFlags = mesh_compiler::MESH_COMPILE_TANGENTS | mesh_compiler::MESH_COMPILE_OPTIMIZE;

	if (pCGF->GetMergedMesh())
	{
		strcpy( g_sCurrentNode,"Merged" );

		// Compile single merged mesh.
		mesh_compiler::CMeshCompiler meshCompiler;
		if (!meshCompiler.Compile( *pCGF->GetMergedMesh(), nMeshCompileFlags))
		{
			LogError( "Failed to compile geometry file %s - %s",pCGF->GetFilename(),meshCompiler.GetLastError() );
			delete pCompiledCGF;
			return 0;
		}
		//////////////////////////////////////////////////////////////////////////
		// Add single node for merged mesh.
		CNodeCGF *pNode = new CNodeCGF;
		pNode->type = CNodeCGF::NODE_MESH;
		pNode->name = "Merged";
		pNode->localTM.SetIdentity();
		pNode->worldTM.SetIdentity();
		pNode->pos.Set(0,0,0);
		pNode->rot.SetIdentity();
		pNode->scl.Set(1,1,1);
		pNode->bIdentityMatrix = true;
		pNode->pMesh = new CMesh;
		pNode->pMesh->Copy( *pCGF->GetMergedMesh() );
		pNode->pParent = NULL;
		pNode->pMaterial = pCGF->GetCommonMaterial();
		pNode->nPhysicalizeFlags = 0;

		if(!CalculateSHCoefficientsForMesh(pNode->pMesh, pCGF, pNode->pMaterial))
			LogError( "Failed to process spherical harmonic coefficients for geometry file %s",pCGF->GetFilename() );

		// Add node to CGF contents.
		pCompiledCGF->AddNode( pNode );

		//////////////////////////////////////////////////////////////////////////
	}
	else
	{
		// Compile meshes in nodes. 
		uint32 numNodes = pCGF->GetNodeCount();
		int i,j,len;

		for(i=0; i<numNodes; i++) 
			pCGF->GetNode(i)->bHasFaceMap = false;

		for(i=0; i<numNodes; i++) 
		{
			CNodeCGF *pNodeCGF = pCGF->GetNode(i), *pNodeCGF1;
			if (pNodeCGF->pMesh && !pNodeCGF->bPhysicsProxy && pNodeCGF->type==CNodeCGF::NODE_MESH && 
					(len=strlen(pNodeCGF->name))>10 && !strcmp((const char*)pNodeCGF->name+len-10,"_Destroyed"))
				for(j=0; j<numNodes; j++)	if (i!=j && !strncmp((pNodeCGF1=pCGF->GetNode(j))->name,pNodeCGF->name,len-10) && pNodeCGF1->name[len-10]==0)
					pNodeCGF1->bHasFaceMap = pNodeCGF->bHasFaceMap = true;
		}

		for (i=0; i<numNodes; i++)
		{
			CNodeCGF *pNodeCGF = pCGF->GetNode(i);
			if (!pNodeCGF->pMesh || pNodeCGF->bPhysicsProxy || pNodeCGF->type != CNodeCGF::NODE_MESH)
				continue;

			strcpy( g_sCurrentNode,pNodeCGF->name.c_str() );

			mesh_compiler::CMeshCompiler meshCompiler;
			if (pNodeCGF->bHasFaceMap)
				meshCompiler.SetFaceRemapping(&pNodeCGF->mapFaceToFace0);

			if (!meshCompiler.Compile( *pNodeCGF->pMesh, nMeshCompileFlags))
			{
				LogError( "Failed to compile geometry file %s - %s",pCGF->GetFilename(),meshCompiler.GetLastError() );
				delete pCompiledCGF;
				return 0;
			}
			//now check whether any sh coefficients are required and if so, compute them, check all materials/submaterials for this cgf
			if(!CalculateSHCoefficientsForMesh(pNodeCGF->pMesh, pCGF, pNodeCGF->pMaterial))
				LogError( "Failed to process spherical harmonic coefficients for geometry file %s",pCGF->GetFilename() );

			pCompiledCGF->AddNode(pNodeCGF);
		}
	}

	uint32 numNodes = pCGF->GetNodeCount();
	for (int i=0; i<numNodes; i++)
	{
		CNodeCGF *pNodeCGF = pCGF->GetNode(i);
		
		if (pNodeCGF->bPhysicsProxy || pNodeCGF->type != CNodeCGF::NODE_MESH)
		{
			strcpy( g_sCurrentNode,pNodeCGF->name.c_str() );

			// If no indices in mesh, try to compile it.
			if (pNodeCGF->pMesh && pNodeCGF->pMesh->GetIndexCount() == 0)
			{
				//////////////////////////////////////////////////////////////////////////
				// Compile mesh.
				//////////////////////////////////////////////////////////////////////////
				mesh_compiler::CMeshCompiler meshCompiler;
				if (!meshCompiler.Compile( *pNodeCGF->pMesh,nMeshCompileFlags ))
				{
					LogError( "Failed to compile geometry in node %s in file %s - %s",pNodeCGF->name.c_str(),pCGF->GetFilename(),meshCompiler.GetLastError() );
					delete pCompiledCGF;
					return 0;
				}
			}
			pCompiledCGF->AddNode(pNodeCGF);
		}
	}

	//////////////////////////////////////////////////////////////////////////
	// Check if any duplicate meshes exist, and try to share them.
	{
		mesh_compiler::CMeshCompiler meshCompiler;
		numNodes = pCompiledCGF->GetNodeCount();
		for (int i = 0; i < numNodes-1; i++)
		{
			CNodeCGF *pNode1 = pCompiledCGF->GetNode(i);
			if (!pNode1->pMesh || pNode1->pSharedMesh)
				continue;
			for (int j = i+1; j < numNodes; j++)
			{
				CNodeCGF *pNode2 = pCompiledCGF->GetNode(j);
				if (pNode1 == pNode2 || !pNode2->pMesh)
					continue;

				if (meshCompiler.CompareMeshes( *pNode1->pMesh,*pNode2->pMesh ))
				{
					// Meshes are same, share them.
					delete pNode2->pMesh;
					pNode2->pMesh = pNode1->pMesh;
					pNode2->pSharedMesh = pNode1;
				}
			}
		}
		//////////////////////////////////////////////////////////////////////////

	}

	uint32 numNodes2 = pCGF->GetNodeCount();
	Physicalize( pCompiledCGF,pCGF );

	return pCompiledCGF;
}

//////////////////////////////////////////////////////////////////////////
void CStaticObjectCompiler::Physicalize( CContentCGF *pCompilerCGF,CContentCGF *pSrcCGF )
{
	//if (!m_pPhysicsInterface)
	//	m_pPhysicsInterface = new CPhysicsInterface;
	int i;

	bool bCgfHavePhysProxy = false;
	for (i = 0; i < pCompilerCGF->GetNodeCount(); i++)
	{
		CNodeCGF *pNode = pCompilerCGF->GetNode(i);
		if (pNode->pMesh && pNode->bPhysicsProxy)
			bCgfHavePhysProxy = true;
	}

	for (i = 0; i < pCompilerCGF->GetNodeCount(); i++)
	{
		CNodeCGF *pNode = pCompilerCGF->GetNode(i);
		if (!pNode->pMesh)
			continue;
		if (bCgfHavePhysProxy && !pNode->bPhysicsProxy)
			continue;

		m_pPhysicsInterface->Physicalize( pNode,pCompilerCGF );
	}
	for (i = 0; i < pCompilerCGF->GetNodeCount(); i++)
	{
		CNodeCGF *pNode = pCompilerCGF->GetNode(i);
		if (!pNode->pMesh)
			continue;
		m_pPhysicsInterface->DeletePhysicalProxySubsets( *pNode->pMesh );
	}
	m_pPhysicsInterface->ProcessBreakablePhysics( pCompilerCGF,pSrcCGF );
}

//////////////////////////////////////////////////////////////////////////
const bool CStaticObjectCompiler::CalculateSHCoefficientsForMesh(CMesh *pMesh, CContentCGF *pCGF, const CMaterialCGF* cpMat)
{
	CStatCFGSHCompiler shCompiler(pMesh, pCGF, cpMat);
	return shCompiler.Calculate();
}
