// stdafx.h : include file for standard system include files,
// or project specific include files that are used frequently, but
// are changed infrequently
//

#pragma once


#define NOT_USE_CRY_MEMORY_MANAGER

// Debug STL turned off so we can use intermixed debug/release versions of DLL.
#undef _HAS_ITERATOR_DEBUGGING
#define _HAS_ITERATOR_DEBUGGING 0
#undef _SECURE_SCL
#define _SECURE_SCL 0

#include <assert.h>

#define CRY_ASSERT_TRACE assert

// Define this to prevent including CryAssert (there is no proper hook for turning this off, like the above).
#define __CRYASSERT_H__

#include <platform.h>

#include <malloc.h>			// malloc()
// Windows Header Files:
#ifdef WIN64
#include "PortableString.h"
typedef CPortableString CString;
#else
#include <atlbase.h>
#include <atlstr.h>
#endif


#include <float.h>

#include <string>
#include <set>
#include <map>
#include <vector>
#include <algorithm>

#include <stdio.h>
#include <tchar.h>
#define _ATL_CSTRING_EXPLICIT_CONSTRUCTORS	// some CString constructors will be explicit

#include <Cry_Math.h>
#include <Cry_Geo.h>
#include <CryHeaders.h>
#include <primitives.h>
#include <physinterface.h>
#include <CrySizer.h>
#include <smartptr.h>
// TODO: reference additional headers your program requires here
#ifndef SIZEOF_ARRAY
#define SIZEOF_ARRAY(arr) (sizeof(arr)/sizeof((arr)[0]))

#include "ResourceCompilerPC.h"
#include "StringUtils.h"
#include "FileUtils.h"

#include <VertexFormats.h>

#ifndef WIN64
#include "Dbghelp.h"
#endif

#include "..\ResourceCompiler\FileUtil.h"
#include "..\ResourceCompiler\PathUtil.h"
#include "..\ResourceCompiler\IRCLog.h"


inline void SwapEndians_(void* pData, size_t nCount, size_t nSizeCheck)
{
	// Primitive type.
	switch (nSizeCheck)
	{
	case 1:
		break;
	case 2:
		{
			while (nCount--)
			{
				uint16& i = *((uint16*&)pData)++;
				i = (i>>8) + (i<<8);
			}
			break;
		}
	case 4:
		{
			while (nCount--)
			{
				uint32& i = *((uint32*&)pData)++;
				i = (i>>24) + ((i>>8)&0xFF00) + ((i&0xFF00)<<8) + (i<<24);
			}
			break;
		}
	case 8:
		{
			while (nCount--)
			{
				uint64& i = *((uint64*&)pData)++;
				i = (i>>56) + ((i>>40)&0xFF00) + ((i>>24)&0xFF0000) + ((i>>8)&0xFF000000)
					+ ((i&0xFF000000)<<8) + ((i&0xFF0000)<<24) + ((i&0xFF00)<<40) + (i<<56);
			}
			break;
		}
	default:
		assert(0);
	}
}


template<class T>
void SwapEndians(T* t, std::size_t count)
{
	SwapEndians_(t, count, sizeof(T));
}


template<class T>
void SwapEndians(T& t)
{
	SwapEndians(&t, 1);
}


#endif