// DirBrowse.h - Version 1.0
//
// Author:  Lars Werner
//          lars@werner.no
//
// Description:
//     DirBrowse.h wraps the SHBrowseForFolder() and creates hyperlink text
//     shortcuts on the right of the browserwindow.
//
// History
//     Version 1.0 - 2006 March 13
//     - Initial public release
//
// This software is released into the public domain.  You are free to use it 
// in any way you like.
//
// This software is provided "as is" with no expressed or implied warranty.  
// I accept no liability for any damage or loss of business that this software 
// may cause.
//
///////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_DIRBROWSE_H__75DC1035_935A_4086_A858_6BE1AA4A6AD4__INCLUDED_)
#define AFX_DIRBROWSE_H__75DC1035_935A_4086_A858_6BE1AA4A6AD4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//*******************************************************************************************
//These defs can be set to what you want :)
//*******************************************************************************************
#define BROWSE_WIDTH			640
#define BROWSE_HEIGHT			420
#define BROWSE_LISTVIEW_SIZE	0.65
#define BROWSE_BORDER_VERT		4
#define BROWSE_BORDER_HORI		2
#define BROWSE_MAXENTRIES		20

//This is the message that we start with
#define BROWSE_MESSAGE		10101

//The name of our hypertext class
#define STATIC_HYPERTEXT_WINDOW_CLASS "STATIC_HYPERTEXT"

//This is the font & size we use for showing the info
#define BROWSE_FONTNAME		"Verdana"
#define BROWSE_FONTSIZE		12

//The colors used
#define BROWSE_SELECTCOLOR			RGB(0,0,255)
#define BROWSE_SELECTCOLORHOVER		RGB(50,105,255)
#define BROWSE_DIRCOLOR				RGB(0,0,200)
#define BROWSE_DIRCOLORHOVER		RGB(100,100,250)

//The registry variables
#define BROWSE_REGISTRY_ROOT		HKEY_CURRENT_USER
#define BROWSE_REGISTRY_PATH		"Software\\DirBrowser"

//Strings used
#define BROWSE_TEXT_SHORTCUTS			"Shortcuts"
#define BROWSE_TEXT_HELP				"Please select a folder in the list and press the arrow to save the directory for a quickpick later on"
#define BROWSE_TEXT_HELP_CAPTION		"Browse for folder help"
#define BROWSE_TEXT_HELP_TOOLTIP		"Press this to save selected path as a shortcut" //Must not exceed 79 chars!!!

//*******************************************************************************************

class CDirBrowse  
{
public:
	CDirBrowse(HWND hParent=NULL, HINSTANCE hInstance=NULL);
	virtual ~CDirBrowse();

	//------------------
	//Public functions
	BOOL Show(char *szInitDir="");
	char* GetSelectedDir();
	//------------------

protected:
	

	//------------------
	//Callback on the hyperlink function + other hyperlink related stuff :)
	HCURSOR handcursor;
	static int HyperLinkWnd(HWND hwnd,WORD wMsg,WPARAM wParam,LPARAM lParam);
	HMODULE hModule;
	//------------------

	//------------------
	//Information about the parent
	HWND Parent;
	HINSTANCE hInst;
	//------------------

	//------------------
	//Information about the dirbrowser window with sizes
	HWND DirBrowser;
	RECT RealListView;
	//------------------

private:
	//------------------
	//Simple heap list over selected directories
	char Path[BROWSE_MAXENTRIES][MAX_PATH];
	//------------------

	//------------------
	//Flag for the BROWSER_MESSAGE if it is odd or not
	BOOL MessageIsOdd;
	//------------------

	//------------------
	//Callback on the folderbrowse
	static int __stdcall BrowseCallbackProc(HWND  hwnd,UINT  uMsg,LPARAM  lParam,LPARAM  lpData);
	//------------------

	//------------------
	//This function adds a tooltip to any selected window :)
	void AddToolTip(HWND hwndPar, HINSTANCE hInst);
	//------------------

	//------------------
	//State of mouse and window position variables
	BOOL Hover;
	BOOL Tracking;
	LONG PositionX;
	LONG PositionY;
	//------------------

	//------------------
	//Registry functions
	int nItems;
	void ReadConfig();
	void SaveConfig();
	//------------------

	//------------------
	//Adds a hyperlink and hyperlink selector to the dialog
	void AddItem(int nItem=-1);
	//------------------

	//------------------
	//Variable that stores the selected path
	TCHAR szSelectedDir[MAX_PATH*2];
	//------------------
};

#endif // !defined(AFX_DIRBROWSE_H__75DC1035_935A_4086_A858_6BE1AA4A6AD4__INCLUDED_)
