// DirectoryBrowseWin32.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "..\DirBrowse.h"

#include <stdio.h>

#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <share.h>
#include <stdarg.h>

static const size_t PATH_SZ = 2048;

void error( const char * func )
{
	printf("error occured in %s: %s\n", func, strerror(errno) );
	exit(1);
}

bool isDirectory( const char * path )
{
	struct _stat buffer;
	_stat( path, &buffer );
	if (buffer.st_mode & _S_IFDIR)
		return true;
	else
		return false;
}

bool isReadOnly( const char * path )
{
	struct _stat buffer;
	_stat( path, &buffer );
	if (buffer.st_mode & _S_IWRITE)
		return false;
	else
		return true;
}

void sexecf( char * output, const char * fmt, ... )
{
	char cmd[PATH_SZ];
	va_list args;
	va_start(args, fmt);
	vsprintf(cmd, fmt, args);
	va_end(args);

	FILE * f = _popen( cmd, "rt" );
	if (!f)
		error(cmd);
	while (!feof(f))
	{
		*output++ = fgetc( f );
	}
	*output++ = 0;
	_pclose(f);
}

void execf( const char * fmt, ... )
{
	char cmd[PATH_SZ];
	va_list args;
	va_start(args, fmt);
	vsprintf(cmd, fmt, args);
	va_end(args);

	if (0 != system( cmd ))
		error(cmd);
}

void toPerforcePath( char * perforce, const char * filesystem )
{
	char temp[PATH_SZ*6];
	sexecf( temp, "p4 where %s", filesystem );

	const char * pStart = temp;
	if (*pStart == '-')
		pStart++;
	const char * pEnd = pStart;
	while (*pEnd != ' ' && *pEnd != 0)
		pEnd ++;
	if (!*pEnd)
	{
		errno = EINVAL;
		error("toPerforcePath");
	}
	memcpy( perforce, pStart, pEnd - pStart );
	perforce[pEnd-pStart] = 0;
}

void scanPath( const char * root )
{
	char searchPath[PATH_SZ];

	printf( "SCAN: %s\n", root );

	sprintf( searchPath, "%s\\*.*", root );
	_finddata_t finddata;
	intptr_t i = _findfirst( searchPath, &finddata );
	if (i == -1)
		error("_findfirst");

	do
	{
		char fullPath[PATH_SZ];
		sprintf( fullPath, "%s\\%s", root, finddata.name );

		if (0 == strcmp(finddata.name, "."))
			;
		else if (0 == strcmp(finddata.name, ".."))
			;
		else if (0 == strcmp(finddata.name, "Bin32"))
			;
		else if (0 == strcmp(finddata.name, "BinTemp"))
			;
		else if (isDirectory(fullPath))
			scanPath(fullPath);
		else if (!isReadOnly(fullPath))
		{
			char perforce[PATH_SZ];
			toPerforcePath( perforce, fullPath );
			execf("p4 edit %s", perforce);
		}
	}
	while (0 == _findnext( i, &finddata ));

	_findclose( i );
}

/*
int main(void)
{
	char rootPath[PATH_SZ];

	printf( "enter the path to scan for writeable files: (e.g. 'e:\\game02')\n" );
	scanf( "%s", rootPath );

	scanPath( rootPath );
}
*/

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: Place code here.
	CDirBrowse m_dirbrowser(NULL, hInstance);
	
	if(m_dirbrowser.Show()==TRUE)
	{
		char Text[MAX_PATH*2];
		sprintf(Text, "You selected folder: %s", m_dirbrowser.GetSelectedDir());
		//MessageBox(NULL, Text, "Browse for folder", MB_OK);
		scanPath(m_dirbrowser.GetSelectedDir());
	}
	/*
	else
	{
		MessageBox(NULL, "You pressed the cancel button!", "Browse for folder", MB_OK);
	}
	*/

	return 0;
}
